/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.graphics.layout;

import de.erichseifert.gral.graphics.Container;
import de.erichseifert.gral.graphics.Dimension2D;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.graphics.layout.AbstractLayout;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;

public class TableLayout
extends AbstractLayout {
    private static final long serialVersionUID = -6738742507926295041L;
    private final int cols;
    private static final int COLS = 0;
    private static final int ROWS = 1;

    public TableLayout(int cols, double gapH, double gapV) {
        super(gapH, gapV);
        if (cols <= 0) {
            throw new IllegalArgumentException("Invalid number of columns.");
        }
        this.cols = cols;
    }

    public TableLayout(int cols) {
        this(cols, 0.0, 0.0);
    }

    private Info[] getInfo(Container container) {
        Info[] infos = new Info[]{new Info(), new Info()};
        infos[0].size = this.cols;
        infos[1].size = (int)Math.ceil((double)container.size() / (double)this.cols);
        int compIndex = 0;
        for (Drawable component : container) {
            Integer col = compIndex % infos[0].size;
            Integer row = compIndex / infos[0].size;
            Double colWidth = infos[0].sizes.get(col);
            Double rowHeight = infos[1].sizes.get(row);
            Dimension2D size = component.getPreferredSize();
            infos[0].sizes.put(col, TableLayout.max(size.getWidth(), colWidth));
            infos[1].sizes.put(row, TableLayout.max(size.getHeight(), rowHeight));
            ++compIndex;
        }
        Rectangle2D bounds = container.getBounds();
        Insets2D insets = container.getInsets();
        if (insets == null) {
            insets = new Insets2D.Double();
        }
        infos[0].insetsSum = insets.getLeft() + insets.getRight();
        infos[1].insetsSum = insets.getTop() + insets.getBottom();
        infos[0].gapSum = Math.max((double)(infos[0].size - 1) * this.getGapX(), 0.0);
        infos[1].gapSum = Math.max((double)(infos[1].size - 1) * this.getGapY(), 0.0);
        double containerWidth = Math.max(bounds.getWidth() - infos[0].insetsSum - infos[0].gapSum, 0.0);
        double containerHeight = Math.max(bounds.getHeight() - infos[1].insetsSum - infos[1].gapSum, 0.0);
        infos[0].sizeMean = infos[0].size > 0 ? containerWidth / (double)infos[0].size : 0.0;
        infos[1].sizeMean = infos[1].size > 0 ? containerHeight / (double)infos[1].size : 0.0;
        for (Info info : infos) {
            info.sizeSum = 0.0;
            info.unsizeableSpace = 0.0;
            int sizeable = 0;
            for (double size : info.sizes.values()) {
                info.sizeSum += size;
                if (size >= info.sizeMean) {
                    info.unsizeableSpace += size - info.sizeMean;
                    continue;
                }
                ++sizeable;
            }
            if (sizeable <= 0) continue;
            info.unsizeableSpace /= (double)sizeable;
        }
        return infos;
    }

    @Override
    public void layout(Container container) {
        Info[] infos = this.getInfo(container);
        Rectangle2D bounds = container.getBounds();
        Insets2D insets = container.getInsets();
        if (insets == null) {
            insets = new Insets2D.Double();
        }
        Integer lastCol = infos[0].size - 1;
        int compIndex = 0;
        double x = bounds.getX() + insets.getLeft();
        double y = bounds.getY() + insets.getTop();
        for (Drawable component : container) {
            Integer col = compIndex % infos[0].size;
            Integer row = compIndex / infos[0].size;
            double colWidth = infos[0].sizes.get(col);
            double rowHeight = infos[1].sizes.get(row);
            double w = Math.max(infos[0].sizeMean - infos[0].unsizeableSpace, colWidth);
            double h = Math.max(infos[1].sizeMean - infos[1].unsizeableSpace, rowHeight);
            if (component != null) {
                component.setBounds(x, y, w, h);
            }
            if (col.equals(lastCol)) {
                x = bounds.getX() + insets.getLeft();
                y += h + this.getGapY();
            } else {
                x += w + this.getGapX();
            }
            ++compIndex;
        }
    }

    @Override
    public Dimension2D getPreferredSize(Container container) {
        Info[] infos = this.getInfo(container);
        return new Dimension2D.Double(infos[0].sizeSum + infos[0].gapSum + infos[0].insetsSum, infos[1].sizeSum + infos[1].gapSum + infos[1].insetsSum);
    }

    public int getColumns() {
        return this.cols;
    }

    private static <T extends Comparable<T>> T max(T a, T b) {
        if (a == null || b == null) {
            if (a == null) {
                return b;
            }
            return a;
        }
        if (a.compareTo(b) >= 0) {
            return a;
        }
        return b;
    }

    private static final class Info {
        public final Map<Integer, Double> sizes = new HashMap<Integer, Double>();
        public int size;
        public double sizeSum;
        public double insetsSum;
        public double gapSum;
        public double sizeMean;
        public double unsizeableSpace;
    }
}

