/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.graphics.layout;

import de.erichseifert.gral.graphics.Container;
import de.erichseifert.gral.graphics.Dimension2D;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.graphics.Location;
import de.erichseifert.gral.graphics.layout.AbstractLayout;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;

public class OuterEdgeLayout
extends AbstractLayout {
    private static final long serialVersionUID = -2238929452967312857L;

    public OuterEdgeLayout(double gap) {
        super(gap, gap);
    }

    public OuterEdgeLayout() {
        this(0.0);
    }

    @Override
    public void layout(Container container) {
        Map<Location, Drawable> comps = OuterEdgeLayout.getComponentsByLocation(container);
        Drawable north = comps.get((Object)Location.NORTH);
        Drawable northEast = comps.get((Object)Location.NORTH_EAST);
        Drawable east = comps.get((Object)Location.EAST);
        Drawable southEast = comps.get((Object)Location.SOUTH_EAST);
        Drawable south = comps.get((Object)Location.SOUTH);
        Drawable southWest = comps.get((Object)Location.SOUTH_WEST);
        Drawable west = comps.get((Object)Location.WEST);
        Drawable northWest = comps.get((Object)Location.NORTH_WEST);
        Drawable center = comps.get((Object)Location.CENTER);
        double widthWest = OuterEdgeLayout.getMaxWidth(northWest, west, southWest);
        double widthEast = OuterEdgeLayout.getMaxWidth(northEast, east, southEast);
        double heightNorth = OuterEdgeLayout.getMaxHeight(northWest, north, northEast);
        double heightSouth = OuterEdgeLayout.getMaxHeight(southWest, south, southEast);
        double gapEast = widthEast > 0.0 ? this.getGapX() : 0.0;
        double gapWest = widthWest > 0.0 ? this.getGapX() : 0.0;
        double gapNorth = heightNorth > 0.0 ? this.getGapY() : 0.0;
        double gapSouth = heightSouth > 0.0 ? this.getGapY() : 0.0;
        Rectangle2D bounds = container.getBounds();
        Insets2D insets = container.getInsets();
        if (insets == null) {
            insets = new Insets2D.Double();
        }
        double xWest = bounds.getMinX() + insets.getLeft() - gapWest - widthWest;
        double xCenter = bounds.getMinX() + insets.getLeft();
        double xEast = bounds.getMaxX() - insets.getRight() + gapEast;
        double yNorth = bounds.getMinY() + insets.getTop() - gapNorth - heightNorth;
        double yCenter = bounds.getMinY() + insets.getTop();
        double ySouth = bounds.getMaxY() - insets.getBottom() + gapSouth;
        OuterEdgeLayout.layoutComponent(northWest, xWest, yNorth, widthWest, heightNorth);
        OuterEdgeLayout.layoutComponent(north, xCenter, yNorth, bounds.getWidth() - insets.getHorizontal(), heightNorth);
        OuterEdgeLayout.layoutComponent(northEast, xEast, yNorth, widthEast, heightNorth);
        OuterEdgeLayout.layoutComponent(east, xEast, yCenter, widthEast, bounds.getHeight() - insets.getVertical());
        OuterEdgeLayout.layoutComponent(southEast, xEast, ySouth, widthEast, heightSouth);
        OuterEdgeLayout.layoutComponent(south, xCenter, ySouth, bounds.getWidth() - insets.getHorizontal(), heightSouth);
        OuterEdgeLayout.layoutComponent(southWest, xWest, ySouth, widthWest, heightSouth);
        OuterEdgeLayout.layoutComponent(west, xWest, yCenter, widthWest, bounds.getHeight() - insets.getVertical());
        OuterEdgeLayout.layoutComponent(center, xCenter + this.getGapX(), yCenter + this.getGapY(), bounds.getWidth() - insets.getHorizontal() - 2.0 * this.getGapX(), bounds.getHeight() - insets.getVertical() - 2.0 * this.getGapY());
    }

    @Override
    public Dimension2D getPreferredSize(Container container) {
        Map<Location, Drawable> comps = OuterEdgeLayout.getComponentsByLocation(container);
        Drawable center = comps.get((Object)Location.CENTER);
        Insets2D insets = container.getInsets();
        if (insets == null) {
            insets = new Insets2D.Double();
        }
        double width = center.getWidth() + insets.getHorizontal() + 2.0 * this.getGapX();
        double height = center.getHeight() + insets.getVertical() + 2.0 * this.getGapY();
        return new Dimension2D.Double(width, height);
    }

    private static Map<Location, Drawable> getComponentsByLocation(Container container) {
        HashMap<Location, Drawable> drawablesByLocation = new HashMap<Location, Drawable>();
        for (Drawable d : container) {
            Object constraints = container.getConstraints(d);
            if (!(constraints instanceof Location)) continue;
            drawablesByLocation.put((Location)((Object)constraints), d);
        }
        return drawablesByLocation;
    }

    private static double getMaxWidth(Drawable ... drawables) {
        double width = 0.0;
        for (Drawable d : drawables) {
            if (d == null) continue;
            width = Math.max(width, d.getPreferredSize().getWidth());
        }
        return width;
    }

    private static double getMaxHeight(Drawable ... drawables) {
        double height = 0.0;
        for (Drawable d : drawables) {
            if (d == null) continue;
            height = Math.max(height, d.getPreferredSize().getHeight());
        }
        return height;
    }

    private static void layoutComponent(Drawable component, double x, double y, double w, double h) {
        if (component == null) {
            return;
        }
        component.setBounds(x, y, w, h);
    }
}

