/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.graphics.layout;

import de.erichseifert.gral.graphics.Container;
import de.erichseifert.gral.graphics.Dimension2D;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.graphics.Location;
import de.erichseifert.gral.graphics.layout.AbstractLayout;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;

public class EdgeLayout
extends AbstractLayout {
    private static final long serialVersionUID = 3661169796145433549L;

    public EdgeLayout(double gapH, double gapV) {
        super(gapH, gapV);
    }

    public EdgeLayout() {
        this(0.0, 0.0);
    }

    @Override
    public void layout(Container container) {
        Map<Location, Drawable> comps = EdgeLayout.getComponentsByLocation(container);
        Drawable north = comps.get((Object)Location.NORTH);
        Drawable northEast = comps.get((Object)Location.NORTH_EAST);
        Drawable east = comps.get((Object)Location.EAST);
        Drawable southEast = comps.get((Object)Location.SOUTH_EAST);
        Drawable south = comps.get((Object)Location.SOUTH);
        Drawable southWest = comps.get((Object)Location.SOUTH_WEST);
        Drawable west = comps.get((Object)Location.WEST);
        Drawable northWest = comps.get((Object)Location.NORTH_WEST);
        Drawable center = comps.get((Object)Location.CENTER);
        double widthWest = EdgeLayout.getMaxWidth(northWest, west, southWest);
        double widthEast = EdgeLayout.getMaxWidth(northEast, east, southEast);
        double heightNorth = EdgeLayout.getMaxHeight(northWest, north, northEast);
        double heightSouth = EdgeLayout.getMaxHeight(southWest, south, southEast);
        double gapWest = widthWest > 0.0 && center != null ? this.getGapX() : 0.0;
        double gapEast = widthEast > 0.0 && center != null ? this.getGapX() : 0.0;
        double gapNorth = heightNorth > 0.0 && center != null ? this.getGapY() : 0.0;
        double gapSouth = heightSouth > 0.0 && center != null ? this.getGapY() : 0.0;
        Rectangle2D bounds = container.getBounds();
        Insets2D insets = container.getInsets();
        if (insets == null) {
            insets = new Insets2D.Double();
        }
        double xWest = bounds.getMinX() + insets.getLeft();
        double xCenter = xWest + widthWest + gapWest;
        double xEast = bounds.getMaxX() - insets.getRight() - widthEast;
        double yNorth = bounds.getMinY() + insets.getTop();
        double yCenter = yNorth + heightNorth + gapNorth;
        double ySouth = bounds.getMaxY() - insets.getBottom() - heightSouth;
        double widthAll = widthWest + widthEast;
        double heightAll = heightNorth + heightSouth;
        double gapHAll = gapWest + gapEast;
        double gapVAll = gapNorth - gapSouth;
        EdgeLayout.layoutComponent(northWest, xWest, yNorth, widthWest, heightNorth);
        EdgeLayout.layoutComponent(north, xCenter, yNorth, bounds.getWidth() - insets.getHorizontal() - widthAll - gapHAll, heightNorth);
        EdgeLayout.layoutComponent(northEast, xEast, yNorth, widthEast, heightNorth);
        EdgeLayout.layoutComponent(east, xEast, yCenter, widthEast, bounds.getHeight() - insets.getVertical() - heightAll - gapVAll);
        EdgeLayout.layoutComponent(southEast, xEast, ySouth, widthEast, heightSouth);
        EdgeLayout.layoutComponent(south, xCenter, ySouth, bounds.getWidth() - insets.getHorizontal() - widthAll - gapHAll, heightSouth);
        EdgeLayout.layoutComponent(southWest, xWest, ySouth, widthWest, heightSouth);
        EdgeLayout.layoutComponent(west, xWest, yCenter, widthWest, bounds.getHeight() - insets.getVertical() - heightAll - gapVAll);
        EdgeLayout.layoutComponent(center, xCenter, yCenter, bounds.getWidth() - insets.getLeft() - widthAll - insets.getRight() - gapHAll, bounds.getHeight() - insets.getTop() - heightAll - insets.getBottom() - gapVAll);
    }

    @Override
    public Dimension2D getPreferredSize(Container container) {
        Map<Location, Drawable> comps = EdgeLayout.getComponentsByLocation(container);
        Drawable north = comps.get((Object)Location.NORTH);
        Drawable northEast = comps.get((Object)Location.NORTH_EAST);
        Drawable east = comps.get((Object)Location.EAST);
        Drawable southEast = comps.get((Object)Location.SOUTH_EAST);
        Drawable south = comps.get((Object)Location.SOUTH);
        Drawable southWest = comps.get((Object)Location.SOUTH_WEST);
        Drawable west = comps.get((Object)Location.WEST);
        Drawable northWest = comps.get((Object)Location.NORTH_WEST);
        Drawable center = comps.get((Object)Location.CENTER);
        double widthWest = EdgeLayout.getMaxWidth(northWest, west, southWest);
        double widthCenter = EdgeLayout.getMaxWidth(north, center, south);
        double widthEast = EdgeLayout.getMaxWidth(northEast, east, southEast);
        double heightNorth = EdgeLayout.getMaxHeight(northWest, north, northEast);
        double heightCenter = EdgeLayout.getMaxHeight(west, center, east);
        double heightSouth = EdgeLayout.getMaxHeight(southWest, south, southEast);
        double gapEast = widthEast > 0.0 && center != null ? this.getGapX() : 0.0;
        double gapWest = widthWest > 0.0 && center != null ? this.getGapX() : 0.0;
        double gapNorth = heightNorth > 0.0 && center != null ? this.getGapY() : 0.0;
        double gapSouth = heightSouth > 0.0 && center != null ? this.getGapY() : 0.0;
        Insets2D insets = container.getInsets();
        if (insets == null) {
            insets = new Insets2D.Double();
        }
        double width = insets.getLeft() + widthEast + gapEast + widthCenter + gapWest + widthWest + insets.getRight();
        double height = insets.getTop() + heightNorth + gapNorth + heightCenter + gapSouth + heightSouth + insets.getBottom();
        return new Dimension2D.Double(width, height);
    }

    private static Map<Location, Drawable> getComponentsByLocation(Container container) {
        HashMap<Location, Drawable> drawablesByLocation = new HashMap<Location, Drawable>();
        for (Drawable d : container) {
            Object constraints = container.getConstraints(d);
            if (!(constraints instanceof Location)) continue;
            drawablesByLocation.put((Location)((Object)constraints), d);
        }
        return drawablesByLocation;
    }

    private static double getMaxWidth(Drawable ... drawables) {
        double width = 0.0;
        for (Drawable d : drawables) {
            if (d == null) continue;
            width = Math.max(width, d.getPreferredSize().getWidth());
        }
        return width;
    }

    private static double getMaxHeight(Drawable ... drawables) {
        double height = 0.0;
        for (Drawable d : drawables) {
            if (d == null) continue;
            height = Math.max(height, d.getPreferredSize().getHeight());
        }
        return height;
    }

    private static void layoutComponent(Drawable component, double x, double y, double w, double h) {
        if (component == null) {
            return;
        }
        component.setBounds(x, y, w, h);
    }
}

