/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.examples.xyplot;

import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.examples.ExamplePanel;
import de.erichseifert.gral.graphics.DrawableContainer;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.graphics.layout.TableLayout;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.plots.areas.AreaRenderer;
import de.erichseifert.gral.plots.areas.DefaultAreaRenderer2D;
import de.erichseifert.gral.plots.lines.DefaultLineRenderer2D;
import de.erichseifert.gral.plots.lines.LineRenderer;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.ui.InteractivePanel;
import de.erichseifert.gral.util.GraphicsUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.util.Random;

public class StackedPlots
extends ExamplePanel {
    private static final long serialVersionUID = 6832343098989019088L;
    private static final Random random = new Random();

    public StackedPlots() {
        DataTable data = new DataTable(Double.class, Double.class);
        double x = 0.0;
        double y = 0.0;
        for (x = 0.0; x < 100.0; x += 2.0) {
            data.add(Double.valueOf(x), Double.valueOf(Math.abs(y += 10.0 * random.nextGaussian())));
        }
        XYPlot plotUpper = new XYPlot(data);
        Color colorUpper = COLOR1;
        plotUpper.setPointRenderers(data, null);
        DefaultLineRenderer2D lineUpper = new DefaultLineRenderer2D();
        lineUpper.setColor(colorUpper);
        plotUpper.setLineRenderers(data, lineUpper, new LineRenderer[0]);
        DefaultAreaRenderer2D areaUpper = new DefaultAreaRenderer2D();
        areaUpper.setColor(GraphicsUtils.deriveWithAlpha(colorUpper, 64));
        plotUpper.setAreaRenderers(data, areaUpper, new AreaRenderer[0]);
        plotUpper.setInsets(new Insets2D.Double(20.0, 50.0, 40.0, 20.0));
        XYPlot plotLower = new XYPlot(data);
        Color colorLower = COLOR1;
        PointRenderer pointsLower = plotLower.getPointRenderers(data).get(0);
        pointsLower.setColor(colorLower);
        pointsLower.setShape(new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0));
        DefaultLineRenderer2D lineLower = new DefaultLineRenderer2D();
        lineLower.setStroke(new BasicStroke(2.0f));
        lineLower.setGap(1.0);
        lineLower.setColor(colorLower);
        plotLower.setLineRenderers(data, lineLower, new LineRenderer[0]);
        plotLower.setInsets(new Insets2D.Double(20.0, 50.0, 40.0, 20.0));
        DrawableContainer plots = new DrawableContainer(new TableLayout(1));
        plots.add(plotUpper);
        plots.add(plotLower);
        plotUpper.getNavigator().connect(plotLower.getNavigator());
        InteractivePanel panel = new InteractivePanel(plots);
        this.add(panel);
    }

    @Override
    public String getTitle() {
        return "Stacked plots";
    }

    @Override
    public String getDescription() {
        return "An area and a line plot with synchronized actions.";
    }

    public static void main(String[] args) {
        new StackedPlots().showInFrame();
    }
}

