/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.examples.xyplot;

import de.erichseifert.gral.data.DataSeries;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.examples.ExamplePanel;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.graphics.Label;
import de.erichseifert.gral.graphics.Orientation;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.axes.LogarithmicRenderer2D;
import de.erichseifert.gral.plots.lines.DiscreteLineRenderer2D;
import de.erichseifert.gral.plots.lines.LineRenderer;
import de.erichseifert.gral.plots.points.DefaultPointRenderer2D;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.plots.points.SizeablePointRenderer;
import de.erichseifert.gral.ui.InteractivePanel;
import de.erichseifert.gral.util.GraphicsUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Random;

public class SimpleXYPlot
extends ExamplePanel {
    private static final long serialVersionUID = -5263057758564264676L;
    private static final Random random = new Random();

    public SimpleXYPlot() {
        DataTable data = new DataTable(Double.class, Double.class, Double.class, Double.class, Double.class, Double.class);
        for (double x = 1.0; x <= 400.0; x *= 1.5) {
            double x2 = x / 5.0;
            data.add(Double.valueOf(x2), Double.valueOf(-Math.sqrt(x2) + 5.0), Double.valueOf(5.0 * Math.log10(x2)), Double.valueOf(random.nextDouble() + 1.0), Double.valueOf(random.nextDouble() + 0.5), Double.valueOf(1.0 + 2.0 * random.nextDouble()));
        }
        DataSeries seriesLog = new DataSeries(data, 0, 2, 3, 4);
        DataSeries seriesLin = new DataSeries(data, 0, 1, 5);
        XYPlot plot = new XYPlot(seriesLog, seriesLin);
        plot.setInsets(new Insets2D.Double(20.0, 40.0, 40.0, 40.0));
        plot.setBackground(Color.WHITE);
        plot.getTitle().setText(this.getDescription());
        plot.getPlotArea().setBackground(new RadialGradientPaint(new Point2D.Double(0.5, 0.5), 0.75f, new float[]{0.6f, 0.8f, 1.0f}, new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 32), new Color(0, 0, 0, 128)}));
        plot.getPlotArea().setBorderStroke(null);
        LogarithmicRenderer2D axisRendererX = new LogarithmicRenderer2D();
        AxisRenderer axisRendererY = plot.getAxisRenderer("y");
        axisRendererX.setLabel(new Label("Logarithmic axis"));
        plot.setAxisRenderer("x", axisRendererX);
        HashMap<Double, String> labels = new HashMap<Double, String>();
        labels.put(2.0, "Two");
        labels.put(1.5, "OnePointFive");
        axisRendererX.setCustomTicks(labels);
        BasicStroke stroke = new BasicStroke(2.0f);
        axisRendererX.setShapeStroke(stroke);
        Label linearAxisLabel = new Label("Linear axis");
        linearAxisLabel.setRotation(90.0);
        axisRendererY.setLabel(linearAxisLabel);
        axisRendererY.setIntersection(1.0);
        axisRendererX.setTickSpacing(2.0);
        SizeablePointRenderer sizeablePointRenderer = new SizeablePointRenderer();
        sizeablePointRenderer.setColor(GraphicsUtils.deriveDarker(COLOR1));
        plot.setPointRenderers(seriesLin, sizeablePointRenderer, new PointRenderer[0]);
        DefaultPointRenderer2D defaultPointRenderer = new DefaultPointRenderer2D();
        defaultPointRenderer.setColor(GraphicsUtils.deriveDarker(COLOR2));
        defaultPointRenderer.setErrorVisible(true);
        defaultPointRenderer.setErrorColor(COLOR2);
        plot.setPointRenderers(seriesLog, defaultPointRenderer, new PointRenderer[0]);
        DiscreteLineRenderer2D discreteRenderer = new DiscreteLineRenderer2D();
        discreteRenderer.setColor(COLOR1);
        discreteRenderer.setStroke(new BasicStroke(3.0f, 1, 1, 10.0f, new float[]{3.0f, 6.0f}, 0.0f));
        plot.setLineRenderers(seriesLin, discreteRenderer, new LineRenderer[0]);
        discreteRenderer.setGap(2.0);
        discreteRenderer.setGapRounded(true);
        discreteRenderer.setAscentDirection(Orientation.VERTICAL);
        discreteRenderer.setAscendingPoint(0.5);
        this.add((Component)new InteractivePanel(plot), "Center");
    }

    @Override
    public String getTitle() {
        return "x-y plot";
    }

    @Override
    public String getDescription() {
        return "Styled x-y plot with example data";
    }

    public static void main(String[] args) {
        new SimpleXYPlot().showInFrame();
    }
}

