/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.examples.xyplot;

import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.examples.ExamplePanel;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.ui.InteractivePanel;
import java.awt.Component;
import java.util.Random;

public class ScatterPlot
extends ExamplePanel {
    private static final long serialVersionUID = -412699430625953887L;
    private static final int SAMPLE_COUNT = 100000;
    private static final Random random = new Random();

    public ScatterPlot() {
        DataTable data = new DataTable(Double.class, Double.class);
        for (int i = 0; i <= 100000; ++i) {
            data.add(Double.valueOf(random.nextGaussian() * 2.0), Double.valueOf(random.nextGaussian() * 2.0));
        }
        XYPlot plot = new XYPlot(data);
        plot.setInsets(new Insets2D.Double(20.0, 40.0, 40.0, 40.0));
        plot.getTitle().setText(this.getDescription());
        plot.getPointRenderers(data).get(0).setColor(COLOR1);
        this.add((Component)new InteractivePanel(plot), "Center");
    }

    @Override
    public String getTitle() {
        return "Scatter plot";
    }

    @Override
    public String getDescription() {
        return String.format("Scatter plot with %d data points", 100000);
    }

    public static void main(String[] args) {
        new ScatterPlot().showInFrame();
    }
}

