/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.examples.io;

import de.erichseifert.gral.data.DataSeries;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.io.plots.DrawableWriter;
import de.erichseifert.gral.io.plots.DrawableWriterFactory;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.plots.lines.DefaultLineRenderer2D;
import de.erichseifert.gral.plots.lines.LineRenderer;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;

public class DrawableWriterTest {
    private final XYPlot plot;

    public DrawableWriterTest() {
        DataTable data = new DataTable(Double.class, Double.class, Double.class, Double.class);
        data.add(Double.valueOf(1.0), Double.valueOf(4.5), Double.valueOf(4.3), Double.valueOf(4.0));
        data.add(Double.valueOf(1.5), Double.valueOf(5.5), Double.valueOf(5.3), Double.valueOf(5.0));
        data.add(Double.valueOf(3.0), Double.valueOf(3.5), Double.valueOf(3.7), Double.valueOf(4.0));
        data.add(Double.valueOf(4.0), Double.valueOf(4.7), Double.valueOf(4.5), Double.valueOf(4.3));
        DataSeries s1 = new DataSeries(data, 0, 1);
        DataSeries s2 = new DataSeries(data, 0, 2);
        DataSeries s3 = new DataSeries(data, 0, 3);
        this.plot = new XYPlot(s1, s2, s3);
        this.plot.setInsets(new Insets2D.Double(20.0, 50.0, 50.0, 20.0));
        DefaultLineRenderer2D lr1 = new DefaultLineRenderer2D();
        lr1.setColor(Color.RED);
        this.plot.setLineRenderers(s1, lr1, new LineRenderer[0]);
        DefaultLineRenderer2D lr2 = new DefaultLineRenderer2D();
        lr2.setColor(Color.GREEN);
        this.plot.setLineRenderers(s2, lr2, new LineRenderer[0]);
        DefaultLineRenderer2D lr3 = new DefaultLineRenderer2D();
        lr3.setColor(Color.BLUE);
        this.plot.setLineRenderers(s3, lr3, new LineRenderer[0]);
    }

    public void save() {
        JFileChooser chooser = new JFileChooser();
        int option = chooser.showSaveDialog(null);
        if (option == 0) {
            File file = chooser.getSelectedFile();
            try {
                DrawableWriter writer = DrawableWriterFactory.getInstance().get("application/postscript");
                writer.write(this.plot, new FileOutputStream(file), 800.0, 600.0);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        DrawableWriterTest test = new DrawableWriterTest();
        test.save();
    }
}

