/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.examples.boxplot;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.examples.ExamplePanel;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.plots.BoxPlot;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.plots.colors.LinearGradient;
import de.erichseifert.gral.ui.InteractivePanel;
import de.erichseifert.gral.util.DataUtils;
import de.erichseifert.gral.util.GraphicsUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Random;

public class SimpleBoxPlot
extends ExamplePanel {
    private static final long serialVersionUID = 5228891435595348789L;
    private static final int SAMPLE_COUNT = 50;
    private static final Random random = new Random();

    public SimpleBoxPlot() {
        this.setPreferredSize(new Dimension(400, 600));
        DataTable data = new DataTable(Integer.class, Integer.class, Integer.class);
        for (int i = 0; i < 50; ++i) {
            int x = (int)Math.round(5.0 * random.nextGaussian());
            int y = (int)Math.round(5.0 * random.nextGaussian());
            int z = (int)Math.round(5.0 * random.nextGaussian());
            data.add(Integer.valueOf(x), Integer.valueOf(y), Integer.valueOf(z));
        }
        DataSource boxData = BoxPlot.createBoxData(data);
        BoxPlot plot = new BoxPlot(boxData);
        plot.setInsets(new Insets2D.Double(20.0, 50.0, 40.0, 20.0));
        plot.getAxisRenderer("x").setCustomTicks(DataUtils.map(new Double[]{1.0, 2.0, 3.0}, new String[]{"Column 1", "Column 2", "Column 3"}));
        BasicStroke stroke = new BasicStroke(2.0f);
        LinearGradient colors = new LinearGradient(GraphicsUtils.deriveBrighter(COLOR1), Color.WHITE);
        colors.setRange(1.0, 3.0);
        BoxPlot.BoxWhiskerRenderer pointRenderer = (BoxPlot.BoxWhiskerRenderer)plot.getPointRenderers(boxData).get(0);
        pointRenderer.setWhiskerStroke(stroke);
        pointRenderer.setBoxBorderStroke(stroke);
        pointRenderer.setBoxBackground(colors);
        pointRenderer.setBoxBorderColor(COLOR1);
        pointRenderer.setWhiskerColor(COLOR1);
        pointRenderer.setCenterBarColor(COLOR1);
        plot.getNavigator().setDirection(XYPlot.XYNavigationDirection.VERTICAL);
        InteractivePanel panel = new InteractivePanel(plot);
        this.add(panel);
    }

    @Override
    public String getTitle() {
        return "Box-and-whisker plot";
    }

    @Override
    public String getDescription() {
        return String.format("Three box-and-whisker plots created from %d random samples", 50);
    }

    public static void main(String[] args) {
        new SimpleBoxPlot().showInFrame();
    }
}

