/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.examples.barplot;

import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.examples.ExamplePanel;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.graphics.Location;
import de.erichseifert.gral.plots.BarPlot;
import de.erichseifert.gral.ui.InteractivePanel;
import de.erichseifert.gral.util.GraphicsUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.LinearGradientPaint;

public class SimpleBarPlot
extends ExamplePanel {
    private static final long serialVersionUID = -2793954497895054530L;

    public SimpleBarPlot() {
        DataTable data = new DataTable(Double.class, Integer.class, String.class);
        data.add(new Comparable[]{Double.valueOf(0.1), Integer.valueOf(1), "January"});
        data.add(new Comparable[]{Double.valueOf(0.2), Integer.valueOf(3), "February"});
        data.add(new Comparable[]{Double.valueOf(0.3), Integer.valueOf(-2), "March"});
        data.add(new Comparable[]{Double.valueOf(0.4), Integer.valueOf(6), "April"});
        data.add(new Comparable[]{Double.valueOf(0.5), Integer.valueOf(-4), "May"});
        data.add(new Comparable[]{Double.valueOf(0.6), Integer.valueOf(8), "June"});
        data.add(new Comparable[]{Double.valueOf(0.7), Integer.valueOf(9), "July"});
        data.add(new Comparable[]{Double.valueOf(0.8), Integer.valueOf(11), "August"});
        BarPlot plot = new BarPlot(data);
        plot.setInsets(new Insets2D.Double(40.0, 40.0, 40.0, 40.0));
        plot.setBarWidth(0.075);
        BarPlot.BarRenderer pointRenderer = (BarPlot.BarRenderer)plot.getPointRenderers(data).get(0);
        pointRenderer.setColor(new LinearGradientPaint(0.0f, 0.0f, 0.0f, 1.0f, new float[]{0.0f, 1.0f}, new Color[]{COLOR1, GraphicsUtils.deriveBrighter(COLOR1)}));
        pointRenderer.setBorderStroke(new BasicStroke(3.0f));
        pointRenderer.setBorderColor(new LinearGradientPaint(0.0f, 0.0f, 0.0f, 1.0f, new float[]{0.0f, 1.0f}, new Color[]{GraphicsUtils.deriveBrighter(COLOR1), COLOR1}));
        pointRenderer.setValueVisible(true);
        pointRenderer.setValueColumn(2);
        pointRenderer.setValueLocation(Location.CENTER);
        pointRenderer.setValueColor(GraphicsUtils.deriveDarker(COLOR1));
        pointRenderer.setValueFont(Font.decode(null).deriveFont(1));
        this.add(new InteractivePanel(plot));
    }

    @Override
    public String getTitle() {
        return "Bar plot";
    }

    @Override
    public String getDescription() {
        return "Bar plot with example data and color gradients";
    }

    public static void main(String[] args) {
        new SimpleBarPlot().showInFrame();
    }
}

