/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data.statistics;

import de.erichseifert.gral.data.statistics.Statistics;
import java.util.Arrays;
import java.util.Iterator;

public class Histogram
implements Iterable<Integer> {
    private Iterable<Comparable<?>> data;
    private Number[] breaks;
    private Integer[] bins;

    public Histogram(Iterable<Comparable<?>> data, int binCount) {
        this(data, Histogram.getEquidistantBreaks(data, binCount + 1));
    }

    public Histogram(Iterable<Comparable<?>> data, Number ... breaks) {
        if (breaks.length < 2) {
            throw new IllegalArgumentException("Invalid break count: " + breaks.length + " A histogram requires at least two breaks to form a bucket.");
        }
        this.data = data;
        this.breaks = breaks;
        int binCount = breaks.length - 1;
        this.bins = new Integer[binCount];
        Arrays.fill((Object[])this.bins, new Integer(0));
        this.computeDistribution();
    }

    private static Number[] getEquidistantBreaks(Iterable<Comparable<?>> data, int breakCount) {
        Number[] breaks = new Number[breakCount];
        Statistics statistics = new Statistics(data);
        double minValue = statistics.get("min");
        double maxValue = statistics.get("max");
        double range = maxValue - minValue;
        int binCount = breakCount - 1;
        double binWidth = range / (double)binCount;
        for (int breakIndex = 0; breakIndex < breaks.length; ++breakIndex) {
            breaks[breakIndex] = minValue + (double)breakIndex * binWidth;
        }
        return breaks;
    }

    private void computeDistribution() {
        for (Comparable<?> value : this.data) {
            if (!(value instanceof Number)) continue;
            for (int binIndex = 0; binIndex < this.bins.length; ++binIndex) {
                double lowerBinLimit = this.breaks[binIndex].doubleValue();
                double upperBinLimit = this.breaks[binIndex + 1].doubleValue();
                double doubleValue = ((Number)((Object)value)).doubleValue();
                if (!(doubleValue >= lowerBinLimit) || !(doubleValue < upperBinLimit)) continue;
                Integer[] integerArray = this.bins;
                int n = binIndex;
                Integer n2 = integerArray[n];
                Integer n3 = integerArray[n] = Integer.valueOf(integerArray[n] + 1);
            }
        }
    }

    public int size() {
        return this.breaks.length - 1;
    }

    public int get(int binIndex) {
        return this.bins[binIndex];
    }

    @Override
    public Iterator<Integer> iterator() {
        return Arrays.asList(this.bins).iterator();
    }
}

