/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data.filters;

import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.filters.Filter2D;
import de.erichseifert.gral.util.MathUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public class Median
extends Filter2D {
    private static final long serialVersionUID = -1645928908580026536L;
    private int windowSize;
    private int offset;

    public Median(DataSource original, int windowSize, int offset, Filter2D.Mode mode, int ... cols) {
        super(original, mode, cols);
        this.windowSize = windowSize;
        this.offset = offset;
        this.filter();
    }

    @Override
    protected void filter() {
        this.clear();
        if (this.getWindowSize() <= 0) {
            return;
        }
        ArrayList colWindows = new ArrayList(this.getColumnCount());
        for (int colIndex = 0; colIndex < this.getColumnCountFiltered(); ++colIndex) {
            int colIndexOriginal = this.getIndexOriginal(colIndex);
            ArrayList<Double> window = new ArrayList<Double>(this.getWindowSize());
            colWindows.add(window);
            for (int rowIndex = this.getOffset() - this.getWindowSize(); rowIndex < 0; ++rowIndex) {
                Comparable<?> vOrig = this.getOriginal(colIndexOriginal, rowIndex);
                double v = ((Number)((Object)vOrig)).doubleValue();
                window.add(v);
            }
        }
        for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
            Double[] filteredRow = new Double[this.getColumnCountFiltered()];
            for (int colIndex = 0; colIndex < filteredRow.length; ++colIndex) {
                List window = (List)colWindows.get(colIndex);
                if (window.size() >= this.getWindowSize()) {
                    window.remove(0);
                }
                int colIndexOriginal = this.getIndexOriginal(colIndex);
                Comparable<?> vOrig = this.getOriginal(colIndexOriginal, rowIndex - this.getOffset() + this.getWindowSize());
                double v = ((Number)((Object)vOrig)).doubleValue();
                window.add(v);
                filteredRow[colIndex] = this.median(window);
            }
            this.add(filteredRow);
        }
    }

    private double median(List<Double> w) {
        if (w.size() == 1) {
            return w.get(0);
        }
        ArrayList<Double> window = new ArrayList<Double>(w.size());
        for (Double v : w) {
            if (!MathUtils.isCalculatable(v)) {
                return Double.NaN;
            }
            window.add(v);
        }
        int medianIndex = MathUtils.randomizedSelect(window, 0, window.size() - 1, window.size() / 2);
        double median = (Double)window.get(medianIndex);
        if ((window.size() & 1) == 0) {
            int medianUpperIndex = MathUtils.randomizedSelect(window, 0, window.size() - 1, window.size() / 2 + 1);
            double medianUpper = (Double)window.get(medianUpperIndex);
            median = (median + medianUpper) / 2.0;
        }
        return median;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
        this.dataUpdated(this, new DataChangeEvent[0]);
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.dataUpdated(this, new DataChangeEvent[0]);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.dataUpdated(this, new DataChangeEvent[0]);
    }
}

