/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data.filters;

import de.erichseifert.gral.data.AbstractDataSource;
import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataListener;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.util.MathUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class Filter2D
extends AbstractDataSource
implements DataListener {
    private static final long serialVersionUID = -5004453681128601437L;
    private final DataSource original;
    private final int[] cols;
    private transient ArrayList<Double[]> rows;
    private Mode mode;

    public Filter2D(DataSource original, Mode mode, int ... cols) {
        this.rows = new ArrayList(original.getRowCount());
        this.original = original;
        this.mode = mode;
        this.cols = Arrays.copyOf(cols, cols.length);
        Arrays.sort(this.cols);
        Class<? extends Comparable<?>>[] originalColumnTypes = original.getColumnTypes();
        for (int colIndex : this.cols) {
            if (original.isColumnNumeric(colIndex)) continue;
            throw new IllegalArgumentException(MessageFormat.format("Column {0,number,integer} isn't numeric and cannot be filtered.", colIndex));
        }
        Class<? extends Comparable<?>>[] types = originalColumnTypes;
        for (int colIndex : this.cols) {
            types[colIndex] = Double.class;
        }
        this.setColumnTypes(types);
        this.original.addDataListener(this);
        this.dataUpdated(this.original, new DataChangeEvent[0]);
    }

    protected DataSource getOriginal() {
        return this.original;
    }

    protected Comparable<?> getOriginal(int col, int row) {
        int rowLast = this.original.getRowCount() - 1;
        if (row < 0 || row > rowLast) {
            if (this.getMode() == Mode.OMIT) {
                return Double.NaN;
            }
            if (this.getMode() == Mode.ZERO) {
                return 0.0;
            }
            if (this.getMode() == Mode.REPEAT) {
                row = MathUtils.limit(row, 0, rowLast);
            } else if (this.getMode() == Mode.MIRROR) {
                int rem = Math.abs(row) / rowLast;
                int mod = Math.abs(row) % rowLast;
                row = (rem & 1) == 0 ? mod : rowLast - mod;
            } else if (this.getMode() == Mode.CIRCULAR) {
                row = row >= 0 ? (row %= rowLast + 1) : (row + 1) % (rowLast + 1) + rowLast;
            }
        }
        return this.original.get(col, row);
    }

    protected void clear() {
        this.rows.clear();
    }

    protected void add(Double[] rowData) {
        this.rows.add(rowData);
    }

    protected void add(Number[] rowData) {
        Double[] doubleData = new Double[rowData.length];
        int i = 0;
        for (Number value : rowData) {
            doubleData[i++] = value.doubleValue();
        }
        this.rows.add(doubleData);
    }

    @Override
    public Comparable<?> get(int col, int row) {
        int colPos = this.getIndex(col);
        if (colPos < 0) {
            return this.original.get(col, row);
        }
        return this.rows.get(row)[colPos];
    }

    protected Number set(int col, int row, Double value) {
        int colPos = this.getIndex(col);
        if (colPos < 0) {
            throw new IllegalArgumentException("Can't set value in unfiltered column.");
        }
        Double old = this.rows.get(row)[colPos];
        this.rows.get((int)row)[colPos] = value;
        this.notifyDataUpdated(new DataChangeEvent(this, col, row, old, value));
        return old;
    }

    @Override
    public int getColumnCount() {
        return this.original.getColumnCount();
    }

    protected int getColumnCountFiltered() {
        if (this.cols.length == 0) {
            return this.original.getColumnCount();
        }
        return this.cols.length;
    }

    @Override
    public int getRowCount() {
        return this.original.getRowCount();
    }

    protected int getRowCountFiltered() {
        return this.original.getRowCount();
    }

    @Override
    public void dataAdded(DataSource source, DataChangeEvent ... events) {
        this.dataChanged(source, events);
        this.notifyDataAdded(events);
    }

    @Override
    public void dataUpdated(DataSource source, DataChangeEvent ... events) {
        this.dataChanged(source, events);
        this.notifyDataUpdated(events);
    }

    @Override
    public void dataRemoved(DataSource source, DataChangeEvent ... events) {
        this.dataChanged(source, events);
        this.notifyDataRemoved(events);
    }

    private void dataChanged(DataSource source, DataChangeEvent ... events) {
        this.filter();
    }

    protected int getIndexOriginal(int col) {
        if (this.cols.length == 0) {
            return col;
        }
        return this.cols[col];
    }

    protected int getIndex(int col) {
        if (this.cols.length == 0) {
            return col;
        }
        return Arrays.binarySearch(this.cols, col);
    }

    protected boolean isFiltered(int col) {
        return this.getIndex(col) >= 0;
    }

    protected abstract void filter();

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.dataUpdated(this, new DataChangeEvent[0]);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.rows = new ArrayList();
        this.original.addDataListener(this);
    }

    public static enum Mode {
        OMIT,
        ZERO,
        REPEAT,
        MIRROR,
        CIRCULAR;

    }
}

