/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data.filters;

import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.filters.Filter2D;
import de.erichseifert.gral.data.filters.Kernel;
import de.erichseifert.gral.util.DataUtils;
import de.erichseifert.gral.util.MathUtils;
import java.io.IOException;
import java.io.ObjectInputStream;

public class Convolution
extends Filter2D {
    private static final long serialVersionUID = 7155205321415314271L;
    private final Kernel kernel;

    public Convolution(DataSource original, Kernel kernel, Filter2D.Mode mode, int ... cols) {
        super(original, mode, cols);
        this.kernel = kernel;
        this.filter();
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    @Override
    protected void filter() {
        this.clear();
        for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
            Double[] filteredRow = new Double[this.getColumnCountFiltered()];
            for (int colIndex = 0; colIndex < filteredRow.length; ++colIndex) {
                int colIndexOriginal = this.getIndexOriginal(colIndex);
                filteredRow[colIndex] = this.convolve(colIndexOriginal, rowIndex);
            }
            this.add(filteredRow);
        }
    }

    private double convolve(int col, int row) {
        Kernel kernel = this.getKernel();
        if (kernel == null) {
            Comparable<?> original = this.getOriginal(col, row);
            return DataUtils.getValueOrDefault((Number)((Object)original), Double.NaN);
        }
        double sum = 0.0;
        for (int k = kernel.getMinIndex(); k <= kernel.getMaxIndex(); ++k) {
            int r = row + k;
            Comparable<?> original = this.getOriginal(col, r);
            double v = DataUtils.getValueOrDefault((Number)((Object)original), Double.NaN);
            if (!MathUtils.isCalculatable(v)) {
                return v;
            }
            sum += kernel.get(k) * v;
        }
        return sum;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.dataUpdated(this, new DataChangeEvent[0]);
    }
}

