/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data.filters;

import de.erichseifert.gral.data.filters.Filter;
import java.util.Iterator;

public class Accumulation<T extends Number>
implements Filter<T> {
    private final Iterable<T> data;

    public Accumulation(Iterable<T> data) {
        this.data = data;
    }

    @Override
    public Iterator<Double> iterator() {
        return new AccumulationIterator<T>(this.data.iterator());
    }

    private static class AccumulationIterator<U extends Number>
    implements Iterator<Double> {
        private final Iterator<U> wrappedIterator;
        private double accumulatedValue;

        public AccumulationIterator(Iterator<U> wrappedIterator) {
            this.wrappedIterator = wrappedIterator;
            this.accumulatedValue = 0.0;
        }

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        @Override
        public Double next() {
            this.accumulatedValue += ((Number)this.wrappedIterator.next()).doubleValue();
            return this.accumulatedValue;
        }

        @Override
        public void remove() {
            this.wrappedIterator.remove();
        }
    }
}

