/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data;

import de.erichseifert.gral.data.AbstractDataSource;
import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataListener;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.Row;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class RowSubset
extends AbstractDataSource
implements DataListener {
    private static final long serialVersionUID = -5396152732545986903L;
    private final DataSource original;
    private transient List<Integer> accepted = new ArrayList<Integer>();

    public RowSubset(DataSource original) {
        this.original = original;
        this.original.addDataListener(this);
        this.dataUpdated(this.original, new DataChangeEvent[0]);
    }

    @Override
    public Row getRow(int row) {
        int rowOrig = this.accepted.get(row);
        return this.original.getRow(rowOrig);
    }

    @Override
    public Comparable<?> get(int col, int row) {
        int rowOrig = this.accepted.get(row);
        return this.original.get(col, rowOrig);
    }

    @Override
    public int getColumnCount() {
        return this.original.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.accepted.size();
    }

    @Override
    public Class<? extends Comparable<?>>[] getColumnTypes() {
        return this.original.getColumnTypes();
    }

    @Override
    public void dataAdded(DataSource source, DataChangeEvent ... events) {
        this.dataChanged(source, events);
        this.notifyDataAdded(events);
    }

    @Override
    public void dataUpdated(DataSource source, DataChangeEvent ... events) {
        this.dataChanged(source, events);
        this.notifyDataUpdated(events);
    }

    @Override
    public void dataRemoved(DataSource source, DataChangeEvent ... events) {
        this.dataChanged(source, events);
        this.notifyDataRemoved(events);
    }

    private void dataChanged(DataSource source, DataChangeEvent ... events) {
        this.update();
    }

    private void update() {
        this.accepted.clear();
        for (int rowIndex = 0; rowIndex < this.original.getRowCount(); ++rowIndex) {
            Row row = this.original.getRow(rowIndex);
            if (!this.accept(row)) continue;
            this.accepted.add(rowIndex);
        }
    }

    public abstract boolean accept(Row var1);

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.accepted = new ArrayList<Integer>();
        this.dataUpdated(this.original, new DataChangeEvent[0]);
        this.original.addDataListener(this);
    }
}

