/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Record
implements Iterable<Comparable<?>>,
Serializable {
    private Comparable[] values;

    public Record(List<? extends Comparable<?>> values) {
        this.values = values.toArray(new Comparable[0]);
    }

    public Record(Comparable<?> ... values) {
        this.values = Arrays.copyOf(values, values.length);
    }

    public <T extends Comparable<?>> T get(int index) {
        return (T)this.values[index];
    }

    public int size() {
        return this.values.length;
    }

    @Override
    public Iterator<Comparable<?>> iterator() {
        ArrayList<Comparable> list = new ArrayList<Comparable>(this.values.length);
        for (Comparable value : this.values) {
            list.add(value);
        }
        return list.iterator();
    }

    public boolean isNumeric(int index) {
        return this.values[index] instanceof Number;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Record)) {
            return false;
        }
        Record record = (Record)obj;
        return this.size() == record.size() && Arrays.equals(this.values, record.values);
    }

    public String toString() {
        String representation = "(";
        for (int elementIndex = 0; elementIndex < this.values.length; ++elementIndex) {
            Comparable element = this.values[elementIndex];
            representation = representation + element;
            if (elementIndex == this.values.length - 1) continue;
            representation = representation + ", ";
        }
        representation = representation + ")";
        return representation;
    }

    public Record insert(Comparable<?> value, int position) {
        ArrayList recordCopyAsList = new ArrayList(this.values.length + 1);
        for (Comparable v : this.values) {
            recordCopyAsList.add(v);
        }
        recordCopyAsList.add(position, value);
        return new Record(recordCopyAsList);
    }
}

