/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data;

import de.erichseifert.gral.data.AbstractDataSource;
import de.erichseifert.gral.data.Column;
import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.MutableDataSource;
import de.erichseifert.gral.data.Record;
import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.data.comparators.DataComparator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DataTable
extends AbstractDataSource
implements MutableDataSource {
    private static final long serialVersionUID = 535236774042654449L;
    private final List<Record> rows = new ArrayList<Record>();

    public DataTable() {
    }

    public DataTable(Class<? extends Comparable<?>> ... types) {
        super(types);
    }

    public DataTable(int cols, Class<? extends Comparable<?>> type) {
        this();
        Object[] types = new Class[cols];
        Arrays.fill(types, type);
        this.setColumnTypes((Class<? extends Comparable<?>>[])types);
    }

    public DataTable(DataSource source) {
        this(source.getColumnTypes());
        for (int rowIndex = 0; rowIndex < source.getRowCount(); ++rowIndex) {
            this.add(source.getRecord(rowIndex));
        }
    }

    public DataTable(Column ... columns) {
        super(columns);
        int maxRowCount = 0;
        for (Column column : columns) {
            maxRowCount = Math.max(maxRowCount, column.size());
        }
        for (int rowIndex = 0; rowIndex < maxRowCount; ++rowIndex) {
            ArrayList rowData = new ArrayList(1 + columns.length);
            for (Column column : columns) {
                rowData.add(column.get(rowIndex));
            }
            this.rows.add(new Record(rowData));
        }
    }

    @Override
    public int add(Comparable<?> ... values) {
        return this.add(Arrays.asList(values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add(List<? extends Comparable<?>> values) {
        int rowIndex;
        if (values.size() != this.getColumnCount()) {
            throw new IllegalArgumentException(MessageFormat.format("Wrong number of columns! Expected {0,number,integer}, got {1,number,integer}.", this.getColumnCount(), values.size()));
        }
        Class<? extends Comparable<?>>[] types = this.getColumnTypes();
        for (int colIndex = 0; colIndex < values.size(); ++colIndex) {
            Comparable<?> value = values.get(colIndex);
            if (value == null || types[colIndex].isAssignableFrom(value.getClass())) continue;
            throw new IllegalArgumentException(MessageFormat.format("Wrong column type! Expected {0}, got {1}.", types[colIndex], value.getClass()));
        }
        Record row = new Record(values);
        DataChangeEvent[] events = new DataChangeEvent[row.size()];
        for (int columnIndex = 0; columnIndex < row.size(); ++columnIndex) {
            Comparable<?> value = values.get(columnIndex);
            events[columnIndex] = new DataChangeEvent(this, columnIndex, this.rows.size(), null, value);
        }
        List<Record> list = this.rows;
        synchronized (list) {
            this.rows.add(row);
            rowIndex = this.rows.size();
        }
        this.notifyDataAdded(events);
        return rowIndex - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add(Row row) {
        ArrayList values;
        Row row2 = row;
        synchronized (row2) {
            values = new ArrayList(row.size());
            for (Comparable<?> value : row) {
                values.add(value);
            }
        }
        return this.add(values);
    }

    public void add(Record row) {
        if (row.size() != this.getColumnCount()) {
            throw new IllegalArgumentException("Invalid element count in Record to be added. Expected: " + this.getColumnCount() + ", got: " + row.size());
        }
        this.rows.add(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int row) {
        DataChangeEvent[] events;
        List<Record> list = this.rows;
        synchronized (list) {
            Row r = new Row(this, row);
            events = new DataChangeEvent[this.getColumnCount()];
            for (int col = 0; col < events.length; ++col) {
                events[col] = new DataChangeEvent(this, col, row, r.get(col), null);
            }
            this.rows.remove(row);
        }
        this.notifyDataRemoved(events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLast() {
        DataChangeEvent[] events;
        DataTable dataTable = this;
        synchronized (dataTable) {
            int row = this.getRowCount() - 1;
            Row r = new Row(this, row);
            events = new DataChangeEvent[this.getColumnCount()];
            for (int col = 0; col < events.length; ++col) {
                events[col] = new DataChangeEvent(this, col, row, r.get(col), null);
            }
            this.rows.remove(row);
        }
        this.notifyDataRemoved(events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        DataChangeEvent[] events;
        DataTable dataTable = this;
        synchronized (dataTable) {
            int cols = this.getColumnCount();
            int rows = this.getRowCount();
            events = new DataChangeEvent[cols * rows];
            for (int row = 0; row < rows; ++row) {
                for (int col = 0; col < cols; ++col) {
                    events[col + row * cols] = new DataChangeEvent(this, col, row, this.get(col, row), null);
                }
            }
            this.rows.clear();
        }
        this.notifyDataRemoved(events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Comparable<?> get(int col, int row) {
        Record r;
        List<Record> list = this.rows;
        synchronized (list) {
            if (row >= this.rows.size()) {
                return null;
            }
            r = this.rows.get(row);
        }
        if (r == null) {
            return null;
        }
        return r.get(col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Comparable<T> set(int col, int row, Comparable<T> value) {
        Comparable<?> old;
        DataChangeEvent event = null;
        DataTable dataTable = this;
        synchronized (dataTable) {
            old = this.get(col, row);
            if (old == null || !old.equals(value)) {
                Record record = this.rows.get(row);
                ArrayList<Comparable<T>> values = new ArrayList<Comparable<T>>(record.size());
                for (Comparable<?> element : record) {
                    values.add(element);
                }
                values.set(col, value);
                Record updatedRecord = new Record(values);
                this.rows.set(row, updatedRecord);
                event = new DataChangeEvent(this, col, row, old, value);
            }
        }
        if (event != null) {
            this.notifyDataUpdated(event);
        }
        return old;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sort(DataComparator ... comparators) {
        List<Record> list = this.rows;
        synchronized (list) {
            RecordComparator comparator = new RecordComparator(comparators);
            Collections.sort(this.rows, comparator);
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    private final class RecordComparator
    implements Comparator<Record> {
        private final DataComparator[] comparators;

        public RecordComparator(DataComparator[] comparators) {
            this.comparators = comparators;
        }

        @Override
        public int compare(Record record1, Record record2) {
            for (DataComparator comparator : this.comparators) {
                int result = comparator.compare(record1, record2);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }
}

