/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data;

import de.erichseifert.gral.data.statistics.Statistics;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Column<T extends Comparable<T>>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 7380420622890027262L;
    private final Class<T> dataType;
    private final List<T> data;

    public Column(Class<T> dataType, T ... data) {
        this(dataType, (Iterable<T>)Arrays.asList(data));
    }

    public Column(Class<T> dataType, Iterable<T> data) {
        this.dataType = dataType;
        this.data = new ArrayList<T>();
        for (Comparable item : data) {
            this.data.add(item);
        }
    }

    public T get(int row) {
        return (T)(row >= this.data.size() ? null : (Comparable)this.data.get(row));
    }

    public int size() {
        return this.data.size();
    }

    public boolean isNumeric() {
        return Number.class.isAssignableFrom(this.getType());
    }

    public Class<? extends Comparable<?>> getType() {
        return this.dataType;
    }

    public double getStatistics(String key) {
        return new Statistics(this.data).get(key);
    }

    public int hashCode() {
        return this.dataType.hashCode() ^ this.data.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Column)) {
            return false;
        }
        Column column = (Column)obj;
        return this.getType().equals(column.getType()) && this.data.equals(column.data);
    }

    @Override
    public Iterator<T> iterator() {
        return this.data.iterator();
    }
}

