/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data;

import de.erichseifert.gral.data.Column;
import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataListener;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.data.Record;
import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.data.statistics.Statistics;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class AbstractDataSource
implements DataSource,
Serializable {
    private static final long serialVersionUID = 9139975565475816812L;
    private String name;
    private int columnCount;
    private Class<? extends Comparable<?>>[] types;
    private transient Set<DataListener> dataListeners;
    private transient Statistics statistics;

    public AbstractDataSource() {
        this((String)null, (Class<? extends Comparable<?>>[])new Class[0]);
    }

    public AbstractDataSource(String name, Class<? extends Comparable<?>> ... types) {
        this.name = name;
        this.setColumnTypes(types);
        this.dataListeners = new LinkedHashSet<DataListener>();
    }

    public AbstractDataSource(Class<? extends Comparable<?>> ... types) {
        this((String)null, types);
    }

    public AbstractDataSource(Column ... remainingColumns) {
        Class[] columnTypes = new Class[remainingColumns.length];
        for (int columnIndex = 0; columnIndex < remainingColumns.length; ++columnIndex) {
            Column column = remainingColumns[columnIndex];
            columnTypes[columnIndex] = column.getType();
        }
        this.setColumnTypes(columnTypes);
        this.dataListeners = new LinkedHashSet<DataListener>();
    }

    @Override
    public Statistics getStatistics() {
        if (this.statistics == null) {
            this.statistics = new Statistics(this);
        }
        return this.statistics;
    }

    @Override
    public DataSource getColumnStatistics(String key) {
        Object[] columnTypes = new Class[this.getColumnCount()];
        Arrays.fill(columnTypes, Double.class);
        DataTable statisticsTable = new DataTable((Class<? extends Comparable<?>>[])columnTypes);
        ArrayList<Double> colStatistics = new ArrayList<Double>(columnTypes.length);
        for (int colIndex = 0; colIndex < this.getColumnCount(); ++colIndex) {
            Column<?> col = this.getColumn(colIndex);
            colStatistics.add(col.getStatistics(key));
        }
        if (!colStatistics.isEmpty()) {
            statisticsTable.add(colStatistics);
        }
        return statisticsTable;
    }

    @Override
    public DataSource getRowStatistics(String key) {
        DataTable statisticsTable = this.getRowCount() != 0 ? new DataTable(Double.class) : new DataTable();
        for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
            Record row = this.getRecord(rowIndex);
            statisticsTable.add(Double.valueOf(new Statistics(row).get(key)));
        }
        return statisticsTable;
    }

    @Override
    public void addDataListener(DataListener dataListener) {
        this.dataListeners.add(dataListener);
    }

    @Override
    public void removeDataListener(DataListener dataListener) {
        this.dataListeners.remove(dataListener);
    }

    @Override
    public Iterator<Comparable<?>> iterator() {
        return new DataSourceIterator();
    }

    protected void notifyDataAdded(DataChangeEvent ... events) {
        LinkedList<DataListener> listeners = new LinkedList<DataListener>(this.dataListeners);
        for (DataListener dataListener : listeners) {
            dataListener.dataAdded(this, events);
        }
    }

    protected void notifyDataRemoved(DataChangeEvent ... events) {
        LinkedList<DataListener> listeners = new LinkedList<DataListener>(this.dataListeners);
        for (DataListener dataListener : listeners) {
            dataListener.dataRemoved(this, events);
        }
    }

    protected void notifyDataUpdated(DataChangeEvent ... events) {
        LinkedList<DataListener> listeners = new LinkedList<DataListener>(this.dataListeners);
        for (DataListener dataListener : listeners) {
            dataListener.dataUpdated(this, events);
        }
    }

    @Override
    public Column<?> getColumn(int col) {
        Class<? extends Comparable<?>> columnType = this.getColumnTypes()[col];
        LinkedList columnData = new LinkedList();
        for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
            Record record = this.getRecord(rowIndex);
            columnData.add(record.get(col));
        }
        return new Column(columnType, columnData.toArray(new Comparable[0]));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Record getRecord(int row) {
        return new Record(this.getRow(row).toArray(null));
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public Class<? extends Comparable<?>>[] getColumnTypes() {
        Class<? extends Comparable<?>>[] types = Arrays.copyOf(this.types, this.types.length);
        return types;
    }

    @Override
    public boolean isColumnNumeric(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.types.length) {
            return false;
        }
        Class<? extends Comparable<?>> columnType = this.types[columnIndex];
        return Number.class.isAssignableFrom(columnType);
    }

    protected void setColumnTypes(Class<? extends Comparable<?>> ... types) {
        this.types = Arrays.copyOf(types, types.length);
        this.columnCount = types.length;
    }

    @Override
    public Row getRow(int row) {
        return new Row(this, row);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.dataListeners = new HashSet<DataListener>();
    }

    private class DataSourceIterator
    implements Iterator<Comparable<?>> {
        private int col = 0;
        private int row = 0;

        @Override
        public boolean hasNext() {
            return this.col < AbstractDataSource.this.getColumnCount() && this.row < AbstractDataSource.this.getRowCount();
        }

        @Override
        public Comparable<?> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Comparable<?> value = AbstractDataSource.this.get(this.col, this.row);
            if (++this.col >= AbstractDataSource.this.getColumnCount()) {
                this.col = 0;
                ++this.row;
            }
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

