/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.ref;

import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.Former;
import cern.colt.matrix.FormerFactory;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.algo.FloatFormatter;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix3D;
import hep.aida.tfloat.FloatIAxis;
import hep.aida.tfloat.FloatIHistogram1D;
import hep.aida.tfloat.FloatIHistogram2D;
import hep.aida.tfloat.FloatIHistogram3D;
import hep.aida.tfloat.bin.FloatBinFunction1D;
import hep.aida.tfloat.bin.FloatBinFunctions1D;

public class FloatConverter {
    public float[] edges(FloatIAxis axis) {
        int b = axis.bins();
        float[] bounds = new float[b + 1];
        for (int i = 0; i < b; ++i) {
            bounds[i] = axis.binLowerEdge(i);
        }
        bounds[b] = axis.upperEdge();
        return bounds;
    }

    String form(Former formatter, float value) {
        return formatter.form(value);
    }

    protected float[] toArrayErrors(FloatIHistogram1D h) {
        int xBins = h.xAxis().bins();
        float[] array = new float[xBins];
        int j = xBins;
        while (--j >= 0) {
            array[j] = h.binError(j);
        }
        return array;
    }

    protected float[][] toArrayErrors(FloatIHistogram2D h) {
        int xBins = h.xAxis().bins();
        int yBins = h.yAxis().bins();
        float[][] array = new float[xBins][yBins];
        int i = yBins;
        while (--i >= 0) {
            int j = xBins;
            while (--j >= 0) {
                array[j][i] = h.binError(j, i);
            }
        }
        return array;
    }

    protected float[] toArrayHeights(FloatIHistogram1D h) {
        int xBins = h.xAxis().bins();
        float[] array = new float[xBins];
        int j = xBins;
        while (--j >= 0) {
            array[j] = h.binHeight(j);
        }
        return array;
    }

    protected float[][] toArrayHeights(FloatIHistogram2D h) {
        int xBins = h.xAxis().bins();
        int yBins = h.yAxis().bins();
        float[][] array = new float[xBins][yBins];
        int i = yBins;
        while (--i >= 0) {
            int j = xBins;
            while (--j >= 0) {
                array[j][i] = h.binHeight(j, i);
            }
        }
        return array;
    }

    protected float[][][] toArrayHeights(FloatIHistogram3D h) {
        int xBins = h.xAxis().bins();
        int yBins = h.yAxis().bins();
        int zBins = h.zAxis().bins();
        float[][][] array = new float[xBins][yBins][zBins];
        int j = xBins;
        while (--j >= 0) {
            int i = yBins;
            while (--i >= 0) {
                int k = zBins;
                while (--k >= 0) {
                    array[j][i][k] = h.binHeight(j, i, k);
                }
            }
        }
        return array;
    }

    protected static String toString(float[] array) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int maxIndex = array.length - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            buf.append(array[i]);
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public String toString(FloatIAxis axis) {
        StringBuffer buf = new StringBuffer();
        buf.append("Range: [" + axis.lowerEdge() + "," + axis.upperEdge() + ")");
        buf.append(", Bins: " + axis.bins());
        buf.append(", Bin edges: " + FloatConverter.toString(this.edges(axis)) + "\n");
        return buf.toString();
    }

    public String toString(FloatIHistogram1D h) {
        String columnAxisName = null;
        String rowAxisName = null;
        FloatBinFunction1D[] aggr = null;
        String format = "%G";
        Former f = new FormerFactory().create(format);
        String sep = System.getProperty("line.separator");
        int[] minMaxBins = h.minMaxBins();
        String title = h.title() + ":" + sep + "   Entries=" + this.form(f, h.entries()) + ", ExtraEntries=" + this.form(f, h.extraEntries()) + sep + "   Mean=" + this.form(f, h.mean()) + ", Rms=" + this.form(f, h.rms()) + sep + "   MinBinHeight=" + this.form(f, h.binHeight(minMaxBins[0])) + ", MaxBinHeight=" + this.form(f, h.binHeight(minMaxBins[1])) + sep + "   Axis: " + "Bins=" + this.form(f, h.xAxis().bins()) + ", Min=" + this.form(f, h.xAxis().lowerEdge()) + ", Max=" + this.form(f, h.xAxis().upperEdge());
        String[] xEdges = new String[h.xAxis().bins()];
        for (int i = 0; i < h.xAxis().bins(); ++i) {
            xEdges[i] = this.form(f, h.xAxis().binLowerEdge(i));
        }
        String[] yEdges = null;
        DenseFloatMatrix2D heights = new DenseFloatMatrix2D(1, h.xAxis().bins());
        heights.viewRow(0).assign(this.toArrayHeights(h));
        return title + sep + "Heights:" + sep + new FloatFormatter().toTitleString(heights, yEdges, xEdges, rowAxisName, columnAxisName, null, aggr);
    }

    public String toString(FloatIHistogram2D h) {
        String columnAxisName = "X";
        String rowAxisName = "Y";
        FloatBinFunction1D[] aggr = new FloatBinFunction1D[]{FloatBinFunctions1D.sum};
        String format = "%G";
        Former f = new FormerFactory().create(format);
        String sep = System.getProperty("line.separator");
        int[] minMaxBins = h.minMaxBins();
        String title = h.title() + ":" + sep + "   Entries=" + this.form(f, h.entries()) + ", ExtraEntries=" + this.form(f, h.extraEntries()) + sep + "   MeanX=" + this.form(f, h.meanX()) + ", RmsX=" + this.form(f, h.rmsX()) + sep + "   MeanY=" + this.form(f, h.meanY()) + ", RmsY=" + this.form(f, h.rmsX()) + sep + "   MinBinHeight=" + this.form(f, h.binHeight(minMaxBins[0], minMaxBins[1])) + ", MaxBinHeight=" + this.form(f, h.binHeight(minMaxBins[2], minMaxBins[3])) + sep + "   xAxis: " + "Bins=" + this.form(f, h.xAxis().bins()) + ", Min=" + this.form(f, h.xAxis().lowerEdge()) + ", Max=" + this.form(f, h.xAxis().upperEdge()) + sep + "   yAxis: " + "Bins=" + this.form(f, h.yAxis().bins()) + ", Min=" + this.form(f, h.yAxis().lowerEdge()) + ", Max=" + this.form(f, h.yAxis().upperEdge());
        String[] xEdges = new String[h.xAxis().bins()];
        for (int i = 0; i < h.xAxis().bins(); ++i) {
            xEdges[i] = this.form(f, h.xAxis().binLowerEdge(i));
        }
        Object[] yEdges = new String[h.yAxis().bins()];
        for (int i = 0; i < h.yAxis().bins(); ++i) {
            yEdges[i] = this.form(f, h.yAxis().binLowerEdge(i));
        }
        new ObjectArrayList(yEdges).reverse();
        FloatMatrix2D heights = new DenseFloatMatrix2D(this.toArrayHeights(h));
        heights = heights.viewDice().viewRowFlip();
        return title + sep + "Heights:" + sep + new FloatFormatter().toTitleString(heights, (String[])yEdges, xEdges, rowAxisName, columnAxisName, null, aggr);
    }

    public String toString(FloatIHistogram3D h) {
        String columnAxisName = "X";
        String rowAxisName = "Y";
        String sliceAxisName = "Z";
        FloatBinFunction1D[] aggr = new FloatBinFunction1D[]{FloatBinFunctions1D.sum};
        String format = "%G";
        Former f = new FormerFactory().create(format);
        String sep = System.getProperty("line.separator");
        int[] minMaxBins = h.minMaxBins();
        String title = h.title() + ":" + sep + "   Entries=" + this.form(f, h.entries()) + ", ExtraEntries=" + this.form(f, h.extraEntries()) + sep + "   MeanX=" + this.form(f, h.meanX()) + ", RmsX=" + this.form(f, h.rmsX()) + sep + "   MeanY=" + this.form(f, h.meanY()) + ", RmsY=" + this.form(f, h.rmsX()) + sep + "   MeanZ=" + this.form(f, h.meanZ()) + ", RmsZ=" + this.form(f, h.rmsZ()) + sep + "   MinBinHeight=" + this.form(f, h.binHeight(minMaxBins[0], minMaxBins[1], minMaxBins[2])) + ", MaxBinHeight=" + this.form(f, h.binHeight(minMaxBins[3], minMaxBins[4], minMaxBins[5])) + sep + "   xAxis: " + "Bins=" + this.form(f, h.xAxis().bins()) + ", Min=" + this.form(f, h.xAxis().lowerEdge()) + ", Max=" + this.form(f, h.xAxis().upperEdge()) + sep + "   yAxis: " + "Bins=" + this.form(f, h.yAxis().bins()) + ", Min=" + this.form(f, h.yAxis().lowerEdge()) + ", Max=" + this.form(f, h.yAxis().upperEdge()) + sep + "   zAxis: " + "Bins=" + this.form(f, h.zAxis().bins()) + ", Min=" + this.form(f, h.zAxis().lowerEdge()) + ", Max=" + this.form(f, h.zAxis().upperEdge());
        String[] xEdges = new String[h.xAxis().bins()];
        for (int i = 0; i < h.xAxis().bins(); ++i) {
            xEdges[i] = this.form(f, h.xAxis().binLowerEdge(i));
        }
        Object[] yEdges = new String[h.yAxis().bins()];
        for (int i = 0; i < h.yAxis().bins(); ++i) {
            yEdges[i] = this.form(f, h.yAxis().binLowerEdge(i));
        }
        new ObjectArrayList(yEdges).reverse();
        Object[] zEdges = new String[h.zAxis().bins()];
        for (int i = 0; i < h.zAxis().bins(); ++i) {
            zEdges[i] = this.form(f, h.zAxis().binLowerEdge(i));
        }
        new ObjectArrayList(zEdges).reverse();
        FloatMatrix3D heights = new DenseFloatMatrix3D(this.toArrayHeights(h));
        heights = heights.viewDice(2, 1, 0).viewSliceFlip().viewRowFlip();
        return title + sep + "Heights:" + sep + new FloatFormatter().toTitleString(heights, (String[])zEdges, (String[])yEdges, xEdges, sliceAxisName, rowAxisName, columnAxisName, "", aggr);
    }

    public String toXML(FloatIHistogram1D h) {
        StringBuffer buf = new StringBuffer();
        String sep = System.getProperty("line.separator");
        buf.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
        buf.append(sep);
        buf.append("<!DOCTYPE plotML SYSTEM \"plotML.dtd\">");
        buf.append(sep);
        buf.append("<plotML>");
        buf.append(sep);
        buf.append("<plot>");
        buf.append(sep);
        buf.append("<dataArea>");
        buf.append(sep);
        buf.append("<data1d>");
        buf.append(sep);
        buf.append("<bins1d title=\"" + h.title() + "\">");
        buf.append(sep);
        for (int i = 0; i < h.xAxis().bins(); ++i) {
            buf.append(h.binEntries(i) + "," + h.binError(i));
            buf.append(sep);
        }
        buf.append("</bins1d>");
        buf.append(sep);
        buf.append("<binnedDataAxisAttributes type=\"float\" axis=\"x0\"");
        buf.append(" min=\"" + h.xAxis().lowerEdge() + "\"");
        buf.append(" max=\"" + h.xAxis().upperEdge() + "\"");
        buf.append(" numberOfBins=\"" + h.xAxis().bins() + "\"");
        buf.append("/>");
        buf.append(sep);
        buf.append("<statistics>");
        buf.append(sep);
        buf.append("<statistic name=\"Entries\" value=\"" + h.entries() + "\"/>");
        buf.append(sep);
        buf.append("<statistic name=\"Underflow\" value=\"" + h.binEntries(-2) + "\"/>");
        buf.append(sep);
        buf.append("<statistic name=\"Overflow\" value=\"" + h.binEntries(-1) + "\"/>");
        buf.append(sep);
        if (!Float.isNaN(h.mean())) {
            buf.append("<statistic name=\"Mean\" value=\"" + h.mean() + "\"/>");
            buf.append(sep);
        }
        if (!Float.isNaN(h.rms())) {
            buf.append("<statistic name=\"RMS\" value=\"" + h.rms() + "\"/>");
            buf.append(sep);
        }
        buf.append("</statistics>");
        buf.append(sep);
        buf.append("</data1d>");
        buf.append(sep);
        buf.append("</dataArea>");
        buf.append(sep);
        buf.append("</plot>");
        buf.append(sep);
        buf.append("</plotML>");
        buf.append(sep);
        return buf.toString();
    }

    public String toXML(FloatIHistogram2D h) {
        StringBuffer out = new StringBuffer();
        String sep = System.getProperty("line.separator");
        out.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
        out.append(sep);
        out.append("<!DOCTYPE plotML SYSTEM \"plotML.dtd\">");
        out.append(sep);
        out.append("<plotML>");
        out.append(sep);
        out.append("<plot>");
        out.append(sep);
        out.append("<dataArea>");
        out.append(sep);
        out.append("<data2d type=\"xxx\">");
        out.append(sep);
        out.append("<bins2d title=\"" + h.title() + "\" xSize=\"" + h.xAxis().bins() + "\" ySize=\"" + h.yAxis().bins() + "\">");
        out.append(sep);
        for (int i = 0; i < h.xAxis().bins(); ++i) {
            for (int j = 0; j < h.yAxis().bins(); ++j) {
                out.append(h.binEntries(i, j) + "," + h.binError(i, j));
                out.append(sep);
            }
        }
        out.append("</bins2d>");
        out.append(sep);
        out.append("<binnedDataAxisAttributes type=\"float\" axis=\"x0\"");
        out.append(" min=\"" + h.xAxis().lowerEdge() + "\"");
        out.append(" max=\"" + h.xAxis().upperEdge() + "\"");
        out.append(" numberOfBins=\"" + h.xAxis().bins() + "\"");
        out.append("/>");
        out.append(sep);
        out.append("<binnedDataAxisAttributes type=\"float\" axis=\"y0\"");
        out.append(" min=\"" + h.yAxis().lowerEdge() + "\"");
        out.append(" max=\"" + h.yAxis().upperEdge() + "\"");
        out.append(" numberOfBins=\"" + h.yAxis().bins() + "\"");
        out.append("/>");
        out.append(sep);
        out.append("</data2d>");
        out.append(sep);
        out.append("</dataArea>");
        out.append(sep);
        out.append("</plot>");
        out.append(sep);
        out.append("</plotML>");
        out.append(sep);
        return out.toString();
    }
}

