/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.bin;

import cern.colt.list.tfloat.FloatArrayList;
import cern.jet.stat.tfloat.FloatDescriptive;
import hep.aida.tfloat.bin.AbstractFloatBin1D;
import hep.aida.tfloat.bin.StaticFloatBin1D;

public class MightyStaticFloatBin1D
extends StaticFloatBin1D {
    private static final long serialVersionUID = 1L;
    protected boolean hasSumOfLogarithms = false;
    protected float sumOfLogarithms = 0.0f;
    protected boolean hasSumOfInversions = false;
    protected float sumOfInversions = 0.0f;
    protected float[] sumOfPowers = null;

    public MightyStaticFloatBin1D() {
        this(false, false, 4);
    }

    public MightyStaticFloatBin1D(boolean hasSumOfLogarithms, boolean hasSumOfInversions, int maxOrderForSumOfPowers) {
        this.setMaxOrderForSumOfPowers(maxOrderForSumOfPowers);
        this.hasSumOfLogarithms = hasSumOfLogarithms;
        this.hasSumOfInversions = hasSumOfInversions;
        this.clear();
    }

    @Override
    public synchronized void addAllOfFromTo(FloatArrayList list, int from, int to) {
        super.addAllOfFromTo(list, from, to);
        if (this.sumOfPowers != null) {
            FloatDescriptive.incrementalUpdateSumsOfPowers(list, from, to, 3, this.getMaxOrderForSumOfPowers(), this.sumOfPowers);
        }
        if (this.hasSumOfInversions) {
            this.sumOfInversions += FloatDescriptive.sumOfInversions(list, from, to);
        }
        if (this.hasSumOfLogarithms) {
            this.sumOfLogarithms += FloatDescriptive.sumOfLogarithms(list, from, to);
        }
    }

    @Override
    protected void clearAllMeasures() {
        super.clearAllMeasures();
        this.sumOfLogarithms = 0.0f;
        this.sumOfInversions = 0.0f;
        if (this.sumOfPowers != null) {
            int i = this.sumOfPowers.length;
            while (--i >= 0) {
                this.sumOfPowers[i] = 0.0f;
            }
        }
    }

    @Override
    public synchronized Object clone() {
        MightyStaticFloatBin1D clone = (MightyStaticFloatBin1D)super.clone();
        if (this.sumOfPowers != null) {
            clone.sumOfPowers = (float[])clone.sumOfPowers.clone();
        }
        return clone;
    }

    @Override
    public String compareWith(AbstractFloatBin1D other) {
        StringBuffer buf = new StringBuffer(super.compareWith(other));
        if (other instanceof MightyStaticFloatBin1D) {
            MightyStaticFloatBin1D m = (MightyStaticFloatBin1D)other;
            if (this.hasSumOfLogarithms() && m.hasSumOfLogarithms()) {
                buf.append("geometric mean: " + this.relError(this.geometricMean(), m.geometricMean()) + " %\n");
            }
            if (this.hasSumOfInversions() && m.hasSumOfInversions()) {
                buf.append("harmonic mean: " + this.relError(this.harmonicMean(), m.harmonicMean()) + " %\n");
            }
            if (this.hasSumOfPowers(3) && m.hasSumOfPowers(3)) {
                buf.append("skew: " + this.relError(this.skew(), m.skew()) + " %\n");
            }
            if (this.hasSumOfPowers(4) && m.hasSumOfPowers(4)) {
                buf.append("kurtosis: " + this.relError(this.kurtosis(), m.kurtosis()) + " %\n");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public synchronized float geometricMean() {
        return FloatDescriptive.geometricMean(this.size(), this.sumOfLogarithms());
    }

    public synchronized int getMaxOrderForSumOfPowers() {
        if (this.sumOfPowers == null) {
            return 2;
        }
        return 2 + this.sumOfPowers.length;
    }

    public synchronized int getMinOrderForSumOfPowers() {
        int minOrder = 0;
        if (this.hasSumOfInversions()) {
            minOrder = -1;
        }
        return minOrder;
    }

    public synchronized float harmonicMean() {
        return FloatDescriptive.harmonicMean(this.size(), this.sumOfInversions());
    }

    public boolean hasSumOfInversions() {
        return this.hasSumOfInversions;
    }

    public boolean hasSumOfLogarithms() {
        return this.hasSumOfLogarithms;
    }

    public boolean hasSumOfPowers(int k) {
        return this.getMinOrderForSumOfPowers() <= k && k <= this.getMaxOrderForSumOfPowers();
    }

    public synchronized float kurtosis() {
        return FloatDescriptive.kurtosis(this.moment(4, this.mean()), this.standardDeviation());
    }

    public synchronized float moment(int k, float c) {
        if (k < 0) {
            throw new IllegalArgumentException("k must be >= 0");
        }
        if (!this.hasSumOfPowers(k)) {
            return Float.NaN;
        }
        int maxOrder = Math.min(k, this.getMaxOrderForSumOfPowers());
        FloatArrayList sumOfPows = new FloatArrayList(maxOrder + 1);
        sumOfPows.add(this.size());
        sumOfPows.add(this.sum());
        sumOfPows.add(this.sumOfSquares());
        for (int i = 3; i <= maxOrder; ++i) {
            sumOfPows.add(this.sumOfPowers(i));
        }
        return FloatDescriptive.moment(k, c, this.size(), sumOfPows.elements());
    }

    public float product() {
        return FloatDescriptive.product(this.size(), this.sumOfLogarithms());
    }

    protected void setMaxOrderForSumOfPowers(int max_k) {
        this.sumOfPowers = (float[])(max_k <= 2 ? null : new float[max_k - 2]);
    }

    public synchronized float skew() {
        return FloatDescriptive.skew(this.moment(3, this.mean()), this.standardDeviation());
    }

    public float sumOfInversions() {
        if (!this.hasSumOfInversions) {
            return Float.NaN;
        }
        return this.sumOfInversions;
    }

    public synchronized float sumOfLogarithms() {
        if (!this.hasSumOfLogarithms) {
            return Float.NaN;
        }
        return this.sumOfLogarithms;
    }

    public synchronized float sumOfPowers(int k) {
        if (!this.hasSumOfPowers(k)) {
            return Float.NaN;
        }
        if (k == -1) {
            return this.sumOfInversions();
        }
        if (k == 0) {
            return this.size();
        }
        if (k == 1) {
            return this.sum();
        }
        if (k == 2) {
            return this.sumOfSquares();
        }
        return this.sumOfPowers[k - 3];
    }

    @Override
    public synchronized String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        if (this.hasSumOfLogarithms()) {
            buf.append("Geometric mean: " + this.geometricMean());
            buf.append("\nProduct: " + this.product() + "\n");
        }
        if (this.hasSumOfInversions()) {
            buf.append("Harmonic mean: " + this.harmonicMean());
            buf.append("\nSum of inversions: " + this.sumOfInversions() + "\n");
        }
        int maxOrder = this.getMaxOrderForSumOfPowers();
        int maxPrintOrder = Math.min(6, maxOrder);
        if (maxOrder > 2) {
            int k;
            if (maxOrder >= 3) {
                buf.append("Skew: " + this.skew() + "\n");
            }
            if (maxOrder >= 4) {
                buf.append("Kurtosis: " + this.kurtosis() + "\n");
            }
            for (int i = 3; i <= maxPrintOrder; ++i) {
                buf.append("Sum of powers(" + i + "): " + this.sumOfPowers(i) + "\n");
            }
            for (k = 0; k <= maxPrintOrder; ++k) {
                buf.append("Moment(" + k + ",0): " + this.moment(k, 0.0f) + "\n");
            }
            for (k = 0; k <= maxPrintOrder; ++k) {
                buf.append("Moment(" + k + ",mean()): " + this.moment(k, this.mean()) + "\n");
            }
        }
        return buf.toString();
    }

    protected void xcheckOrder(int k) {
    }

    protected boolean xequals(Object object) {
        if (!(object instanceof MightyStaticFloatBin1D)) {
            return false;
        }
        MightyStaticFloatBin1D other = (MightyStaticFloatBin1D)object;
        return super.equals(other) && this.sumOfInversions() == other.sumOfInversions() && this.sumOfLogarithms() == other.sumOfLogarithms();
    }

    protected boolean xhasSumOfPowers(int fromK, int toK) {
        if (fromK > toK) {
            throw new IllegalArgumentException("fromK must be less or equal to toK");
        }
        return this.getMinOrderForSumOfPowers() <= fromK && toK <= this.getMaxOrderForSumOfPowers();
    }

    protected synchronized boolean xisLegalOrder(int k) {
        return this.getMinOrderForSumOfPowers() <= k && k <= this.getMaxOrderForSumOfPowers();
    }
}

