/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.utils;

import edu.emory.utils.ConcurrencyUtils;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Random;

public class IOUtils {
    public static void fillMatrix_1D(int N, double[] m) {
        Random r = new Random(2L);
        for (int i = 0; i < N; ++i) {
            m[i] = r.nextDouble();
        }
    }

    public static void fillMatrix_1D(int N, float[] m) {
        Random r = new Random(2L);
        for (int i = 0; i < N; ++i) {
            m[i] = r.nextFloat();
        }
    }

    public static void fillMatrix_2D(int n1, int n2, double[] m) {
        Random r = new Random(2L);
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                m[i * n2 + j] = r.nextDouble();
            }
        }
    }

    public static void fillMatrix_2D(int n1, int n2, float[] m) {
        Random r = new Random(2L);
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                m[i * n2 + j] = r.nextFloat();
            }
        }
    }

    public static void fillMatrix_2D(int n1, int n2, double[][] m) {
        Random r = new Random(2L);
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                m[i][j] = r.nextDouble();
            }
        }
    }

    public static void fillMatrix_2D(int n1, int n2, float[][] m) {
        Random r = new Random(2L);
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                m[i][j] = r.nextFloat();
            }
        }
    }

    public static void fillMatrix_3D(int n1, int n2, int n3, double[] m) {
        Random r = new Random(2L);
        int sliceStride = n2 * n3;
        int rowStride = n3;
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    m[i * sliceStride + j * rowStride + k] = r.nextDouble();
                }
            }
        }
    }

    public static void fillMatrix_3D(int n1, int n2, int n3, float[] m) {
        Random r = new Random(2L);
        int sliceStride = n2 * n3;
        int rowStride = n3;
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    m[i * sliceStride + j * rowStride + k] = r.nextFloat();
                }
            }
        }
    }

    public static void fillMatrix_3D(int n1, int n2, int n3, double[][][] m) {
        Random r = new Random(2L);
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    m[i][j][k] = r.nextDouble();
                }
            }
        }
    }

    public static void fillMatrix_3D(int n1, int n2, int n3, float[][][] m) {
        Random r = new Random(2L);
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    m[i][j][k] = r.nextFloat();
                }
            }
        }
    }

    public static void showComplex_1D(String format, double[] x, String title) {
        System.out.println(title);
        System.out.println("-------------------");
        for (int i = 0; i < x.length; i += 2) {
            if (x[i + 1] == 0.0) {
                System.out.println(String.format(format, x[i]));
                continue;
            }
            if (x[i] == 0.0) {
                System.out.println(String.format(format, x[i + 1]) + "i");
                continue;
            }
            if (x[i + 1] < 0.0) {
                System.out.println(String.format(format, x[i]) + " - " + String.format(format, -x[i + 1]) + "i");
                continue;
            }
            System.out.println(String.format(format, x[i]) + " + " + String.format(format, x[i + 1]) + "i");
        }
        System.out.println();
    }

    public static void showComplex_2D(String format, int rows, int columns, double[] x, String title) {
        StringBuffer s = new StringBuffer(String.format(title + ": complex array 2D: %d rows, %d columns\n\n", rows, columns));
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < 2 * columns; c += 2) {
                if (x[r * 2 * columns + c + 1] == 0.0) {
                    s.append(String.format(format + "\t", x[r * 2 * columns + c]));
                    continue;
                }
                if (x[r * 2 * columns + c] == 0.0) {
                    s.append(String.format(format + "i\t", x[r * 2 * columns + c + 1]));
                    continue;
                }
                if (x[r * 2 * columns + c + 1] < 0.0) {
                    s.append(String.format(format + " - " + format + "i\t", x[r * 2 * columns + c], -x[r * 2 * columns + c + 1]));
                    continue;
                }
                s.append(String.format(format + " + " + format + "i\t", x[r * 2 * columns + c], x[r * 2 * columns + c + 1]));
            }
            s.append("\n");
        }
        System.out.println(s.toString());
    }

    public static void showComplex_3D(String format, int n1, int n2, int n3, double[] x, String title) {
        int sliceStride = n2 * 2 * n3;
        int rowStride = 2 * n3;
        System.out.println(title);
        System.out.println("-------------------");
        for (int k = 0; k < 2 * n3; k += 2) {
            System.out.println("(:,:," + k / 2 + ")=\n");
            for (int i = 0; i < n1; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (x[i * sliceStride + j * rowStride + k + 1] == 0.0) {
                        System.out.print(String.format(format, x[i * sliceStride + j * rowStride + k]) + "\t");
                        continue;
                    }
                    if (x[i * sliceStride + j * rowStride + k] == 0.0) {
                        System.out.print(String.format(format, x[i * sliceStride + j * rowStride + k + 1]) + "i\t");
                        continue;
                    }
                    if (x[i * sliceStride + j * rowStride + k + 1] < 0.0) {
                        System.out.print(String.format(format, x[i * sliceStride + j * rowStride + k]) + " - " + String.format(format, -x[i * sliceStride + j * rowStride + k + 1]) + "i\t");
                        continue;
                    }
                    System.out.print(String.format(format, x[i * sliceStride + j * rowStride + k]) + " + " + String.format(format, x[i * sliceStride + j * rowStride + k + 1]) + "i\t");
                }
                System.out.println("");
            }
        }
        System.out.println("");
    }

    public static void showReal_1D(String format, double[] x, String title) {
        System.out.println(title);
        System.out.println("-------------------");
        for (int j = 0; j < x.length; ++j) {
            System.out.println(String.format(format, x[j]));
        }
        System.out.println();
    }

    public static void showReal_2D(String format, int n1, int n2, double[] x, String title) {
        System.out.println(title);
        System.out.println("-------------------");
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (Math.abs(x[i * n2 + j]) < 5.0E-5) {
                    System.out.print("0\t");
                    continue;
                }
                System.out.print(String.format(format, x[i * n2 + j]) + "\t");
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void showReal_3D(String format, int n1, int n2, int n3, double[] x, String title) {
        int sliceStride = n2 * n3;
        int rowStride = n3;
        System.out.println(title);
        System.out.println("-------------------");
        for (int k = 0; k < n3; ++k) {
            System.out.println();
            System.out.println("(:,:," + k + ")=\n");
            for (int i = 0; i < n1; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (Math.abs(x[i * sliceStride + j * rowStride + k]) <= 5.0E-5) {
                        System.out.print("0\t");
                        continue;
                    }
                    System.out.print(String.format(format, x[i * sliceStride + j * rowStride + k]) + "\t");
                }
                System.out.println();
            }
        }
        System.out.println();
    }

    public static void writeToFileComplex_1D(String format, double[] x, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int i = 0; i < x.length; i += 2) {
                if (x[i + 1] == 0.0) {
                    out.write(String.format(format, x[i]));
                    out.newLine();
                    continue;
                }
                if (x[i] == 0.0) {
                    out.write(String.format(format, x[i + 1]) + "i");
                    out.newLine();
                    continue;
                }
                if (x[i + 1] < 0.0) {
                    out.write(String.format(format, x[i]) + " - " + String.format(format, -x[i + 1]) + "i");
                    out.newLine();
                    continue;
                }
                out.write(String.format(format, x[i]) + " + " + String.format(format, x[i + 1]) + "i");
                out.newLine();
            }
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileComplex_2D(String format, int n1, int n2, double[] x, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int i = 0; i < n1; ++i) {
                for (int j = 0; j < 2 * n2; j += 2) {
                    if (Math.abs(x[i * 2 * n2 + j]) < 5.0E-5 && Math.abs(x[i * 2 * n2 + j + 1]) < 5.0E-5) {
                        if (x[i * 2 * n2 + j + 1] >= 0.0) {
                            out.write("0 + 0i\t");
                            continue;
                        }
                        out.write("0 - 0i\t");
                        continue;
                    }
                    if (Math.abs(x[i * 2 * n2 + j + 1]) < 5.0E-5) {
                        if (x[i * 2 * n2 + j + 1] >= 0.0) {
                            out.write(String.format(format, x[i * 2 * n2 + j]) + " + 0i\t");
                            continue;
                        }
                        out.write(String.format(format, x[i * 2 * n2 + j]) + " - 0i\t");
                        continue;
                    }
                    if (Math.abs(x[i * 2 * n2 + j]) < 5.0E-5) {
                        if (x[i * 2 * n2 + j + 1] >= 0.0) {
                            out.write("0 + " + String.format(format, x[i * 2 * n2 + j + 1]) + "i\t");
                            continue;
                        }
                        out.write("0 - " + String.format(format, -x[i * 2 * n2 + j + 1]) + "i\t");
                        continue;
                    }
                    if (x[i * 2 * n2 + j + 1] < 0.0) {
                        out.write(String.format(format, x[i * 2 * n2 + j]) + " - " + String.format(format, -x[i * 2 * n2 + j + 1]) + "i\t");
                        continue;
                    }
                    out.write(String.format(format, x[i * 2 * n2 + j]) + " + " + String.format(format, x[i * 2 * n2 + j + 1]) + "i\t");
                }
                out.newLine();
            }
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileComplex_2D(String format, int n1, int n2, double[][] x, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int i = 0; i < n1; ++i) {
                for (int j = 0; j < 2 * n2; j += 2) {
                    if (Math.abs(x[i][j]) < 5.0E-5 && Math.abs(x[i][j + 1]) < 5.0E-5) {
                        if (x[i][j + 1] >= 0.0) {
                            out.write("0 + 0i\t");
                            continue;
                        }
                        out.write("0 - 0i\t");
                        continue;
                    }
                    if (Math.abs(x[i][j + 1]) < 5.0E-5) {
                        if (x[i][j + 1] >= 0.0) {
                            out.write(String.format(format, x[i][j]) + " + 0i\t");
                            continue;
                        }
                        out.write(String.format(format, x[i][j]) + " - 0i\t");
                        continue;
                    }
                    if (Math.abs(x[i][j]) < 5.0E-5) {
                        if (x[i][j + 1] >= 0.0) {
                            out.write("0 + " + String.format(format, x[i][j + 1]) + "i\t");
                            continue;
                        }
                        out.write("0 - " + String.format(format, -x[i][j + 1]) + "i\t");
                        continue;
                    }
                    if (x[i][j + 1] < 0.0) {
                        out.write(String.format(format, x[i][j]) + " - " + String.format(format, -x[i][j + 1]) + "i\t");
                        continue;
                    }
                    out.write(String.format(format, x[i][j]) + " + " + String.format(format, x[i][j + 1]) + "i\t");
                }
                out.newLine();
            }
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileComplex_3D(String format, int n1, int n2, int n3, double[] x, String filename) {
        int sliceStride = n2 * n3 * 2;
        int rowStride = n3 * 2;
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int k = 0; k < 2 * n3; k += 2) {
                out.newLine();
                out.write("(:,:," + k / 2 + ")=");
                out.newLine();
                out.newLine();
                for (int i = 0; i < n1; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        if (x[i * sliceStride + j * rowStride + k + 1] == 0.0) {
                            out.write(String.format(format, x[i * sliceStride + j * rowStride + k]) + "\t");
                            continue;
                        }
                        if (x[i * sliceStride + j * rowStride + k] == 0.0) {
                            out.write(String.format(format, x[i * sliceStride + j * rowStride + k + 1]) + "i\t");
                            continue;
                        }
                        if (x[i * sliceStride + j * rowStride + k + 1] < 0.0) {
                            out.write(String.format(format, x[i * sliceStride + j * rowStride + k]) + " - " + String.format(format, -x[i * sliceStride + j * rowStride + k + 1]) + "i\t");
                            continue;
                        }
                        out.write(String.format(format, x[i * sliceStride + j * rowStride + k]) + " + " + String.format(format, x[i * sliceStride + j * rowStride + k + 1]) + "i\t");
                    }
                    out.newLine();
                }
            }
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileComplex_3D(String format, int n1, int n2, int n3, double[][][] x, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int k = 0; k < 2 * n3; k += 2) {
                out.newLine();
                out.write("(:,:," + k / 2 + ")=");
                out.newLine();
                out.newLine();
                for (int i = 0; i < n1; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        if (x[i][j][k + 1] == 0.0) {
                            out.write(String.format(format, x[i][j][k]) + "\t");
                            continue;
                        }
                        if (x[i][j][k] == 0.0) {
                            out.write(String.format(format, x[i][j][k + 1]) + "i\t");
                            continue;
                        }
                        if (x[i][j][k + 1] < 0.0) {
                            out.write(String.format(format, x[i][j][k]) + " - " + String.format(format, -x[i][j][k + 1]) + "i\t");
                            continue;
                        }
                        out.write(String.format(format, x[i][j][k]) + " + " + String.format(format, x[i][j][k + 1]) + "i\t");
                    }
                    out.newLine();
                }
            }
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileReal_1D(String format, double[] x, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int j = 0; j < x.length; ++j) {
                out.write(String.format(format, x[j]));
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileReal_1D(int[] x, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int j = 0; j < x.length; ++j) {
                out.write(Integer.toString(x[j]));
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileReal_2D(String format, int n1, int n2, double[] x, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int i = 0; i < n1; ++i) {
                for (int j = 0; j < n2; ++j) {
                    out.write(String.format(format, x[i * n2 + j]) + "\t");
                }
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileReal_2D(String format, double[][] x, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int i = 0; i < x.length; ++i) {
                for (int j = 0; j < x[0].length; ++j) {
                    out.write(String.format(format, x[i][j]) + "\t");
                }
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileReal_2D(String format, float[][] x, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int i = 0; i < x.length; ++i) {
                for (int j = 0; j < x[0].length; ++j) {
                    out.write(String.format(format, Float.valueOf(x[i][j])) + "\t");
                }
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileReal_3D(String format, int slices, int rows, int columns, double[] x, String filename) {
        int sliceStride = rows * columns;
        int rowStride = columns;
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int s = 0; s < slices; ++s) {
                out.newLine();
                out.write("(" + s + ",:,:)=");
                out.newLine();
                out.newLine();
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < columns; ++c) {
                        out.write(String.format(format, x[s * sliceStride + r * rowStride + c]) + "\t");
                    }
                    out.newLine();
                }
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileReal_1D(String format, float[] x, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int j = 0; j < x.length; ++j) {
                out.write(String.format(format, Float.valueOf(x[j])));
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileReal_2D(String format, int n1, int n2, float[] x, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int i = 0; i < n1; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if ((double)Math.abs(x[i * n2 + j]) < 5.0E-5) {
                        out.write("0\t");
                        continue;
                    }
                    out.write(String.format(format, Float.valueOf(x[i * n2 + j])) + "\t");
                }
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileReal_3D(String format, int n1, int n2, int n3, float[] x, String filename) {
        int sliceStride = n2 * n3;
        int rowStride = n3;
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int k = 0; k < n3; ++k) {
                out.newLine();
                out.write("(:,:," + k + ")=");
                out.newLine();
                out.newLine();
                for (int i = 0; i < n1; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        out.write(String.format(format, Float.valueOf(x[i * sliceStride + j * rowStride + k])) + "\t");
                    }
                    out.newLine();
                }
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeFFTBenchmarkResultsToFile(String filename, int nthread, int niter, boolean doWarmup, boolean doScaling, int[] sizes, double[] times) {
        String[] properties = new String[]{"os.name", "os.version", "os.arch", "java.vendor", "java.version"};
        try {
            int i;
            BufferedWriter out = new BufferedWriter(new FileWriter(filename, false));
            out.write(new Date().toString());
            out.newLine();
            out.write("System properties:");
            out.newLine();
            out.write("\tos.name = " + System.getProperty(properties[0]));
            out.newLine();
            out.write("\tos.version = " + System.getProperty(properties[1]));
            out.newLine();
            out.write("\tos.arch = " + System.getProperty(properties[2]));
            out.newLine();
            out.write("\tjava.vendor = " + System.getProperty(properties[3]));
            out.newLine();
            out.write("\tjava.version = " + System.getProperty(properties[4]));
            out.newLine();
            out.write("\tavailable processors = " + Runtime.getRuntime().availableProcessors());
            out.newLine();
            out.write("Settings:");
            out.newLine();
            out.write("\tused processors = " + nthread);
            out.newLine();
            out.write("\tTHREADS_BEGIN_N_2D = " + ConcurrencyUtils.getThreadsBeginN_2D());
            out.newLine();
            out.write("\tTHREADS_BEGIN_N_3D = " + ConcurrencyUtils.getThreadsBeginN_3D());
            out.newLine();
            out.write("\tnumber of iterations = " + niter);
            out.newLine();
            out.write("\twarm-up performed = " + doWarmup);
            out.newLine();
            out.write("\tscaling performed = " + doScaling);
            out.newLine();
            out.write("--------------------------------------------------------------------------------------------------");
            out.newLine();
            out.write("sizes=[");
            for (i = 0; i < sizes.length; ++i) {
                out.write(Integer.toString(sizes[i]));
                if (i < sizes.length - 1) {
                    out.write(", ");
                    continue;
                }
                out.write("]");
            }
            out.newLine();
            out.write("times(in msec)=[");
            for (i = 0; i < times.length; ++i) {
                out.write(String.format("%.2f", times[i]));
                if (i < times.length - 1) {
                    out.write(", ");
                    continue;
                }
                out.write("]");
            }
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

