/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tfloat.quantile;

import cern.colt.list.tfloat.FloatArrayList;
import cern.jet.math.tfloat.FloatArithmetic;
import cern.jet.random.tfloat.engine.FloatRandomEngine;
import cern.jet.random.tfloat.sampling.FloatRandomSamplingAssistant;
import cern.jet.stat.tfloat.quantile.FloatBuffer;
import cern.jet.stat.tfloat.quantile.FloatQuantileEstimator;

class KnownFloatQuantileEstimator
extends FloatQuantileEstimator {
    private static final long serialVersionUID = 1L;
    protected float beta;
    protected boolean weHadMoreThanOneEmptyBuffer;
    protected FloatRandomSamplingAssistant samplingAssistant;
    protected float samplingRate;
    protected long N;

    public KnownFloatQuantileEstimator(int b, int k, long N, float samplingRate, FloatRandomEngine generator) {
        this.samplingRate = samplingRate;
        this.N = N;
        this.samplingAssistant = (double)this.samplingRate <= 1.0 ? null : new FloatRandomSamplingAssistant(FloatArithmetic.floor((float)N / samplingRate), N, generator);
        this.setUp(b, k);
        this.clear();
    }

    protected void addInfinities(int missingInfinities, FloatBuffer buffer) {
        FloatRandomSamplingAssistant oldAssistant = this.samplingAssistant;
        this.samplingAssistant = null;
        boolean even = true;
        for (int i = 0; i < missingInfinities; ++i) {
            if (even) {
                buffer.values.add(Float.MAX_VALUE);
            } else {
                buffer.values.add(-3.4028235E38f);
            }
            even = !even;
        }
        this.samplingAssistant = oldAssistant;
    }

    @Override
    protected FloatBuffer[] buffersToCollapse() {
        int minLevel = this.bufferSet._getMinLevelOfFullOrPartialBuffers();
        return this.bufferSet._getFullOrPartialBuffersWithLevel(minLevel);
    }

    @Override
    public void clear() {
        super.clear();
        this.beta = 1.0f;
        this.weHadMoreThanOneEmptyBuffer = false;
        FloatRandomSamplingAssistant assist = this.samplingAssistant;
        if (assist != null) {
            this.samplingAssistant = new FloatRandomSamplingAssistant(FloatArithmetic.floor((float)this.N / this.samplingRate), this.N, assist.getRandomGenerator());
        }
    }

    @Override
    public Object clone() {
        KnownFloatQuantileEstimator copy = (KnownFloatQuantileEstimator)super.clone();
        if (this.samplingAssistant != null) {
            copy.samplingAssistant = (FloatRandomSamplingAssistant)copy.samplingAssistant.clone();
        }
        return copy;
    }

    @Override
    protected void newBuffer() {
        int numberOfEmptyBuffers = this.bufferSet._getNumberOfEmptyBuffers();
        if (numberOfEmptyBuffers == 0) {
            throw new RuntimeException("Oops, no empty buffer.");
        }
        this.currentBufferToFill = this.bufferSet._getFirstEmptyBuffer();
        if (numberOfEmptyBuffers == 1 && !this.weHadMoreThanOneEmptyBuffer) {
            this.currentBufferToFill.level(this.bufferSet._getMinLevelOfFullOrPartialBuffers());
        } else {
            this.weHadMoreThanOneEmptyBuffer = true;
            this.currentBufferToFill.level(0);
        }
        this.currentBufferToFill.weight(1);
    }

    @Override
    protected void postCollapse(FloatBuffer[] toCollapse) {
        this.weHadMoreThanOneEmptyBuffer = false;
    }

    @Override
    protected FloatArrayList preProcessPhis(FloatArrayList phis) {
        if ((double)this.beta > 1.0) {
            phis = phis.copy();
            int i = phis.size();
            while (--i >= 0) {
                phis.set(i, (2.0f * phis.get(i) + this.beta - 1.0f) / (2.0f * this.beta));
            }
        }
        return phis;
    }

    @Override
    public FloatArrayList quantileElements(FloatArrayList phis) {
        FloatBuffer partial = this.bufferSet._getPartialBuffer();
        int missingValues = 0;
        if (partial != null) {
            missingValues = this.bufferSet.k() - partial.size();
            if (missingValues <= 0) {
                throw new RuntimeException("Oops! illegal missing values.");
            }
            this.addInfinities(missingValues, partial);
            this.beta = (float)(this.totalElementsFilled + missingValues) / (float)this.totalElementsFilled;
        } else {
            this.beta = 1.0f;
        }
        FloatArrayList quantileElements = super.quantileElements(phis);
        if (partial != null) {
            this.removeInfinitiesFrom(missingValues, partial);
        }
        return quantileElements;
    }

    protected void removeInfinitiesFrom(int infinities, FloatBuffer buffer) {
        int plusInf = 0;
        int minusInf = 0;
        boolean even = true;
        for (int i = 0; i < infinities; ++i) {
            if (even) {
                ++plusInf;
            } else {
                ++minusInf;
            }
            even = !even;
        }
        buffer.values.removeFromTo(buffer.size() - plusInf, buffer.size() - 1);
        buffer.values.removeFromTo(0, minusInf - 1);
    }

    @Override
    protected boolean sampleNextElement() {
        if (this.samplingAssistant == null) {
            return true;
        }
        return this.samplingAssistant.sampleNextElement();
    }
}

