/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tdouble.sampling;

import cern.colt.PersistentObject;
import cern.colt.Timer;
import cern.colt.list.tboolean.BooleanArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;
import cern.jet.random.tdouble.sampling.DoubleRandomSampler;

public class DoubleRandomSamplingAssistant
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    protected DoubleRandomSampler sampler;
    protected long[] buffer;
    protected int bufferPosition;
    protected long skip;
    protected long n;
    static final int MAX_BUFFER_SIZE = 200;

    public DoubleRandomSamplingAssistant(long n, long N, DoubleRandomEngine randomGenerator) {
        this.n = n;
        this.sampler = new DoubleRandomSampler(n, N, 0L, randomGenerator);
        this.buffer = new long[(int)Math.min(n, 200L)];
        if (n > 0L) {
            this.buffer[0] = -1L;
        }
        this.fetchNextBlock();
    }

    @Override
    public Object clone() {
        DoubleRandomSamplingAssistant copy = (DoubleRandomSamplingAssistant)super.clone();
        copy.sampler = (DoubleRandomSampler)this.sampler.clone();
        return copy;
    }

    protected void fetchNextBlock() {
        if (this.n > 0L) {
            long last = this.buffer[this.bufferPosition];
            this.sampler.nextBlock((int)Math.min(this.n, 200L), this.buffer, 0);
            this.skip = this.buffer[0] - last - 1L;
            this.bufferPosition = 0;
        }
    }

    public DoubleRandomEngine getRandomGenerator() {
        return this.sampler.my_RandomGenerator;
    }

    public static void main(String[] args) {
        long n = Long.parseLong(args[0]);
        long N = Long.parseLong(args[1]);
        DoubleRandomSamplingAssistant.testArraySampling((int)n, (int)N);
    }

    public static int[] sampleArray(int n, int[] elements) {
        DoubleRandomSamplingAssistant assistant = new DoubleRandomSamplingAssistant(n, elements.length, null);
        int[] sample = new int[n];
        int j = 0;
        int length = elements.length;
        for (int i = 0; i < length; ++i) {
            if (!assistant.sampleNextElement()) continue;
            sample[j++] = elements[i];
        }
        return sample;
    }

    public boolean sampleNextElement() {
        if (this.n == 0L) {
            return false;
        }
        if (this.skip-- > 0L) {
            return false;
        }
        --this.n;
        if (this.bufferPosition < this.buffer.length - 1) {
            this.skip = this.buffer[this.bufferPosition + 1] - this.buffer[this.bufferPosition++];
            --this.skip;
        } else {
            this.fetchNextBlock();
        }
        return true;
    }

    public static void test(long n, long N) {
        DoubleRandomSamplingAssistant assistant = new DoubleRandomSamplingAssistant(n, N, null);
        LongArrayList sample = new LongArrayList((int)n);
        Timer timer = new Timer().start();
        for (long i = 0L; i < N; ++i) {
            if (!assistant.sampleNextElement()) continue;
            sample.add(i);
        }
        timer.stop().display();
        System.out.println("sample=" + sample);
        System.out.println("Good bye.\n");
    }

    public static void testArraySampling(int n, int N) {
        int[] elements = new int[N];
        for (int i = 0; i < N; ++i) {
            elements[i] = i;
        }
        Timer timer = new Timer().start();
        int[] sample = DoubleRandomSamplingAssistant.sampleArray(n, elements);
        timer.stop().display();
        System.out.println("Good bye.\n");
    }

    private void xsampleNextElements(BooleanArrayList acceptList) {
        int length = acceptList.size();
        boolean[] accept = acceptList.elements();
        for (int i = 0; i < length; ++i) {
            if (this.n == 0L) {
                accept[i] = false;
                continue;
            }
            if (this.skip-- > 0L) {
                accept[i] = false;
                continue;
            }
            --this.n;
            if (this.bufferPosition < this.buffer.length - 1) {
                this.skip = this.buffer[this.bufferPosition + 1] - this.buffer[this.bufferPosition++];
                --this.skip;
            } else {
                this.fetchNextBlock();
            }
            accept[i] = true;
        }
    }
}

