/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math.tdouble;

import cern.colt.Timer;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleDoubleProcedure;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.jet.math.tdouble.DoubleMult;
import cern.jet.math.tdouble.DoublePlusMultFirst;
import cern.jet.math.tdouble.DoublePlusMultSecond;

public class DoubleFunctions {
    public static final DoubleFunctions functions = new DoubleFunctions();
    public static final DoubleFunction abs = new DoubleFunction(){

        @Override
        public final double apply(double a) {
            return Math.abs(a);
        }
    };
    public static final DoubleFunction acos = new DoubleFunction(){

        @Override
        public final double apply(double a) {
            return Math.acos(a);
        }
    };
    public static final DoubleFunction asin = new DoubleFunction(){

        @Override
        public final double apply(double a) {
            return Math.asin(a);
        }
    };
    public static final DoubleFunction atan = new DoubleFunction(){

        @Override
        public final double apply(double a) {
            return Math.atan(a);
        }
    };
    public static final DoubleFunction ceil = new DoubleFunction(){

        @Override
        public final double apply(double a) {
            return Math.ceil(a);
        }
    };
    public static final DoubleFunction cos = new DoubleFunction(){

        @Override
        public final double apply(double a) {
            return Math.cos(a);
        }
    };
    public static final DoubleFunction exp = new DoubleFunction(){

        @Override
        public final double apply(double a) {
            return Math.exp(a);
        }
    };
    public static final DoubleFunction floor = new DoubleFunction(){

        @Override
        public final double apply(double a) {
            return Math.floor(a);
        }
    };
    public static final DoubleFunction identity = new DoubleFunction(){

        @Override
        public final double apply(double a) {
            return a;
        }
    };
    public static final DoubleFunction inv = new DoubleFunction(){

        @Override
        public final double apply(double a) {
            return 1.0 / a;
        }
    };
    public static final DoubleFunction log = new DoubleFunction(){

        @Override
        public final double apply(double a) {
            return Math.log(a);
        }
    };
    public static final DoubleFunction log2 = new DoubleFunction(){

        @Override
        public final double apply(double a) {
            return Math.log(a) * 1.4426950408889634;
        }
    };
    public static final DoubleFunction neg = new DoubleFunction(){

        @Override
        public final double apply(double a) {
            return -a;
        }
    };
    public static final DoubleFunction rint = new DoubleFunction(){

        @Override
        public final double apply(double a) {
            return Math.rint(a);
        }
    };
    public static final DoubleFunction sign = new DoubleFunction(){

        @Override
        public final double apply(double a) {
            return a < 0.0 ? -1.0 : (a > 0.0 ? 1.0 : 0.0);
        }
    };
    public static final DoubleFunction sin = new DoubleFunction(){

        @Override
        public final double apply(double a) {
            return Math.sin(a);
        }
    };
    public static final DoubleFunction sqrt = new DoubleFunction(){

        @Override
        public final double apply(double a) {
            return Math.sqrt(a);
        }
    };
    public static final DoubleFunction square = new DoubleFunction(){

        @Override
        public final double apply(double a) {
            return a * a;
        }
    };
    public static final DoubleFunction tan = new DoubleFunction(){

        @Override
        public final double apply(double a) {
            return Math.tan(a);
        }
    };
    public static final DoubleDoubleFunction atan2 = new DoubleDoubleFunction(){

        @Override
        public final double apply(double a, double b) {
            return Math.atan2(a, b);
        }
    };
    public static final DoubleDoubleFunction compare = new DoubleDoubleFunction(){

        @Override
        public final double apply(double a, double b) {
            return a < b ? -1.0 : (a > b ? 1.0 : 0.0);
        }
    };
    public static final DoubleDoubleFunction div = new DoubleDoubleFunction(){

        @Override
        public final double apply(double a, double b) {
            return a / b;
        }
    };
    public static final DoubleDoubleFunction divNeg = new DoubleDoubleFunction(){

        @Override
        public final double apply(double a, double b) {
            return -(a / b);
        }
    };
    public static final DoubleDoubleFunction equals = new DoubleDoubleFunction(){

        @Override
        public final double apply(double a, double b) {
            return a == b ? 1.0 : 0.0;
        }
    };
    public static final DoubleDoubleFunction greater = new DoubleDoubleFunction(){

        @Override
        public final double apply(double a, double b) {
            return a > b ? 1.0 : 0.0;
        }
    };
    public static final DoubleDoubleFunction IEEEremainder = new DoubleDoubleFunction(){

        @Override
        public final double apply(double a, double b) {
            return Math.IEEEremainder(a, b);
        }
    };
    public static final DoubleDoubleProcedure isEqual = new DoubleDoubleProcedure(){

        @Override
        public final boolean apply(double a, double b) {
            return a == b;
        }
    };
    public static final DoubleDoubleProcedure isLess = new DoubleDoubleProcedure(){

        @Override
        public final boolean apply(double a, double b) {
            return a < b;
        }
    };
    public static final DoubleDoubleProcedure isGreater = new DoubleDoubleProcedure(){

        @Override
        public final boolean apply(double a, double b) {
            return a > b;
        }
    };
    public static final DoubleDoubleFunction less = new DoubleDoubleFunction(){

        @Override
        public final double apply(double a, double b) {
            return a < b ? 1.0 : 0.0;
        }
    };
    public static final DoubleDoubleFunction lg = new DoubleDoubleFunction(){

        @Override
        public final double apply(double a, double b) {
            return Math.log(a) / Math.log(b);
        }
    };
    public static final DoubleDoubleFunction max = new DoubleDoubleFunction(){

        @Override
        public final double apply(double a, double b) {
            return Math.max(a, b);
        }
    };
    public static final DoubleDoubleFunction min = new DoubleDoubleFunction(){

        @Override
        public final double apply(double a, double b) {
            return Math.min(a, b);
        }
    };
    public static final DoubleDoubleFunction minus = DoubleFunctions.plusMultSecond(-1.0);
    public static final DoubleDoubleFunction mod = new DoubleDoubleFunction(){

        @Override
        public final double apply(double a, double b) {
            return a % b;
        }
    };
    public static final DoubleDoubleFunction mult = new DoubleDoubleFunction(){

        @Override
        public final double apply(double a, double b) {
            return a * b;
        }
    };
    public static final DoubleDoubleFunction multNeg = new DoubleDoubleFunction(){

        @Override
        public final double apply(double a, double b) {
            return -(a * b);
        }
    };
    public static final DoubleDoubleFunction multSquare = new DoubleDoubleFunction(){

        @Override
        public final double apply(double a, double b) {
            return a * b * b;
        }
    };
    public static final DoubleDoubleFunction plus = DoubleFunctions.plusMultSecond(1.0);
    public static final DoubleDoubleFunction plusAbs = new DoubleDoubleFunction(){

        @Override
        public final double apply(double a, double b) {
            return Math.abs(a) + Math.abs(b);
        }
    };
    public static final DoubleDoubleFunction pow = new DoubleDoubleFunction(){

        @Override
        public final double apply(double a, double b) {
            return Math.pow(a, b);
        }
    };

    protected DoubleFunctions() {
    }

    public static DoubleFunction between(final double from, final double to) {
        return new DoubleFunction(){

            @Override
            public final double apply(double a) {
                return from <= a && a <= to ? 1.0 : 0.0;
            }
        };
    }

    public static DoubleFunction bindArg1(final DoubleDoubleFunction function, final double c) {
        return new DoubleFunction(){

            @Override
            public final double apply(double var) {
                return function.apply(c, var);
            }
        };
    }

    public static DoubleFunction bindArg2(final DoubleDoubleFunction function, final double c) {
        return new DoubleFunction(){

            @Override
            public final double apply(double var) {
                return function.apply(var, c);
            }
        };
    }

    public static DoubleDoubleFunction chain(final DoubleDoubleFunction f, final DoubleFunction g, final DoubleFunction h) {
        return new DoubleDoubleFunction(){

            @Override
            public final double apply(double a, double b) {
                return f.apply(g.apply(a), h.apply(b));
            }
        };
    }

    public static DoubleDoubleFunction chain(final DoubleFunction g, final DoubleDoubleFunction h) {
        return new DoubleDoubleFunction(){

            @Override
            public final double apply(double a, double b) {
                return g.apply(h.apply(a, b));
            }
        };
    }

    public static DoubleFunction chain(final DoubleFunction g, final DoubleFunction h) {
        return new DoubleFunction(){

            @Override
            public final double apply(double a) {
                return g.apply(h.apply(a));
            }
        };
    }

    public static DoubleFunction compare(final double b) {
        return new DoubleFunction(){

            @Override
            public final double apply(double a) {
                return a < b ? -1.0 : (a > b ? 1.0 : 0.0);
            }
        };
    }

    public static DoubleFunction constant(final double c) {
        return new DoubleFunction(){

            @Override
            public final double apply(double a) {
                return c;
            }
        };
    }

    public static void demo1() {
        DoubleFunctions F = functions;
        double a = 0.5;
        double b = 0.2;
        double v = Math.sin(a) + Math.pow(Math.cos(b), 2.0);
        System.out.println(v);
        DoubleDoubleFunction f = DoubleFunctions.chain(plus, sin, DoubleFunctions.chain(square, cos));
        System.out.println(f.apply(a, b));
        DoubleDoubleFunction g = new DoubleDoubleFunction(){

            @Override
            public final double apply(double x, double y) {
                return Math.sin(x) + Math.pow(Math.cos(y), 2.0);
            }
        };
        System.out.println(g.apply(a, b));
        DoubleFunction m = DoubleFunctions.plus(3.0);
        DoubleFunction n = DoubleFunctions.plus(4.0);
        System.out.println(m.apply(0.0));
        System.out.println(n.apply(0.0));
    }

    public static void demo2(int size) {
        DoubleFunctions F = functions;
        System.out.println("\n\n");
        double a = 0.0;
        double b = 0.0;
        double v = Math.abs(Math.sin(a) + Math.pow(Math.cos(b), 2.0));
        System.out.println(v);
        DoubleDoubleFunction f = DoubleFunctions.chain(abs, DoubleFunctions.chain(plus, sin, DoubleFunctions.chain(square, cos)));
        System.out.println(f.apply(a, b));
        DoubleDoubleFunction g = new DoubleDoubleFunction(){

            @Override
            public final double apply(double x, double y) {
                return Math.abs(Math.sin(x) + Math.pow(Math.cos(y), 2.0));
            }
        };
        System.out.println(g.apply(a, b));
        Timer emptyLoop = new Timer().start();
        a = 0.0;
        b = 0.0;
        double sum = 0.0;
        int i = size;
        while (--i >= 0) {
            sum += a;
            a += 1.0;
            b += 1.0;
        }
        emptyLoop.stop().display();
        System.out.println("empty sum=" + sum);
        Timer timer = new Timer().start();
        a = 0.0;
        b = 0.0;
        sum = 0.0;
        int i2 = size;
        while (--i2 >= 0) {
            sum += Math.abs(Math.sin(a) + Math.pow(Math.cos(b), 2.0));
            a += 1.0;
            b += 1.0;
        }
        timer.stop().display();
        System.out.println("evals / sec = " + (double)size / timer.minus(emptyLoop).seconds());
        System.out.println("sum=" + sum);
        timer.reset().start();
        a = 0.0;
        b = 0.0;
        sum = 0.0;
        i2 = size;
        while (--i2 >= 0) {
            sum += f.apply(a, b);
            a += 1.0;
            b += 1.0;
        }
        timer.stop().display();
        System.out.println("evals / sec = " + (double)size / timer.minus(emptyLoop).seconds());
        System.out.println("sum=" + sum);
        timer.reset().start();
        a = 0.0;
        b = 0.0;
        sum = 0.0;
        i2 = size;
        while (--i2 >= 0) {
            sum += g.apply(a, b);
            a += 1.0;
            b += 1.0;
        }
        timer.stop().display();
        System.out.println("evals / sec = " + (double)size / timer.minus(emptyLoop).seconds());
        System.out.println("sum=" + sum);
    }

    public static DoubleFunction div(double b) {
        return DoubleFunctions.mult(1.0 / b);
    }

    public static DoubleFunction equals(final double b) {
        return new DoubleFunction(){

            @Override
            public final double apply(double a) {
                return a == b ? 1.0 : 0.0;
            }
        };
    }

    public static DoubleFunction greater(final double b) {
        return new DoubleFunction(){

            @Override
            public final double apply(double a) {
                return a > b ? 1.0 : 0.0;
            }
        };
    }

    public static DoubleFunction IEEEremainder(final double b) {
        return new DoubleFunction(){

            @Override
            public final double apply(double a) {
                return Math.IEEEremainder(a, b);
            }
        };
    }

    public static DoubleProcedure isBetween(final double from, final double to) {
        return new DoubleProcedure(){

            @Override
            public final boolean apply(double a) {
                return from <= a && a <= to;
            }
        };
    }

    public static DoubleProcedure isEqual(final double b) {
        return new DoubleProcedure(){

            @Override
            public final boolean apply(double a) {
                return a == b;
            }
        };
    }

    public static DoubleProcedure isGreater(final double b) {
        return new DoubleProcedure(){

            @Override
            public final boolean apply(double a) {
                return a > b;
            }
        };
    }

    public static DoubleProcedure isLess(final double b) {
        return new DoubleProcedure(){

            @Override
            public final boolean apply(double a) {
                return a < b;
            }
        };
    }

    public static DoubleFunction less(final double b) {
        return new DoubleFunction(){

            @Override
            public final double apply(double a) {
                return a < b ? 1.0 : 0.0;
            }
        };
    }

    public static DoubleFunction lg(final double b) {
        return new DoubleFunction(){
            private final double logInv;
            {
                this.logInv = 1.0 / Math.log(b);
            }

            @Override
            public final double apply(double a) {
                return Math.log(a) * this.logInv;
            }
        };
    }

    protected static void main(String[] args) {
        int size = Integer.parseInt(args[0]);
        DoubleFunctions.demo2(size);
    }

    public static DoubleFunction max(final double b) {
        return new DoubleFunction(){

            @Override
            public final double apply(double a) {
                return Math.max(a, b);
            }
        };
    }

    public static DoubleFunction min(final double b) {
        return new DoubleFunction(){

            @Override
            public final double apply(double a) {
                return Math.min(a, b);
            }
        };
    }

    public static DoubleFunction minus(double b) {
        return DoubleFunctions.plus(-b);
    }

    public static DoubleDoubleFunction minusMult(double constant) {
        return DoubleFunctions.plusMultSecond(-constant);
    }

    public static DoubleFunction mod(final double b) {
        return new DoubleFunction(){

            @Override
            public final double apply(double a) {
                return a % b;
            }
        };
    }

    public static DoubleFunction mult(double b) {
        return new DoubleMult(b);
    }

    public static DoubleFunction plus(final double b) {
        return new DoubleFunction(){

            @Override
            public final double apply(double a) {
                return a + b;
            }
        };
    }

    public static DoubleDoubleFunction multSecond(final double constant) {
        return new DoubleDoubleFunction(){

            @Override
            public final double apply(double a, double b) {
                return b * constant;
            }
        };
    }

    public static DoubleDoubleFunction plusMultSecond(double constant) {
        return new DoublePlusMultSecond(constant);
    }

    public static DoubleDoubleFunction plusMultFirst(double constant) {
        return new DoublePlusMultFirst(constant);
    }

    public static DoubleFunction pow(final double b) {
        return new DoubleFunction(){

            @Override
            public final double apply(double a) {
                return Math.pow(a, b);
            }
        };
    }

    public static DoubleFunction random() {
        return new RandomDoubleFunction();
    }

    public static DoubleFunction round(final double precision) {
        return new DoubleFunction(){

            @Override
            public final double apply(double a) {
                return Math.rint(a / precision) * precision;
            }
        };
    }

    public static DoubleDoubleFunction swapArgs(final DoubleDoubleFunction function) {
        return new DoubleDoubleFunction(){

            @Override
            public final double apply(double a, double b) {
                return function.apply(b, a);
            }
        };
    }

    private static class RandomDoubleFunction
    implements DoubleFunction {
        private RandomDoubleFunction() {
        }

        @Override
        public double apply(double argument) {
            return Math.random();
        }
    }
}

