/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.map.tobject.AbstractLongObjectMap;
import cern.colt.map.tobject.OpenLongObjectHashMap;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix3D;
import cern.colt.matrix.tobject.impl.SelectedSparseObjectMatrix3D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix2D;

public class SparseObjectMatrix3D
extends ObjectMatrix3D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongObjectMap elements;

    public SparseObjectMatrix3D(Object[][][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length, values.length == 0 ? 0 : (values[0].length == 0 ? 0 : values[0][0].length));
        this.assign(values);
    }

    public SparseObjectMatrix3D(int slices, int rows, int columns) {
        this(slices, rows, columns, slices * rows * (columns / 1000), 0.2, 0.5);
    }

    public SparseObjectMatrix3D(int slices, int rows, int columns, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(slices, rows, columns);
        this.elements = new OpenLongObjectHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    protected SparseObjectMatrix3D(int slices, int rows, int columns, AbstractLongObjectMap elements, int sliceZero, int rowZero, int columnZero, int sliceStride, int rowStride, int columnStride) {
        this.setUp(slices, rows, columns, sliceZero, rowZero, columnZero, sliceStride, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public AbstractLongObjectMap elements() {
        return this.elements;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    @Override
    public synchronized Object getQuick(int slice, int row, int column) {
        return this.elements.get((long)this.sliceZero + (long)slice * (long)this.sliceStride + (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride);
    }

    @Override
    protected boolean haveSharedCellsRaw(ObjectMatrix3D other) {
        if (other instanceof SelectedSparseObjectMatrix3D) {
            SelectedSparseObjectMatrix3D otherMatrix = (SelectedSparseObjectMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseObjectMatrix3D) {
            SparseObjectMatrix3D otherMatrix = (SparseObjectMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int slice, int row, int column) {
        return (long)this.sliceZero + (long)slice * (long)this.sliceStride + (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
    }

    @Override
    public ObjectMatrix3D like(int slices, int rows, int columns) {
        return new SparseObjectMatrix3D(slices, rows, columns);
    }

    @Override
    protected ObjectMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        return new SparseObjectMatrix2D(rows, columns, this.elements, rowZero, columnZero, rowStride, columnStride);
    }

    @Override
    public synchronized void setQuick(int slice, int row, int column, Object value) {
        long index = (long)this.sliceZero + (long)slice * (long)this.sliceStride + (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
        if (value == null) {
            this.elements.removeKey(index);
        } else {
            this.elements.put(index, value);
        }
    }

    @Override
    public void trimToSize() {
        this.elements.trimToSize();
    }

    @Override
    public ObjectMatrix1D vectorize() {
        SparseObjectMatrix1D v = new SparseObjectMatrix1D((int)this.size());
        int length = this.rows * this.columns;
        for (int s = 0; s < this.slices; ++s) {
            v.viewPart(s * length, length).assign(this.viewSlice(s).vectorize());
        }
        return v;
    }

    @Override
    protected ObjectMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseObjectMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, 0);
    }

    @Override
    public ObjectMatrix2D like2D(int rows, int columns) {
        return new SparseObjectMatrix2D(rows, columns);
    }
}

