/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.function.tobject.IntIntObjectFunction;
import cern.colt.function.tobject.ObjectFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.SparseRCObjectMatrix2D;
import cern.colt.matrix.tobject.impl.WrapperObjectMatrix2D;
import java.util.Arrays;

public class SparseCCObjectMatrix2D
extends WrapperObjectMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] columnPointers;
    protected int[] rowIndexes;
    protected Object[] values;
    protected boolean rowIndexesSorted;

    public SparseCCObjectMatrix2D(Object[][] values) {
        this(values.length, values[0].length);
        this.assign(values);
    }

    public SparseCCObjectMatrix2D(int rows, int columns) {
        this(rows, columns, (int)Math.min(10L * (long)rows, Integer.MAX_VALUE));
    }

    public SparseCCObjectMatrix2D(int rows, int columns, int nzmax) {
        block2: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.rowIndexes = new int[nzmax];
        this.values = new Object[nzmax];
        this.columnPointers = new int[columns + 1];
    }

    public SparseCCObjectMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, Object value, boolean sortRowIndexes) {
        int k;
        block7: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block7;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.rowIndexes = new int[nz];
        this.values = new Object[nz];
        this.columnPointers = new int[columns + 1];
        int[] w = new int[columns];
        for (k = 0; k < nz; ++k) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
        }
        this.cumsum(this.columnPointers, w, columns);
        for (k = 0; k < nz; ++k) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
            this.rowIndexes[r] = rowIndexes[k];
            this.values[r] = value;
        }
        if (sortRowIndexes) {
            this.sortRowIndexes();
        }
    }

    public SparseCCObjectMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, Object[] values, boolean removeZeroes, boolean sortRowIndexes) {
        int k;
        block7: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block7;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (rowIndexes.length != values.length) {
            throw new IllegalArgumentException("rowIndexes.length != values.length");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.rowIndexes = new int[nz];
        this.values = new Object[nz];
        this.columnPointers = new int[columns + 1];
        int[] w = new int[columns];
        for (k = 0; k < nz; ++k) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
        }
        this.cumsum(this.columnPointers, w, columns);
        for (k = 0; k < nz; ++k) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
            this.rowIndexes[r] = rowIndexes[k];
            this.values[r] = values[k];
        }
        if (sortRowIndexes) {
            this.sortRowIndexes();
        }
    }

    @Override
    public ObjectMatrix2D assign(final ObjectFunction function) {
        this.forEachNonZero(new IntIntObjectFunction(){

            @Override
            public Object apply(int i, int j, Object value) {
                return function.apply(value);
            }
        });
        return this;
    }

    @Override
    public ObjectMatrix2D assign(Object value) {
        if (value == null) {
            Arrays.fill(this.rowIndexes, 0);
            Arrays.fill(this.columnPointers, 0);
            Arrays.fill(this.values, null);
        } else {
            int nnz = this.cardinality();
            for (int i = 0; i < nnz; ++i) {
                this.values[i] = value;
            }
        }
        return this;
    }

    @Override
    public ObjectMatrix2D assign(ObjectMatrix2D source) {
        if (source == this) {
            return this;
        }
        this.checkShape(source);
        if (source instanceof SparseCCObjectMatrix2D) {
            SparseCCObjectMatrix2D other = (SparseCCObjectMatrix2D)source;
            System.arraycopy(other.getColumnPointers(), 0, this.columnPointers, 0, this.columns + 1);
            int nzmax = other.getRowIndexes().length;
            if (this.rowIndexes.length < nzmax) {
                this.rowIndexes = new int[nzmax];
                this.values = new Object[nzmax];
            }
            System.arraycopy(other.getRowIndexes(), 0, this.rowIndexes, 0, nzmax);
            System.arraycopy(other.getValues(), 0, this.values, 0, nzmax);
            this.rowIndexesSorted = other.rowIndexesSorted;
        } else if (source instanceof SparseRCObjectMatrix2D) {
            SparseRCObjectMatrix2D other = ((SparseRCObjectMatrix2D)source).getTranspose();
            this.columnPointers = other.getRowPointers();
            this.rowIndexes = other.getColumnIndexes();
            this.values = other.getValues();
            this.rowIndexesSorted = true;
        } else {
            this.assign((Object)null);
            source.forEachNonZero(new IntIntObjectFunction(){

                @Override
                public Object apply(int i, int j, Object value) {
                    SparseCCObjectMatrix2D.this.setQuick(i, j, value);
                    return value;
                }
            });
        }
        return this;
    }

    @Override
    public int cardinality() {
        return this.columnPointers[this.columns];
    }

    @Override
    public ObjectMatrix2D forEachNonZero(IntIntObjectFunction function) {
        int[] rowIndexesA = this.rowIndexes;
        int[] columnPointersA = this.columnPointers;
        Object[] valuesA = this.values;
        int j = this.columns;
        while (--j >= 0) {
            int low = columnPointersA[j];
            int k = columnPointersA[j + 1];
            while (--k >= low) {
                Object r;
                int i = rowIndexesA[k];
                Object value = valuesA[k];
                valuesA[k] = r = function.apply(i, j, value);
            }
        }
        return this;
    }

    public int[] getColumnPointers() {
        return this.columnPointers;
    }

    public DenseObjectMatrix2D getDense() {
        final DenseObjectMatrix2D dense = new DenseObjectMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntObjectFunction(){

            @Override
            public Object apply(int i, int j, Object value) {
                dense.setQuick(i, j, SparseCCObjectMatrix2D.this.getQuick(i, j));
                return value;
            }
        });
        return dense;
    }

    @Override
    public synchronized Object getQuick(int row, int column) {
        int k = SparseCCObjectMatrix2D.searchFromTo(this.rowIndexes, row, this.columnPointers[column], this.columnPointers[column + 1] - 1);
        Object v = 0;
        if (k >= 0) {
            v = this.values[k];
        }
        return v;
    }

    public SparseRCObjectMatrix2D getRowCompressed() {
        SparseCCObjectMatrix2D tr = this.getTranspose();
        SparseRCObjectMatrix2D rc = new SparseRCObjectMatrix2D(this.rows, this.columns);
        rc.columnIndexes = tr.rowIndexes;
        rc.rowPointers = tr.columnPointers;
        rc.values = tr.values;
        rc.columnIndexesSorted = true;
        return rc;
    }

    public int[] getRowIndexes() {
        return this.rowIndexes;
    }

    public SparseCCObjectMatrix2D getTranspose() {
        int p;
        int m = this.rows;
        int n = this.columns;
        int[] Ap = this.columnPointers;
        int[] Ai = this.rowIndexes;
        Object[] Ax = this.values;
        SparseCCObjectMatrix2D C = new SparseCCObjectMatrix2D(this.columns, this.rows, Ai.length);
        int[] w = new int[m];
        int[] Cp = C.columnPointers;
        int[] Ci = C.rowIndexes;
        Object[] Cx = C.values;
        for (p = 0; p < Ap[n]; ++p) {
            int n2 = Ai[p];
            w[n2] = w[n2] + 1;
        }
        this.cumsum(Cp, w, m);
        for (int j = 0; j < n; ++j) {
            for (p = Ap[j]; p < Ap[j + 1]; ++p) {
                int n3 = Ai[p];
                w[n3] = w[n3] + 1;
                Ci[q] = j;
                Cx[q] = Ax[p];
            }
        }
        return C;
    }

    public Object[] getValues() {
        return this.values;
    }

    public boolean hasRowIndexesSorted() {
        return this.rowIndexesSorted;
    }

    @Override
    public ObjectMatrix2D like(int rows, int columns) {
        return new SparseCCObjectMatrix2D(rows, columns);
    }

    @Override
    public ObjectMatrix1D like1D(int size) {
        return new SparseObjectMatrix1D(size);
    }

    @Override
    public synchronized void setQuick(int row, int column, Object value) {
        int k = SparseCCObjectMatrix2D.searchFromTo(this.rowIndexes, row, this.columnPointers[column], this.columnPointers[column + 1] - 1);
        if (k >= 0) {
            if (value == null) {
                this.remove(column, k);
            } else {
                this.values[k] = value;
            }
            return;
        }
        if (value != null) {
            k = -k - 1;
            this.insert(row, column, k, value);
        }
    }

    public void sortRowIndexes() {
        SparseCCObjectMatrix2D tr = this.getTranspose();
        tr = tr.getTranspose();
        this.columnPointers = tr.columnPointers;
        this.rowIndexes = tr.rowIndexes;
        this.values = tr.values;
        this.rowIndexesSorted = true;
    }

    public void removeZeroes() {
        int nz = 0;
        int n = this.columns;
        int[] Ap = this.columnPointers;
        int[] Ai = this.rowIndexes;
        Object[] Ax = this.values;
        for (int j = 0; j < n; ++j) {
            Ap[j] = nz;
            for (int p = Ap[j]; p < Ap[j + 1]; ++p) {
                if (Ax[p] == null) continue;
                Ax[nz] = Ax[p];
                Ai[nz++] = Ai[p];
            }
        }
        Ap[n] = nz;
    }

    @Override
    public void trimToSize() {
        this.realloc(0);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.columns; ++i) {
            int high = this.columnPointers[i + 1];
            for (int j = this.columnPointers[i]; j < high; ++j) {
                builder.append('(').append(this.rowIndexes[j]).append(',').append(i).append(')').append('\t').append(this.values[j]).append('\n');
            }
        }
        return builder.toString();
    }

    @Override
    protected ObjectMatrix2D getContent() {
        return this;
    }

    protected void insert(int row, int column, int index, Object value) {
        IntArrayList rowIndexesList = new IntArrayList(this.rowIndexes);
        rowIndexesList.setSizeRaw(this.columnPointers[this.columns]);
        ObjectArrayList valuesList = new ObjectArrayList(this.values);
        valuesList.setSizeRaw(this.columnPointers[this.columns]);
        rowIndexesList.beforeInsert(index, row);
        valuesList.beforeInsert(index, value);
        int i = this.columnPointers.length;
        while (--i > column) {
            int n = i;
            this.columnPointers[n] = this.columnPointers[n] + 1;
        }
        this.rowIndexes = rowIndexesList.elements();
        this.values = valuesList.elements();
    }

    protected void remove(int column, int index) {
        IntArrayList rowIndexesList = new IntArrayList(this.rowIndexes);
        ObjectArrayList valuesList = new ObjectArrayList(this.values);
        rowIndexesList.remove(index);
        valuesList.remove(index);
        int i = this.columnPointers.length;
        while (--i > column) {
            int n = i;
            this.columnPointers[n] = this.columnPointers[n] - 1;
        }
        this.rowIndexes = rowIndexesList.elements();
        this.values = valuesList.elements();
    }

    private static int searchFromTo(int[] list, int key, int from, int to) {
        while (from <= to) {
            if (list[from] == key) {
                return from;
            }
            ++from;
        }
        return -(from + 1);
    }

    private Object cumsum(int[] p, int[] c, int n) {
        int nz = 0;
        double nz2 = 0.0;
        for (int k = 0; k < n; ++k) {
            p[k] = nz;
            nz += c[k];
            nz2 += (double)c[k];
            c[k] = p[k];
        }
        p[n] = nz;
        return nz2;
    }

    private void realloc(int nzmax) {
        if (nzmax <= 0) {
            nzmax = this.columnPointers[this.columns];
        }
        int[] rowIndexesNew = new int[nzmax];
        int length = Math.min(nzmax, this.rowIndexes.length);
        System.arraycopy(this.rowIndexes, 0, rowIndexesNew, 0, length);
        this.rowIndexes = rowIndexesNew;
        Object[] valuesNew = new Object[nzmax];
        length = Math.min(nzmax, this.values.length);
        System.arraycopy(this.values, 0, valuesNew, 0, length);
        this.values = valuesNew;
    }
}

