/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.function.tobject.IntIntObjectFunction;
import cern.colt.function.tobject.ObjectFunction;
import cern.colt.function.tobject.ObjectObjectFunction;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix2D;
import cern.colt.matrix.tobject.impl.WrapperObjectMatrix2D;
import edu.emory.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DiagonalObjectMatrix2D
extends WrapperObjectMatrix2D {
    private static final long serialVersionUID = 1L;
    protected Object[] elements;
    protected int dlength;
    protected int dindex;

    public DiagonalObjectMatrix2D(Object[][] values, int dindex) {
        this(values.length, values.length == 0 ? 0 : values[0].length, dindex);
        this.assign(values);
    }

    public DiagonalObjectMatrix2D(int rows, int columns, int dindex) {
        int diff;
        block3: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        if (dindex < -rows + 1 || dindex > columns - 1) {
            throw new IllegalArgumentException("index is out of bounds");
        }
        this.dindex = dindex;
        this.dlength = dindex == 0 ? Math.min(rows, columns) : (dindex > 0 ? (rows >= columns ? columns - dindex : (dindex <= (diff = columns - rows) ? rows : rows - (dindex - diff))) : (rows >= columns ? (-dindex <= (diff = rows - columns) ? columns : columns + dindex + diff) : rows + dindex));
        this.elements = new Object[this.dlength];
    }

    @Override
    public ObjectMatrix2D assign(ObjectFunction function) {
        int j = this.dlength;
        while (--j >= 0) {
            this.elements[j] = function.apply(this.elements[j]);
        }
        return this;
    }

    @Override
    public ObjectMatrix2D assign(Object value) {
        int i = this.dlength;
        while (--i >= 0) {
            this.elements[i] = value;
        }
        return this;
    }

    @Override
    public ObjectMatrix2D assign(final Object[] values) {
        if (values.length != this.dlength) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + " dlength=" + this.dlength);
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.dlength);
            Future[] futures = new Future[nthreads];
            int k = this.dlength / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.dlength : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            DiagonalObjectMatrix2D.this.elements[r] = values[r];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = this.dlength;
            while (--r >= 0) {
                this.elements[r] = values[r];
            }
        }
        return this;
    }

    @Override
    public ObjectMatrix2D assign(Object[][] values) {
        int c;
        int r;
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        if (this.dindex >= 0) {
            r = 0;
            c = this.dindex;
        } else {
            r = -this.dindex;
            c = 0;
        }
        for (int i = 0; i < this.dlength; ++i) {
            if (values[i].length != this.columns) {
                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + values[r].length + "columns()=" + this.columns());
            }
            this.elements[i] = values[r++][c++];
        }
        return this;
    }

    @Override
    public ObjectMatrix2D assign(ObjectMatrix2D source) {
        if (source == this) {
            return this;
        }
        this.checkShape(source);
        if (source instanceof DiagonalObjectMatrix2D) {
            DiagonalObjectMatrix2D other = (DiagonalObjectMatrix2D)source;
            if (this.dindex != other.dindex || this.dlength != other.dlength) {
                throw new IllegalArgumentException("source is DiagonalObjectMatrix2D with different diagonal stored.");
            }
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        return super.assign(source);
    }

    @Override
    public ObjectMatrix2D assign(ObjectMatrix2D y, final ObjectObjectFunction function) {
        this.checkShape(y);
        if (y instanceof DiagonalObjectMatrix2D) {
            DiagonalObjectMatrix2D other = (DiagonalObjectMatrix2D)y;
            if (this.dindex != other.dindex || this.dlength != other.dlength) {
                throw new IllegalArgumentException("y is DiagonalObjectMatrix2D with different diagonal stored.");
            }
            final Object[] otherElements = other.elements;
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.dlength);
                Future[] futures = new Future[nthreads];
                int k = this.dlength / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int startrow = j * k;
                    final int stoprow = j == nthreads - 1 ? this.dlength : startrow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int j = startrow; j < stoprow; ++j) {
                                DiagonalObjectMatrix2D.this.elements[j] = function.apply(DiagonalObjectMatrix2D.this.elements[j], otherElements[j]);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int j = this.dlength;
                while (--j >= 0) {
                    this.elements[j] = function.apply(this.elements[j], otherElements[j]);
                }
            }
            return this;
        }
        return super.assign(y, function);
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.dlength);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.dlength / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.dlength : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        for (int r = firstRow; r < lastRow; ++r) {
                            if (DiagonalObjectMatrix2D.this.elements[r] == null) continue;
                            ++cardinality;
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int r = 0; r < this.dlength; ++r) {
                if (this.elements[r] == null) continue;
                ++cardinality;
            }
        }
        return cardinality;
    }

    public Object[] elements() {
        return this.elements;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DiagonalObjectMatrix2D) {
            DiagonalObjectMatrix2D other = (DiagonalObjectMatrix2D)obj;
            if (this == obj) {
                return true;
            }
            if (this == null || obj == null) {
                return false;
            }
            int rows = this.rows();
            int columns = this.columns();
            if (columns != other.columns() || rows != other.rows()) {
                return false;
            }
            if (this.dindex != other.dindex || this.dlength != other.dlength) {
                return false;
            }
            Object[] otherElements = other.elements;
            for (int r = 0; r < this.dlength; ++r) {
                Object x = this.elements[r];
                Object value = otherElements[r];
                if (x.equals(value)) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }

    @Override
    public ObjectMatrix2D forEachNonZero(IntIntObjectFunction function) {
        int j = this.dlength;
        while (--j >= 0) {
            Object value = this.elements[j];
            if (value == null) continue;
            this.elements[j] = function.apply(j, j, value);
        }
        return this;
    }

    public int diagonalLength() {
        return this.dlength;
    }

    public int diagonalIndex() {
        return this.dindex;
    }

    @Override
    public Object getQuick(int row, int column) {
        if (this.dindex >= 0) {
            if (column < this.dindex) {
                return 0;
            }
            if (row < this.dlength && row + this.dindex == column) {
                return this.elements[row];
            }
            return 0;
        }
        if (row < -this.dindex) {
            return 0;
        }
        if (column < this.dlength && row + this.dindex == column) {
            return this.elements[column];
        }
        return 0;
    }

    @Override
    public ObjectMatrix2D like(int rows, int columns) {
        return new SparseObjectMatrix2D(rows, columns);
    }

    @Override
    public ObjectMatrix1D like1D(int size) {
        return new SparseObjectMatrix1D(size);
    }

    @Override
    public void setQuick(int row, int column, Object value) {
        if (this.dindex >= 0) {
            if (column >= this.dindex && row < this.dlength && row + this.dindex == column) {
                this.elements[row] = value;
            }
        } else if (row >= -this.dindex && column < this.dlength && row + this.dindex == column) {
            this.elements[column] = value;
        }
    }

    @Override
    protected ObjectMatrix2D getContent() {
        return this;
    }
}

