/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong;

import cern.colt.PersistentObject;
import cern.colt.list.tlong.AbstractLongList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix1D;
import cern.jet.math.tlong.LongFunctions;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.sampling.DoubleRandomSamplingAssistant;

public class LongFactory1D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final LongFactory1D dense = new LongFactory1D();
    public static final LongFactory1D sparse = new LongFactory1D();

    protected LongFactory1D() {
    }

    public LongMatrix1D append(LongMatrix1D A, LongMatrix1D B) {
        LongMatrix1D matrix = this.make((int)(A.size() + B.size()));
        matrix.viewPart(0, (int)A.size()).assign(A);
        matrix.viewPart((int)A.size(), (int)B.size()).assign(B);
        return matrix;
    }

    public LongMatrix1D ascending(int size) {
        LongFunctions F = LongFunctions.longFunctions;
        return this.descending(size).assign(LongFunctions.chain(LongFunctions.neg, LongFunctions.minus(size)));
    }

    public LongMatrix1D descending(int size) {
        LongMatrix1D matrix = this.make(size);
        int v = 0;
        int i = size;
        while (--i >= 0) {
            matrix.setQuick(i, v++);
        }
        return matrix;
    }

    public LongMatrix1D make(long[] values) {
        if (this == sparse) {
            return new SparseLongMatrix1D(values);
        }
        return new DenseLongMatrix1D(values);
    }

    public LongMatrix1D make(LongMatrix1D[] parts) {
        if (parts.length == 0) {
            return this.make(0);
        }
        int size = 0;
        for (int i = 0; i < parts.length; ++i) {
            size = (int)((long)size + parts[i].size());
        }
        LongMatrix1D vector = this.make(size);
        size = 0;
        for (int i = 0; i < parts.length; ++i) {
            vector.viewPart(size, (int)parts[i].size()).assign(parts[i]);
            size = (int)((long)size + parts[i].size());
        }
        return vector;
    }

    public LongMatrix1D make(int size) {
        if (this == sparse) {
            return new SparseLongMatrix1D(size);
        }
        return new DenseLongMatrix1D(size);
    }

    public LongMatrix1D make(int size, long initialValue) {
        return this.make(size).assign(initialValue);
    }

    public LongMatrix1D make(AbstractLongList values) {
        int size = values.size();
        LongMatrix1D vector = this.make(size);
        int i = size;
        while (--i >= 0) {
            vector.set(i, values.get(i));
        }
        return vector;
    }

    public LongMatrix1D random(int size) {
        return this.make(size).assign(LongFunctions.random());
    }

    public LongMatrix1D repeat(LongMatrix1D A, int repeat) {
        int size = (int)A.size();
        LongMatrix1D matrix = this.make(repeat * size);
        int i = repeat;
        while (--i >= 0) {
            matrix.viewPart(size * i, size).assign(A);
        }
        return matrix;
    }

    public LongMatrix1D sample(int size, int value, int nonZeroFraction) {
        double epsilon = 1.0E-9;
        if ((double)nonZeroFraction < 0.0 - epsilon || (double)nonZeroFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (nonZeroFraction < 0) {
            nonZeroFraction = 0;
        }
        if (nonZeroFraction > 1) {
            nonZeroFraction = 1;
        }
        LongMatrix1D matrix = this.make(size);
        int n = Math.round(size * nonZeroFraction);
        if (n == 0) {
            return matrix;
        }
        DoubleRandomSamplingAssistant sampler = new DoubleRandomSamplingAssistant(n, size, new DoubleMersenneTwister());
        int i = size;
        while (--i >= 0) {
            if (!sampler.sampleNextElement()) continue;
            matrix.set(i, value);
        }
        return matrix;
    }

    public LongArrayList toList(LongMatrix1D values) {
        int size = (int)values.size();
        LongArrayList list = new LongArrayList(size);
        list.setSize(size);
        int i = size;
        while (--i >= 0) {
            list.set(i, values.get(i));
        }
        return list;
    }
}

