/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntIntIntFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseCCIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseIntMatrix1D;
import cern.colt.matrix.tint.impl.WrapperIntMatrix2D;
import cern.jet.math.tint.IntFunctions;
import cern.jet.math.tint.IntMult;
import cern.jet.math.tint.IntPlusMultFirst;
import cern.jet.math.tint.IntPlusMultSecond;
import edu.emory.utils.ConcurrencyUtils;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseRCIntMatrix2D
extends WrapperIntMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] rowPointers;
    protected int[] columnIndexes;
    protected int[] values;
    protected boolean columnIndexesSorted;

    private static int searchFromTo(int[] list, int key, int from, int to) {
        while (from <= to) {
            if (list[from] == key) {
                return from;
            }
            ++from;
        }
        return -(from + 1);
    }

    public SparseRCIntMatrix2D(int[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public SparseRCIntMatrix2D(int rows, int columns) {
        this(rows, columns, (int)Math.min(10L * (long)rows, Integer.MAX_VALUE));
    }

    public SparseRCIntMatrix2D(int rows, int columns, int nzmax) {
        block2: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.columnIndexes = new int[nzmax];
        this.values = new int[nzmax];
        this.rowPointers = new int[rows + 1];
    }

    public SparseRCIntMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, int value, boolean removeDuplicates, boolean sortColumnIndexes) {
        int k;
        block8: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block8;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (value == 0) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.columnIndexes = new int[nz];
        this.values = new int[nz];
        this.rowPointers = new int[rows + 1];
        int[] w = new int[rows];
        for (k = 0; k < nz; ++k) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
        }
        this.cumsum(this.rowPointers, w, rows);
        for (k = 0; k < nz; ++k) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
            this.columnIndexes[r] = columnIndexes[k];
            this.values[r] = value;
        }
        if (removeDuplicates) {
            this.removeDuplicates();
        }
        if (sortColumnIndexes) {
            this.sortColumnIndexes();
        }
    }

    public SparseRCIntMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, int[] values, boolean removeDuplicates, boolean removeZeroes, boolean sortColumnIndexes) {
        int k;
        block9: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block9;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (rowIndexes.length != values.length) {
            throw new IllegalArgumentException("rowIndexes.length != values.length");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.columnIndexes = new int[nz];
        this.values = new int[nz];
        this.rowPointers = new int[rows + 1];
        int[] w = new int[rows];
        for (k = 0; k < nz; ++k) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
        }
        this.cumsum(this.rowPointers, w, rows);
        for (k = 0; k < nz; ++k) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
            this.columnIndexes[r] = columnIndexes[k];
            this.values[r] = values[k];
        }
        if (removeZeroes) {
            this.removeZeroes();
        }
        if (removeDuplicates) {
            this.removeDuplicates();
        }
        if (sortColumnIndexes) {
            this.sortColumnIndexes();
        }
    }

    public SparseRCIntMatrix2D(int rows, int columns, int[] rowPointers, int[] columnIndexes, int[] values) {
        block3: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        if (rowPointers.length != rows + 1) {
            throw new IllegalArgumentException("rowPointers.length != rows + 1");
        }
        this.rowPointers = rowPointers;
        this.columnIndexes = columnIndexes;
        this.values = values;
    }

    @Override
    public IntMatrix2D assign(final IntFunction function) {
        if (function instanceof IntMult) {
            int alpha = ((IntMult)function).multiplicator;
            if (alpha == 1) {
                return this;
            }
            if (alpha == 0) {
                return this.assign(0);
            }
            if (alpha != alpha) {
                return this.assign(alpha);
            }
            int nz = this.cardinality();
            int j = 0;
            while (j < nz) {
                int n = j++;
                this.values[n] = this.values[n] * alpha;
            }
        } else {
            this.forEachNonZero(new IntIntIntFunction(){

                @Override
                public int apply(int i, int j, int value) {
                    return function.apply(value);
                }
            });
        }
        return this;
    }

    @Override
    public IntMatrix2D assign(int value) {
        if (value == 0) {
            Arrays.fill(this.rowPointers, 0);
            Arrays.fill(this.columnIndexes, 0);
            Arrays.fill(this.values, 0);
        } else {
            int nnz = this.cardinality();
            for (int i = 0; i < nnz; ++i) {
                this.values[i] = value;
            }
        }
        return this;
    }

    @Override
    public IntMatrix2D assign(IntMatrix2D source) {
        if (source == this) {
            return this;
        }
        this.checkShape(source);
        if (source instanceof SparseRCIntMatrix2D) {
            SparseRCIntMatrix2D other = (SparseRCIntMatrix2D)source;
            System.arraycopy(other.rowPointers, 0, this.rowPointers, 0, this.rows + 1);
            int nzmax = other.columnIndexes.length;
            if (this.columnIndexes.length < nzmax) {
                this.columnIndexes = new int[nzmax];
                this.values = new int[nzmax];
            }
            System.arraycopy(other.columnIndexes, 0, this.columnIndexes, 0, nzmax);
            System.arraycopy(other.values, 0, this.values, 0, nzmax);
            this.columnIndexesSorted = other.columnIndexesSorted;
        } else if (source instanceof SparseCCIntMatrix2D) {
            SparseCCIntMatrix2D other = ((SparseCCIntMatrix2D)source).getTranspose();
            this.rowPointers = other.getColumnPointers();
            this.columnIndexes = other.getRowIndexes();
            this.values = other.getValues();
            this.columnIndexesSorted = true;
        } else {
            this.assign(0);
            source.forEachNonZero(new IntIntIntFunction(){

                @Override
                public int apply(int i, int j, int value) {
                    SparseRCIntMatrix2D.this.setQuick(i, j, value);
                    return value;
                }
            });
        }
        return this;
    }

    @Override
    public IntMatrix2D assign(IntMatrix2D y, IntIntFunction function) {
        this.checkShape(y);
        if (y instanceof SparseRCIntMatrix2D && function == IntFunctions.plus) {
            SparseRCIntMatrix2D yy = (SparseRCIntMatrix2D)y;
            int[] rowPointersY = yy.rowPointers;
            int[] columnIndexesY = yy.columnIndexes;
            int[] valuesY = yy.values;
            int[] rowPointersC = new int[this.rows + 1];
            int cnz = Math.max(this.columnIndexes.length, Math.min(Integer.MAX_VALUE, this.rowPointers[this.rows] + rowPointersY[this.rows]));
            int[] columnIndexesC = new int[cnz];
            int[] valuesC = new int[cnz];
            int nrow = this.rows;
            int ncol = this.columns;
            int nzmax = valuesC.length;
            if (function == IntFunctions.plus) {
                int kc;
                rowPointersC[0] = kc = 0;
                for (int i = 0; i < nrow; ++i) {
                    int ka = this.rowPointers[i];
                    int kb = rowPointersY[i];
                    int kamax = this.rowPointers[i + 1] - 1;
                    int kbmax = rowPointersY[i + 1] - 1;
                    while (ka <= kamax || kb <= kbmax) {
                        int j2;
                        int j1 = ka <= kamax ? this.columnIndexes[ka] : ncol + 1;
                        if (j1 == (j2 = kb <= kbmax ? columnIndexesY[kb] : ncol + 1)) {
                            valuesC[kc] = this.values[ka] + valuesY[kb];
                            columnIndexesC[kc] = j1;
                            ++ka;
                            ++kb;
                            ++kc;
                        } else if (j1 < j2) {
                            columnIndexesC[kc] = j1;
                            valuesC[kc] = this.values[ka];
                            ++ka;
                            ++kc;
                        } else if (j1 > j2) {
                            columnIndexesC[kc] = j2;
                            valuesC[kc] = valuesY[kb];
                            ++kb;
                            ++kc;
                        }
                        if (kc < nzmax) continue;
                        throw new IllegalArgumentException("The number of elements in C exceeds nzmax");
                    }
                    rowPointersC[i + 1] = kc;
                }
                this.rowPointers = rowPointersC;
                this.columnIndexes = columnIndexesC;
                this.values = valuesC;
                return this;
            }
        }
        if (function instanceof IntPlusMultSecond) {
            final int alpha = ((IntPlusMultSecond)function).multiplicator;
            if (alpha == 0) {
                return this;
            }
            y.forEachNonZero(new IntIntIntFunction(){

                @Override
                public int apply(int i, int j, int value) {
                    SparseRCIntMatrix2D.this.setQuick(i, j, SparseRCIntMatrix2D.this.getQuick(i, j) + alpha * value);
                    return value;
                }
            });
            return this;
        }
        if (function instanceof IntPlusMultFirst) {
            final int alpha = ((IntPlusMultFirst)function).multiplicator;
            if (alpha == 0) {
                return this.assign(y);
            }
            y.forEachNonZero(new IntIntIntFunction(){

                @Override
                public int apply(int i, int j, int value) {
                    SparseRCIntMatrix2D.this.setQuick(i, j, alpha * SparseRCIntMatrix2D.this.getQuick(i, j) + value);
                    return value;
                }
            });
            return this;
        }
        if (function == IntFunctions.mult) {
            int i = this.rows;
            while (--i >= 0) {
                int low = this.rowPointers[i];
                int k = this.rowPointers[i + 1];
                while (--k >= low) {
                    int j = this.columnIndexes[k];
                    int n = k;
                    this.values[n] = this.values[n] * y.getQuick(i, j);
                    if (this.values[k] != 0) continue;
                    this.remove(i, j);
                }
            }
            return this;
        }
        if (function == IntFunctions.div) {
            int i = this.rows;
            while (--i >= 0) {
                int low = this.rowPointers[i];
                int k = this.rowPointers[i + 1];
                while (--k >= low) {
                    int j = this.columnIndexes[k];
                    int n = k;
                    this.values[n] = this.values[n] / y.getQuick(i, j);
                    if (this.values[k] != 0) continue;
                    this.remove(i, j);
                }
            }
            return this;
        }
        return super.assign(y, function);
    }

    @Override
    public int cardinality() {
        return this.rowPointers[this.rows];
    }

    @Override
    public IntMatrix2D forEachNonZero(IntIntIntFunction function) {
        int i = this.rows;
        while (--i >= 0) {
            int low = this.rowPointers[i];
            int k = this.rowPointers[i + 1];
            while (--k >= low) {
                int j = this.columnIndexes[k];
                int value = this.values[k];
                int r = function.apply(i, j, value);
                if (r == value) continue;
                this.values[k] = r;
            }
        }
        return this;
    }

    public SparseCCIntMatrix2D getColumnCompressed() {
        SparseRCIntMatrix2D tr = this.getTranspose();
        SparseCCIntMatrix2D cc = new SparseCCIntMatrix2D(this.rows, this.columns);
        cc.rowIndexes = tr.columnIndexes;
        cc.columnPointers = tr.rowPointers;
        cc.values = tr.values;
        cc.rowIndexesSorted = true;
        return cc;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public DenseIntMatrix2D getDense() {
        final DenseIntMatrix2D dense = new DenseIntMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntIntFunction(){

            @Override
            public int apply(int i, int j, int value) {
                dense.setQuick(i, j, SparseRCIntMatrix2D.this.getQuick(i, j));
                return value;
            }
        });
        return dense;
    }

    @Override
    public synchronized int getQuick(int row, int column) {
        int k = SparseRCIntMatrix2D.searchFromTo(this.columnIndexes, column, this.rowPointers[row], this.rowPointers[row + 1] - 1);
        int v = 0;
        if (k >= 0) {
            v = this.values[k];
        }
        return v;
    }

    public int[] getRowPointers() {
        return this.rowPointers;
    }

    public SparseRCIntMatrix2D getTranspose() {
        int nnz = this.rowPointers[this.rows];
        int[] w = new int[this.columns];
        int[] rowPointersT = new int[this.columns + 1];
        int[] columnIndexesT = new int[nnz];
        int[] valuesT = new int[nnz];
        for (int p = 0; p < nnz; ++p) {
            int n = this.columnIndexes[p];
            w[n] = w[n] + 1;
        }
        this.cumsum(rowPointersT, w, this.columns);
        for (int j = 0; j < this.rows; ++j) {
            int high = this.rowPointers[j + 1];
            for (int p = this.rowPointers[j]; p < high; ++p) {
                int n = this.columnIndexes[p];
                w[n] = w[n] + 1;
                columnIndexesT[q] = j;
                valuesT[q] = this.values[p];
            }
        }
        SparseRCIntMatrix2D T = new SparseRCIntMatrix2D(this.columns, this.rows);
        T.rowPointers = rowPointersT;
        T.columnIndexes = columnIndexesT;
        T.values = valuesT;
        return T;
    }

    public int[] getValues() {
        return this.values;
    }

    public boolean hasColumnIndexesSorted() {
        return this.columnIndexesSorted;
    }

    @Override
    public IntMatrix2D like(int rows, int columns) {
        return new SparseRCIntMatrix2D(rows, columns);
    }

    @Override
    public IntMatrix1D like1D(int size) {
        return new SparseIntMatrix1D(size);
    }

    public void removeDuplicates() {
        int i;
        int nz = 0;
        int[] w = new int[this.columns];
        for (i = 0; i < this.columns; ++i) {
            w[i] = -1;
        }
        for (int j = 0; j < this.rows; ++j) {
            int q = nz;
            for (int p = this.rowPointers[j]; p < this.rowPointers[j + 1]; ++p) {
                i = this.columnIndexes[p];
                if (w[i] >= q) {
                    int n = w[i];
                    this.values[n] = this.values[n] + this.values[p];
                    continue;
                }
                w[i] = nz;
                this.columnIndexes[nz] = i;
                this.values[nz++] = this.values[p];
            }
            this.rowPointers[j] = q;
        }
        this.rowPointers[this.rows] = nz;
    }

    public void removeZeroes() {
        int nz = 0;
        for (int j = 0; j < this.rows; ++j) {
            this.rowPointers[j] = nz;
            for (int p = this.rowPointers[j]; p < this.rowPointers[j + 1]; ++p) {
                if (this.values[p] == 0) continue;
                this.values[nz] = this.values[p];
                this.columnIndexes[nz++] = this.columnIndexes[p];
            }
        }
        this.rowPointers[this.rows] = nz;
    }

    @Override
    public synchronized void setQuick(int row, int column, int value) {
        int k = SparseRCIntMatrix2D.searchFromTo(this.columnIndexes, column, this.rowPointers[row], this.rowPointers[row + 1] - 1);
        if (k >= 0) {
            if (value == 0) {
                this.remove(row, k);
            } else {
                this.values[k] = value;
            }
            return;
        }
        if (value != 0) {
            k = -k - 1;
            this.insert(row, column, k, value);
        }
    }

    public void sortColumnIndexes() {
        SparseRCIntMatrix2D T = this.getTranspose();
        this.rows = T.rows;
        this.columns = T.columns;
        this.columnIndexes = T.columnIndexes;
        this.rowPointers = T.rowPointers;
        this.values = T.values;
        T = this.getTranspose();
        this.rows = T.rows;
        this.columns = T.columns;
        this.columnIndexes = T.columnIndexes;
        this.rowPointers = T.rowPointers;
        this.values = T.values;
        this.columnIndexesSorted = true;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.rows; ++i) {
            int high = this.rowPointers[i + 1];
            for (int j = this.rowPointers[i]; j < high; ++j) {
                builder.append('(').append(i).append(',').append(this.columnIndexes[j]).append(')').append('\t').append(this.values[j]).append('\n');
            }
        }
        return builder.toString();
    }

    @Override
    public void trimToSize() {
        this.realloc(0);
    }

    @Override
    public IntMatrix1D zMult(IntMatrix1D y, IntMatrix1D z, final int alpha, final int beta, boolean transposeA) {
        boolean ignore;
        int rowsA = transposeA ? this.columns : this.rows;
        int columnsA = transposeA ? this.rows : this.columns;
        boolean bl = ignore = z == null || !transposeA;
        if (z == null) {
            z = new DenseIntMatrix1D(rowsA);
        }
        if (!(y instanceof DenseIntMatrix1D) || !(z instanceof DenseIntMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)columnsA != y.size() || (long)rowsA > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (transposeA ? this.viewDice() : this).toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        DenseIntMatrix1D zz = (DenseIntMatrix1D)z;
        final int[] elementsZ = zz.elements;
        final int strideZ = zz.stride();
        final int zeroZ = (int)z.index(0);
        DenseIntMatrix1D yy = (DenseIntMatrix1D)y;
        final int[] elementsY = yy.elements;
        final int strideY = yy.stride();
        final int zeroY = (int)y.index(0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (transposeA) {
            if (!ignore && (double)beta != 1.0) {
                z.assign(IntFunctions.mult(beta));
            }
            if (nthreads > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int rem;
                int j;
                nthreads = 2;
                Future[] futures = new Future[nthreads];
                final int[] result = new int[rowsA];
                int k = this.rows / nthreads;
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final int firstRow = j2 * k;
                    final int lastRow = j2 == nthreads - 1 ? this.rows : firstRow + k;
                    final int threadID = j2;
                    futures[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            if (threadID == 0) {
                                for (int i = firstRow; i < lastRow; ++i) {
                                    int high = SparseRCIntMatrix2D.this.rowPointers[i + 1];
                                    int yElem = alpha * elementsY[zeroY + strideY * i];
                                    for (int k = SparseRCIntMatrix2D.this.rowPointers[i]; k < high; ++k) {
                                        int j = SparseRCIntMatrix2D.this.columnIndexes[k];
                                        int n = zeroZ + strideZ * j;
                                        elementsZ[n] = elementsZ[n] + SparseRCIntMatrix2D.this.values[k] * yElem;
                                    }
                                }
                            } else {
                                for (int i = firstRow; i < lastRow; ++i) {
                                    int high = SparseRCIntMatrix2D.this.rowPointers[i + 1];
                                    int yElem = alpha * elementsY[zeroY + strideY * i];
                                    for (int k = SparseRCIntMatrix2D.this.rowPointers[i]; k < high; ++k) {
                                        int j;
                                        int n = j = SparseRCIntMatrix2D.this.columnIndexes[k];
                                        result[n] = result[n] + SparseRCIntMatrix2D.this.values[k] * yElem;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                for (j = rem = rowsA % 10; j < rowsA; j += 10) {
                    int n = zeroZ + j * strideZ;
                    elementsZ[n] = elementsZ[n] + result[j];
                    int n2 = zeroZ + (j + 1) * strideZ;
                    elementsZ[n2] = elementsZ[n2] + result[j + 1];
                    int n3 = zeroZ + (j + 2) * strideZ;
                    elementsZ[n3] = elementsZ[n3] + result[j + 2];
                    int n4 = zeroZ + (j + 3) * strideZ;
                    elementsZ[n4] = elementsZ[n4] + result[j + 3];
                    int n5 = zeroZ + (j + 4) * strideZ;
                    elementsZ[n5] = elementsZ[n5] + result[j + 4];
                    int n6 = zeroZ + (j + 5) * strideZ;
                    elementsZ[n6] = elementsZ[n6] + result[j + 5];
                    int n7 = zeroZ + (j + 6) * strideZ;
                    elementsZ[n7] = elementsZ[n7] + result[j + 6];
                    int n8 = zeroZ + (j + 7) * strideZ;
                    elementsZ[n8] = elementsZ[n8] + result[j + 7];
                    int n9 = zeroZ + (j + 8) * strideZ;
                    elementsZ[n9] = elementsZ[n9] + result[j + 8];
                    int n10 = zeroZ + (j + 9) * strideZ;
                    elementsZ[n10] = elementsZ[n10] + result[j + 9];
                }
                for (j = 0; j < rem; ++j) {
                    int n = zeroZ + j * strideZ;
                    elementsZ[n] = elementsZ[n] + result[j];
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    int high = this.rowPointers[i + 1];
                    int yElem = alpha * elementsY[zeroY + strideY * i];
                    for (int k = this.rowPointers[i]; k < high; ++k) {
                        int j = this.columnIndexes[k];
                        int n = zeroZ + strideZ * j;
                        elementsZ[n] = elementsZ[n] + this.values[k] * yElem;
                    }
                }
            }
            return z;
        }
        if (nthreads > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int zidx = zeroZ + firstRow * strideZ;
                        int k = SparseRCIntMatrix2D.this.rowPointers[firstRow];
                        if ((double)beta == 0.0) {
                            for (int i = firstRow; i < lastRow; ++i) {
                                int sum = 0;
                                int high = SparseRCIntMatrix2D.this.rowPointers[i + 1];
                                while (k + 10 < high) {
                                    int ind = k + 9;
                                    sum += SparseRCIntMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCIntMatrix2D.this.columnIndexes[ind--]] + SparseRCIntMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCIntMatrix2D.this.columnIndexes[ind--]] + SparseRCIntMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCIntMatrix2D.this.columnIndexes[ind--]] + SparseRCIntMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCIntMatrix2D.this.columnIndexes[ind--]] + SparseRCIntMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCIntMatrix2D.this.columnIndexes[ind--]] + SparseRCIntMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCIntMatrix2D.this.columnIndexes[ind--]] + SparseRCIntMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCIntMatrix2D.this.columnIndexes[ind--]] + SparseRCIntMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCIntMatrix2D.this.columnIndexes[ind--]] + SparseRCIntMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCIntMatrix2D.this.columnIndexes[ind--]] + SparseRCIntMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCIntMatrix2D.this.columnIndexes[ind--]];
                                    k += 10;
                                }
                                while (k < high) {
                                    sum += SparseRCIntMatrix2D.this.values[k] * elementsY[SparseRCIntMatrix2D.this.columnIndexes[k]];
                                    ++k;
                                }
                                elementsZ[zidx] = alpha * sum;
                                zidx += strideZ;
                            }
                        } else {
                            for (int i = firstRow; i < lastRow; ++i) {
                                int sum = 0;
                                int high = SparseRCIntMatrix2D.this.rowPointers[i + 1];
                                while (k + 10 < high) {
                                    int ind = k + 9;
                                    sum += SparseRCIntMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCIntMatrix2D.this.columnIndexes[ind--]] + SparseRCIntMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCIntMatrix2D.this.columnIndexes[ind--]] + SparseRCIntMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCIntMatrix2D.this.columnIndexes[ind--]] + SparseRCIntMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCIntMatrix2D.this.columnIndexes[ind--]] + SparseRCIntMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCIntMatrix2D.this.columnIndexes[ind--]] + SparseRCIntMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCIntMatrix2D.this.columnIndexes[ind--]] + SparseRCIntMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCIntMatrix2D.this.columnIndexes[ind--]] + SparseRCIntMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCIntMatrix2D.this.columnIndexes[ind--]] + SparseRCIntMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCIntMatrix2D.this.columnIndexes[ind--]] + SparseRCIntMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCIntMatrix2D.this.columnIndexes[ind--]];
                                    k += 10;
                                }
                                while (k < high) {
                                    sum += SparseRCIntMatrix2D.this.values[k] * elementsY[SparseRCIntMatrix2D.this.columnIndexes[k]];
                                    ++k;
                                }
                                elementsZ[zidx] = alpha * sum + beta * elementsZ[zidx];
                                zidx += strideZ;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int zidx = zeroZ;
            int k = this.rowPointers[0];
            if ((double)beta == 0.0) {
                for (int i = 0; i < this.rows; ++i) {
                    int sum = 0;
                    int high = this.rowPointers[i + 1];
                    while (k + 10 < high) {
                        int ind = k + 9;
                        sum += this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]];
                        k += 10;
                    }
                    while (k < high) {
                        sum += this.values[k] * elementsY[this.columnIndexes[k]];
                        ++k;
                    }
                    elementsZ[zidx] = alpha * sum;
                    zidx += strideZ;
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    int sum = 0;
                    int high = this.rowPointers[i + 1];
                    while (k + 10 < high) {
                        int ind = k + 9;
                        sum += this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]];
                        k += 10;
                    }
                    while (k < high) {
                        sum += this.values[k] * elementsY[this.columnIndexes[k]];
                        ++k;
                    }
                    elementsZ[zidx] = alpha * sum + beta * elementsZ[zidx];
                    zidx += strideZ;
                }
            }
        }
        return z;
    }

    @Override
    public IntMatrix2D zMult(IntMatrix2D B, IntMatrix2D C, int alpha, int beta, boolean transposeA, boolean transposeB) {
        boolean ignore;
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        int rowsB = B.rows();
        int columnsB = B.columns();
        if (transposeB) {
            rowsB = B.columns();
            columnsB = B.rows();
        }
        int p = columnsB;
        boolean bl = ignore = C == null;
        if (C == null) {
            C = B instanceof SparseRCIntMatrix2D ? new SparseRCIntMatrix2D(rowsA, p, rowsA * p) : new DenseIntMatrix2D(rowsA, p);
        }
        if (rowsB != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != p) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!ignore && (double)beta != 1.0) {
            C.assign(IntFunctions.mult(beta));
        }
        if (B instanceof DenseIntMatrix2D && C instanceof DenseIntMatrix2D) {
            SparseRCIntMatrix2D AA = transposeA ? this.getTranspose() : this;
            DenseIntMatrix2D BB = transposeB ? (DenseIntMatrix2D)B.viewDice() : (DenseIntMatrix2D)B;
            DenseIntMatrix2D CC = (DenseIntMatrix2D)C;
            int[] rowPointersA = AA.rowPointers;
            int[] columnIndexesA = AA.columnIndexes;
            int[] valuesA = AA.values;
            for (int ii = 0; ii < rowsA; ++ii) {
                int highA = rowPointersA[ii + 1];
                for (int ka = rowPointersA[ii]; ka < highA; ++ka) {
                    int scal = valuesA[ka] * alpha;
                    int jj = columnIndexesA[ka];
                    CC.viewRow(ii).assign(BB.viewRow(jj), IntFunctions.plusMultSecond(scal));
                }
            }
        } else if (B instanceof SparseRCIntMatrix2D && C instanceof SparseRCIntMatrix2D) {
            SparseRCIntMatrix2D CC = (SparseRCIntMatrix2D)C;
            SparseRCIntMatrix2D AA = transposeA ? this.getTranspose() : this;
            SparseRCIntMatrix2D BB = transposeB ? ((SparseRCIntMatrix2D)B).getTranspose() : (SparseRCIntMatrix2D)B;
            int[] rowPointersA = AA.rowPointers;
            int[] columnIndexesA = AA.columnIndexes;
            int[] valuesA = AA.values;
            int[] rowPointersB = BB.rowPointers;
            int[] columnIndexesB = BB.columnIndexes;
            int[] valuesB = BB.values;
            int[] rowPointersC = CC.rowPointers;
            int[] columnIndexesC = CC.columnIndexes;
            int[] valuesC = CC.values;
            int nzmax = valuesC.length;
            int[] iw = new int[columnsB + 1];
            for (int i = 0; i < iw.length; ++i) {
                iw[i] = -1;
            }
            int len = -1;
            for (int ii = 0; ii < rowsA; ++ii) {
                int highA = rowPointersA[ii + 1];
                for (int ka = rowPointersA[ii]; ka < highA; ++ka) {
                    int scal = valuesA[ka] * alpha;
                    int jj = columnIndexesA[ka];
                    int highB = rowPointersB[jj + 1];
                    for (int kb = rowPointersB[jj]; kb < highB; ++kb) {
                        int jcol = columnIndexesB[kb];
                        int jpos = iw[jcol];
                        if (jpos == -1) {
                            if (++len >= nzmax) {
                                throw new IllegalArgumentException("The max number of nonzero elements in C is too small.");
                            }
                            columnIndexesC[len] = jcol;
                            iw[jcol] = len;
                            valuesC[len] = scal * valuesB[kb];
                            continue;
                        }
                        int n = jpos;
                        valuesC[n] = valuesC[n] + scal * valuesB[kb];
                    }
                }
                for (int k = rowPointersC[ii]; k < len + 1; ++k) {
                    iw[columnIndexesC[k]] = -1;
                }
                rowPointersC[ii + 1] = len + 1;
            }
        } else {
            if (transposeB) {
                B = B.viewDice();
            }
            IntMatrix1D[] Brows = new IntMatrix1D[columnsA];
            int i = columnsA;
            while (--i >= 0) {
                Brows[i] = B.viewRow(i);
            }
            IntMatrix1D[] Crows = new IntMatrix1D[rowsA];
            int i2 = rowsA;
            while (--i2 >= 0) {
                Crows[i2] = C.viewRow(i2);
            }
            IntPlusMultSecond fun = IntPlusMultSecond.plusMult(0);
            int[] columnIndexesA = this.columnIndexes;
            int[] valuesA = this.values;
            int i3 = this.rows;
            while (--i3 >= 0) {
                int low = this.rowPointers[i3];
                int k = this.rowPointers[i3 + 1];
                while (--k >= low) {
                    int j = columnIndexesA[k];
                    fun.multiplicator = valuesA[k] * alpha;
                    if (!transposeA) {
                        Crows[i3].assign(Brows[j], fun);
                        continue;
                    }
                    Crows[j].assign(Brows[i3], fun);
                }
            }
        }
        return C;
    }

    private int cumsum(int[] p, int[] c, int n) {
        int nz = 0;
        int nz2 = 0;
        for (int k = 0; k < n; ++k) {
            p[k] = nz;
            nz += c[k];
            nz2 += c[k];
            c[k] = p[k];
        }
        p[n] = nz;
        return nz2;
    }

    private void realloc(int nzmax) {
        if (nzmax <= 0) {
            nzmax = this.rowPointers[this.rows];
        }
        int[] columnIndexesNew = new int[nzmax];
        int length = Math.min(nzmax, this.columnIndexes.length);
        System.arraycopy(this.columnIndexes, 0, columnIndexesNew, 0, length);
        this.columnIndexes = columnIndexesNew;
        int[] valuesNew = new int[nzmax];
        length = Math.min(nzmax, this.values.length);
        System.arraycopy(this.values, 0, valuesNew, 0, length);
        this.values = valuesNew;
    }

    @Override
    protected IntMatrix2D getContent() {
        return this;
    }

    protected void insert(int row, int column, int index, int value) {
        IntArrayList columnIndexesList = new IntArrayList(this.columnIndexes);
        columnIndexesList.setSizeRaw(this.rowPointers[this.rows]);
        IntArrayList valuesList = new IntArrayList(this.values);
        valuesList.setSizeRaw(this.rowPointers[this.rows]);
        columnIndexesList.beforeInsert(index, column);
        valuesList.beforeInsert(index, value);
        int i = this.rowPointers.length;
        while (--i > row) {
            int n = i;
            this.rowPointers[n] = this.rowPointers[n] + 1;
        }
        this.columnIndexes = columnIndexesList.elements();
        this.values = valuesList.elements();
    }

    protected void remove(int row, int index) {
        IntArrayList columnIndexesList = new IntArrayList(this.columnIndexes);
        columnIndexesList.setSizeRaw(this.rowPointers[this.rows]);
        IntArrayList valuesList = new IntArrayList(this.values);
        valuesList.setSizeRaw(this.rowPointers[this.rows]);
        columnIndexesList.remove(index);
        valuesList.remove(index);
        int i = this.rowPointers.length;
        while (--i > row) {
            int n = i;
            this.rowPointers[n] = this.rowPointers[n] - 1;
        }
        this.columnIndexes = columnIndexesList.elements();
        this.values = valuesList.elements();
    }
}

