/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntIntIntFunction;
import cern.colt.function.tlong.LongIntProcedure;
import cern.colt.map.tlong.AbstractLongIntMap;
import cern.colt.map.tlong.OpenLongIntHashMap;
import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.colt.matrix.tint.impl.SelectedSparseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseCCIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseCCMIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseIntMatrix1D;
import cern.colt.matrix.tint.impl.SparseRCIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseRCMIntMatrix2D;
import cern.jet.math.tint.IntFunctions;
import cern.jet.math.tint.IntMult;
import cern.jet.math.tint.IntPlusMultSecond;
import java.io.IOException;

public class SparseIntMatrix2D
extends IntMatrix2D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongIntMap elements;

    public SparseIntMatrix2D(int[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public SparseIntMatrix2D(int rows, int columns) {
        this(rows, columns, rows * (columns / 1000), 0.2, 0.5);
    }

    public SparseIntMatrix2D(int rows, int columns, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        block2: {
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new OpenLongIntHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    public SparseIntMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, int value) {
        block2: {
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new OpenLongIntHashMap(rowIndexes.length);
        this.insert(rowIndexes, columnIndexes, value);
    }

    public SparseIntMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, int[] values) {
        block2: {
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new OpenLongIntHashMap(rowIndexes.length);
        this.insert(rowIndexes, columnIndexes, values);
    }

    public SparseIntMatrix2D(MatrixVectorReader reader) throws IOException {
        block9: {
            int[] values;
            int[] rowIndexes;
            int[] columnIndexes;
            int numEntries;
            MatrixInfo info;
            block8: {
                MatrixSize size;
                block7: {
                    info = reader.hasInfo() ? reader.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                    if (info.isPattern()) {
                        throw new UnsupportedOperationException("Pattern matrices are not supported");
                    }
                    if (info.isDense()) {
                        throw new UnsupportedOperationException("Dense matrices are not supported");
                    }
                    if (info.isComplex()) {
                        throw new UnsupportedOperationException("Complex matrices are not supported");
                    }
                    size = reader.readMatrixSize(info);
                    try {
                        this.setUp(size.numRows(), size.numColumns());
                    }
                    catch (IllegalArgumentException exc) {
                        if ("matrix too large".equals(exc.getMessage())) break block7;
                        throw exc;
                    }
                }
                numEntries = size.numEntries();
                columnIndexes = new int[numEntries];
                rowIndexes = new int[numEntries];
                values = new int[numEntries];
                reader.readCoordinate(rowIndexes, columnIndexes, values);
                this.elements = info.isSymmetric() || info.isSkewSymmetric() ? new OpenLongIntHashMap(2 * rowIndexes.length) : new OpenLongIntHashMap(rowIndexes.length);
                this.insert(rowIndexes, columnIndexes, values);
                if (!info.isSymmetric()) break block8;
                for (int i = 0; i < numEntries; ++i) {
                    if (rowIndexes[i] == columnIndexes[i]) continue;
                    this.set(columnIndexes[i], rowIndexes[i], values[i]);
                }
                break block9;
            }
            if (!info.isSkewSymmetric()) break block9;
            for (int i = 0; i < numEntries; ++i) {
                if (rowIndexes[i] == columnIndexes[i]) continue;
                this.set(columnIndexes[i], rowIndexes[i], -values[i]);
            }
        }
    }

    protected SparseIntMatrix2D(int rows, int columns, AbstractLongIntMap elements, int rowZero, int columnZero, int rowStride, int columnStride) {
        block2: {
            try {
                this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public IntMatrix2D assign(IntFunction function) {
        if (this.isNoView && function instanceof IntMult) {
            this.elements.assign(function);
        } else {
            super.assign(function);
        }
        return this;
    }

    @Override
    public IntMatrix2D assign(int value) {
        if (this.isNoView && value == 0) {
            this.elements.clear();
        } else {
            super.assign(value);
        }
        return this;
    }

    @Override
    public IntMatrix2D assign(IntMatrix2D source) {
        if (!(source instanceof SparseIntMatrix2D)) {
            return super.assign(source);
        }
        SparseIntMatrix2D other = (SparseIntMatrix2D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        if (this.isNoView && other.isNoView) {
            this.elements.assign(other.elements);
            return this;
        }
        return super.assign(source);
    }

    @Override
    public IntMatrix2D assign(final IntMatrix2D y, IntIntFunction function) {
        if (!this.isNoView) {
            return super.assign(y, function);
        }
        this.checkShape(y);
        if (function instanceof IntPlusMultSecond) {
            final int alpha = ((IntPlusMultSecond)function).multiplicator;
            if (alpha == 0) {
                return this;
            }
            y.forEachNonZero(new IntIntIntFunction(){

                @Override
                public int apply(int i, int j, int value) {
                    SparseIntMatrix2D.this.setQuick(i, j, SparseIntMatrix2D.this.getQuick(i, j) + alpha * value);
                    return value;
                }
            });
        } else if (function == IntFunctions.mult) {
            this.elements.forEachPair(new LongIntProcedure(){

                @Override
                public boolean apply(long key, int value) {
                    int j;
                    int i = (int)(key / (long)SparseIntMatrix2D.this.columns);
                    int r = value * y.getQuick(i, j = (int)(key % (long)SparseIntMatrix2D.this.columns));
                    if (r != value) {
                        SparseIntMatrix2D.this.elements.put(key, r);
                    }
                    return true;
                }
            });
        } else if (function == IntFunctions.div) {
            this.elements.forEachPair(new LongIntProcedure(){

                @Override
                public boolean apply(long key, int value) {
                    int j;
                    int i = (int)(key / (long)SparseIntMatrix2D.this.columns);
                    int r = value / y.getQuick(i, j = (int)(key % (long)SparseIntMatrix2D.this.columns));
                    if (r != value) {
                        SparseIntMatrix2D.this.elements.put(key, r);
                    }
                    return true;
                }
            });
        } else {
            super.assign(y, function);
        }
        return this;
    }

    public SparseIntMatrix2D assign(int[] rowIndexes, int[] columnIndexes, int value, IntIntFunction function) {
        int size = rowIndexes.length;
        if (function == IntFunctions.plus) {
            for (int i = 0; i < size; ++i) {
                int row = rowIndexes[i];
                int column = columnIndexes[i];
                if (row >= this.rows || column >= this.columns) {
                    throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
                }
                int index = this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
                int elem = this.elements.get(index);
                int sum = elem + value;
                if (sum != 0) {
                    this.elements.put(index, sum);
                    continue;
                }
                this.elements.removeKey(index);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                int row = rowIndexes[i];
                int column = columnIndexes[i];
                if (row >= this.rows || column >= this.columns) {
                    throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
                }
                int index = this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
                int elem = this.elements.get(index);
                int result = function.apply(elem, value);
                if (result != 0) {
                    this.elements.put(index, result);
                    continue;
                }
                this.elements.removeKey(index);
            }
        }
        return this;
    }

    public SparseIntMatrix2D assign(int[] rowIndexes, int[] columnIndexes, int[] values, IntIntFunction function) {
        int size = rowIndexes.length;
        if (function == IntFunctions.plus) {
            for (int i = 0; i < size; ++i) {
                int value = values[i];
                int row = rowIndexes[i];
                int column = columnIndexes[i];
                if (row >= this.rows || column >= this.columns) {
                    throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
                }
                int index = this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
                int elem = this.elements.get(index);
                if ((value += elem) != 0) {
                    this.elements.put(index, value);
                    continue;
                }
                this.elements.removeKey(index);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                int value = values[i];
                int row = rowIndexes[i];
                int column = columnIndexes[i];
                if (row >= this.rows || column >= this.columns) {
                    throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
                }
                int index = this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
                int elem = this.elements.get(index);
                value = function.apply(elem, value);
                if (value != 0) {
                    this.elements.put(index, value);
                    continue;
                }
                this.elements.removeKey(index);
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public SparseCCIntMatrix2D getColumnCompressed(boolean sortRowIndexes) {
        int nnz = this.cardinality();
        long[] keys = this.elements.keys().elements();
        int[] values = this.elements.values().elements();
        int[] rowIndexes = new int[nnz];
        int[] columnIndexes = new int[nnz];
        for (int k = 0; k < nnz; ++k) {
            long key = keys[k];
            rowIndexes[k] = (int)(key / (long)this.columns);
            columnIndexes[k] = (int)(key % (long)this.columns);
        }
        return new SparseCCIntMatrix2D(this.rows, this.columns, rowIndexes, columnIndexes, values, false, false, sortRowIndexes);
    }

    public SparseCCMIntMatrix2D getColumnCompressedModified() {
        SparseCCMIntMatrix2D A = new SparseCCMIntMatrix2D(this.rows, this.columns);
        int nnz = this.cardinality();
        long[] keys = this.elements.keys().elements();
        int[] values = this.elements.values().elements();
        for (int i = 0; i < nnz; ++i) {
            int row = (int)(keys[i] / (long)this.columns);
            int column = (int)(keys[i] % (long)this.columns);
            A.setQuick(row, column, values[i]);
        }
        return A;
    }

    public SparseRCIntMatrix2D getRowCompressed(boolean sortColumnIndexes) {
        int nnz = this.cardinality();
        long[] keys = this.elements.keys().elements();
        int[] values = this.elements.values().elements();
        int[] rowIndexes = new int[nnz];
        int[] columnIndexes = new int[nnz];
        for (int k = 0; k < nnz; ++k) {
            long key = keys[k];
            rowIndexes[k] = (int)(key / (long)this.columns);
            columnIndexes[k] = (int)(key % (long)this.columns);
        }
        return new SparseRCIntMatrix2D(this.rows, this.columns, rowIndexes, columnIndexes, values, false, false, sortColumnIndexes);
    }

    public SparseRCMIntMatrix2D getRowCompressedModified() {
        SparseRCMIntMatrix2D A = new SparseRCMIntMatrix2D(this.rows, this.columns);
        int nnz = this.cardinality();
        long[] keys = this.elements.keys().elements();
        int[] values = this.elements.values().elements();
        for (int i = 0; i < nnz; ++i) {
            int row = (int)(keys[i] / (long)this.columns);
            int column = (int)(keys[i] % (long)this.columns);
            A.setQuick(row, column, values[i]);
        }
        return A;
    }

    @Override
    public AbstractLongIntMap elements() {
        return this.elements;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    @Override
    public IntMatrix2D forEachNonZero(final IntIntIntFunction function) {
        if (this.isNoView) {
            this.elements.forEachPair(new LongIntProcedure(){

                @Override
                public boolean apply(long key, int value) {
                    int j;
                    int i = (int)(key / (long)SparseIntMatrix2D.this.columns);
                    int r = function.apply(i, j = (int)(key % (long)SparseIntMatrix2D.this.columns), value);
                    if (r != value) {
                        SparseIntMatrix2D.this.elements.put(key, r);
                    }
                    return true;
                }
            });
        } else {
            super.forEachNonZero(function);
        }
        return this;
    }

    @Override
    public synchronized int getQuick(int row, int column) {
        return this.elements.get((long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride);
    }

    @Override
    public long index(int row, int column) {
        return (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
    }

    @Override
    public IntMatrix2D like(int rows, int columns) {
        return new SparseIntMatrix2D(rows, columns);
    }

    @Override
    public IntMatrix1D like1D(int size) {
        return new SparseIntMatrix1D(size);
    }

    @Override
    public synchronized void setQuick(int row, int column, int value) {
        long index = (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
        if (value == 0) {
            this.elements.removeKey(index);
        } else {
            this.elements.put(index, value);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                int elem = this.getQuick(r, c);
                if (elem == 0) continue;
                builder.append('(').append(r).append(',').append(c).append(')').append('\t').append(elem).append('\n');
            }
        }
        return builder.toString();
    }

    @Override
    public void trimToSize() {
        this.elements.trimToSize();
    }

    @Override
    public IntMatrix1D vectorize() {
        SparseIntMatrix1D v = new SparseIntMatrix1D((int)this.size());
        int idx = 0;
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                int elem = this.getQuick(r, c);
                v.setQuick(idx++, elem);
            }
        }
        return v;
    }

    @Override
    public IntMatrix1D zMult(IntMatrix1D y, IntMatrix1D z, final int alpha, int beta, final boolean transposeA) {
        boolean ignore;
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        boolean bl = ignore = z == null;
        if (z == null) {
            z = new DenseIntMatrix1D(rowsA);
        }
        if (!(this.isNoView && y instanceof DenseIntMatrix1D && z instanceof DenseIntMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)columnsA != y.size() || (long)rowsA > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (transposeA ? this.viewDice() : this).toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        if (!ignore) {
            z.assign(IntFunctions.mult(beta));
        }
        DenseIntMatrix1D zz = (DenseIntMatrix1D)z;
        final int[] elementsZ = zz.elements;
        final int strideZ = zz.stride();
        final int zeroZ = (int)z.index(0);
        DenseIntMatrix1D yy = (DenseIntMatrix1D)y;
        final int[] elementsY = yy.elements;
        final int strideY = yy.stride();
        final int zeroY = (int)y.index(0);
        if (elementsY == null || elementsZ == null) {
            throw new InternalError();
        }
        this.elements.forEachPair(new LongIntProcedure(){

            @Override
            public boolean apply(long key, int value) {
                int i = (int)(key / (long)SparseIntMatrix2D.this.columns);
                int j = (int)(key % (long)SparseIntMatrix2D.this.columns);
                if (transposeA) {
                    int tmp = i;
                    i = j;
                    j = tmp;
                }
                int n = zeroZ + strideZ * i;
                elementsZ[n] = elementsZ[n] + alpha * value * elementsY[zeroY + strideY * j];
                return true;
            }
        });
        return z;
    }

    @Override
    public IntMatrix2D zMult(IntMatrix2D B, IntMatrix2D C, final int alpha, int beta, final boolean transposeA, boolean transposeB) {
        boolean ignore;
        if (!this.isNoView) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        if (transposeB) {
            B = B.viewDice();
        }
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        int p = B.columns();
        boolean bl = ignore = C == null;
        if (C == null) {
            C = new DenseIntMatrix2D(rowsA, p);
        }
        if (B.rows() != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != p) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!ignore) {
            C.assign(IntFunctions.mult(beta));
        }
        final IntMatrix1D[] Brows = new IntMatrix1D[columnsA];
        int i = columnsA;
        while (--i >= 0) {
            Brows[i] = B.viewRow(i);
        }
        final IntMatrix1D[] Crows = new IntMatrix1D[rowsA];
        int i2 = rowsA;
        while (--i2 >= 0) {
            Crows[i2] = C.viewRow(i2);
        }
        final IntPlusMultSecond fun = IntPlusMultSecond.plusMult(0);
        this.elements.forEachPair(new LongIntProcedure(){

            @Override
            public boolean apply(long key, int value) {
                int i = (int)(key / (long)SparseIntMatrix2D.this.columns);
                int j = (int)(key % (long)SparseIntMatrix2D.this.columns);
                fun.multiplicator = value * alpha;
                if (!transposeA) {
                    Crows[i].assign(Brows[j], fun);
                } else {
                    Crows[j].assign(Brows[i], fun);
                }
                return true;
            }
        });
        return C;
    }

    private void insert(int[] rowIndexes, int[] columnIndexes, int value) {
        int size = rowIndexes.length;
        for (int i = 0; i < size; ++i) {
            int row = rowIndexes[i];
            int column = columnIndexes[i];
            if (row >= this.rows || column >= this.columns) {
                throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
            }
            if (value == 0) continue;
            int index = this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
            int elem = this.elements.get(index);
            if (elem == 0) {
                this.elements.put(index, value);
                continue;
            }
            int sum = elem + value;
            if (sum == 0) {
                this.elements.removeKey(index);
                continue;
            }
            this.elements.put(index, sum);
        }
    }

    private void insert(int[] rowIndexes, int[] columnIndexes, int[] values) {
        int size = rowIndexes.length;
        for (int i = 0; i < size; ++i) {
            int value = values[i];
            int row = rowIndexes[i];
            int column = columnIndexes[i];
            if (row >= this.rows || column >= this.columns) {
                throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
            }
            if (value == 0) continue;
            int index = this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
            int elem = this.elements.get(index);
            if (elem == 0) {
                this.elements.put(index, value);
                continue;
            }
            int sum = elem + value;
            if (sum == 0) {
                this.elements.removeKey(index);
                continue;
            }
            this.elements.put(index, sum);
        }
    }

    @Override
    protected boolean haveSharedCellsRaw(IntMatrix2D other) {
        if (other instanceof SelectedSparseIntMatrix2D) {
            SelectedSparseIntMatrix2D otherMatrix = (SelectedSparseIntMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseIntMatrix2D) {
            SparseIntMatrix2D otherMatrix = (SparseIntMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected IntMatrix1D like1D(int size, int offset, int stride) {
        return new SparseIntMatrix1D(size, this.elements, offset, stride);
    }

    @Override
    protected IntMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseIntMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }
}

