/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;

class SelectedDenseIntMatrix1D
extends IntMatrix1D {
    private static final long serialVersionUID = 1L;
    protected int[] elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedDenseIntMatrix1D(int[] elements, int[] offsets) {
        this(offsets.length, elements, 0, 1, offsets, 0);
    }

    protected SelectedDenseIntMatrix1D(int size, int[] elements, int zero, int stride, int[] offsets, int offset) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.offsets = offsets;
        this.offset = offset;
        this.isNoView = false;
    }

    public int[] elements() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public int getQuick(int index) {
        return this.elements[this.offset + this.offsets[this.zero + index * this.stride]];
    }

    @Override
    public long index(int rank) {
        return this.offset + this.offsets[this.zero + rank * this.stride];
    }

    @Override
    public IntMatrix1D like(int size) {
        return new DenseIntMatrix1D(size);
    }

    @Override
    public IntMatrix2D like2D(int rows, int columns) {
        return new DenseIntMatrix2D(rows, columns);
    }

    @Override
    public IntMatrix2D reshape(int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public IntMatrix3D reshape(int slices, int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public void setQuick(int index, int value) {
        this.elements[this.offset + this.offsets[this.zero + index * this.stride]] = value;
    }

    @Override
    protected int _offset(int absRank) {
        return this.offsets[absRank];
    }

    @Override
    protected boolean haveSharedCellsRaw(IntMatrix1D other) {
        if (other instanceof SelectedDenseIntMatrix1D) {
            SelectedDenseIntMatrix1D otherMatrix = (SelectedDenseIntMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseIntMatrix1D) {
            DenseIntMatrix1D otherMatrix = (DenseIntMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected void setUp(int size) {
        super.setUp(size);
        this.stride = 1;
        this.offset = 0;
    }

    @Override
    protected IntMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedDenseIntMatrix1D(this.elements, offsets);
    }
}

