/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseColumnIntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.SelectedDenseIntMatrix1D;

class SelectedDenseColumnIntMatrix2D
extends IntMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] elements;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedDenseColumnIntMatrix2D(int[] elements, int[] rowOffsets, int[] columnOffsets, int offset) {
        this(rowOffsets.length, columnOffsets.length, elements, 0, 0, 1, 1, rowOffsets, columnOffsets, offset);
    }

    protected SelectedDenseColumnIntMatrix2D(int rows, int columns, int[] elements, int rowZero, int columnZero, int rowStride, int columnStride, int[] rowOffsets, int[] columnOffsets, int offset) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.rowOffsets = rowOffsets;
        this.columnOffsets = columnOffsets;
        this.offset = offset;
        this.isNoView = false;
    }

    public int[] elements() {
        return this.elements;
    }

    @Override
    public int getQuick(int row, int column) {
        return this.elements[this.offset + this.rowOffsets[this.rowZero + row * this.rowStride] + this.columnOffsets[this.columnZero + column * this.columnStride]];
    }

    @Override
    public long index(int row, int column) {
        return this.offset + this.rowOffsets[this.rowZero + row * this.rowStride] + this.columnOffsets[this.columnZero + column * this.columnStride];
    }

    @Override
    public IntMatrix2D like(int rows, int columns) {
        return new DenseColumnIntMatrix2D(rows, columns);
    }

    @Override
    public IntMatrix1D like1D(int size) {
        return new DenseIntMatrix1D(size);
    }

    @Override
    public void setQuick(int row, int column, int value) {
        this.elements[this.offset + this.rowOffsets[this.rowZero + row * this.rowStride] + this.columnOffsets[this.columnZero + column * this.columnStride]] = value;
    }

    @Override
    public IntMatrix1D vectorize() {
        DenseIntMatrix1D v = new DenseIntMatrix1D((int)this.size());
        int idx = 0;
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                v.setQuick(idx++, this.getQuick(c, r));
            }
        }
        return v;
    }

    @Override
    public IntMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        int viewSize = this.rows;
        int viewZero = this.rowZero;
        int viewStride = this.rowStride;
        int[] viewOffsets = this.rowOffsets;
        int viewOffset = this.offset + this._columnOffset(this._columnRank(column));
        return new SelectedDenseIntMatrix1D(viewSize, this.elements, viewZero, viewStride, viewOffsets, viewOffset);
    }

    @Override
    public IntMatrix1D viewRow(int row) {
        this.checkRow(row);
        int viewSize = this.columns;
        int viewZero = this.columnZero;
        int viewStride = this.columnStride;
        int[] viewOffsets = this.columnOffsets;
        int viewOffset = this.offset + this._rowOffset(this._rowRank(row));
        return new SelectedDenseIntMatrix1D(viewSize, this.elements, viewZero, viewStride, viewOffsets, viewOffset);
    }

    @Override
    protected int _columnOffset(int absRank) {
        return this.columnOffsets[absRank];
    }

    @Override
    protected int _rowOffset(int absRank) {
        return this.rowOffsets[absRank];
    }

    @Override
    protected boolean haveSharedCellsRaw(IntMatrix2D other) {
        if (other instanceof SelectedDenseColumnIntMatrix2D) {
            SelectedDenseColumnIntMatrix2D otherMatrix = (SelectedDenseColumnIntMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseColumnIntMatrix2D) {
            DenseColumnIntMatrix2D otherMatrix = (DenseColumnIntMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected IntMatrix1D like1D(int size, int zero, int stride) {
        throw new InternalError();
    }

    @Override
    protected void setUp(int rows, int columns) {
        super.setUp(rows, columns);
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    @Override
    protected AbstractMatrix2D vDice() {
        super.vDice();
        int[] tmp = this.rowOffsets;
        this.rowOffsets = this.columnOffsets;
        this.columnOffsets = tmp;
        this.isNoView = false;
        return this;
    }

    @Override
    protected IntMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseColumnIntMatrix2D(this.elements, rowOffsets, columnOffsets, this.offset);
    }
}

