/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver.preconditioner;

import cern.colt.Sorting;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatPreconditioner;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;

public class FloatSSOR
implements FloatPreconditioner {
    private float omegaF;
    private float omegaR;
    private SparseRCFloatMatrix2D F;
    private final int[] diagind;
    private final float[] xx;
    private final boolean reverse;
    private final int n;

    public FloatSSOR(int n, boolean reverse, float omegaF, float omegaR) {
        this.n = n;
        this.reverse = reverse;
        this.setOmega(omegaF, omegaR);
        this.diagind = new int[n];
        this.xx = new float[n];
    }

    public FloatSSOR(int n) {
        this(n, true, 1.0f, 1.0f);
    }

    public void setOmega(float omegaF, float omegaR) {
        if (omegaF < 0.0f || omegaF > 2.0f) {
            throw new IllegalArgumentException("omegaF must be between 0 and 2");
        }
        if (omegaR < 0.0f || omegaR > 2.0f) {
            throw new IllegalArgumentException("omegaR must be between 0 and 2");
        }
        this.omegaF = omegaF;
        this.omegaR = omegaR;
    }

    @Override
    public void setMatrix(FloatMatrix2D A) {
        if (A.rows() != this.n) {
            throw new IllegalArgumentException("A.rows() != n");
        }
        this.F = new SparseRCFloatMatrix2D(this.n, this.n);
        this.F.assign(A);
        if (!this.F.hasColumnIndexesSorted()) {
            this.F.sortColumnIndexes();
        }
        int[] rowptr = this.F.getRowPointers();
        int[] colind = this.F.getColumnIndexes();
        for (int k = 0; k < this.n; ++k) {
            this.diagind[k] = Sorting.binarySearchFromTo(colind, k, rowptr[k], rowptr[k + 1] - 1);
            if (this.diagind[k] >= 0) continue;
            throw new RuntimeException("Missing diagonal on row " + (k + 1));
        }
    }

    @Override
    public FloatMatrix1D apply(FloatMatrix1D b, FloatMatrix1D x) {
        int j;
        float sigma;
        int i;
        if (x == null) {
            x = b.like();
        }
        if (!(b instanceof DenseFloatMatrix1D) || !(x instanceof DenseFloatMatrix1D)) {
            throw new IllegalArgumentException("b and x must be a DenseFloatMatrix1D");
        }
        int[] rowptr = this.F.getRowPointers();
        int[] colind = this.F.getColumnIndexes();
        float[] data = this.F.getValues();
        float[] bd = ((DenseFloatMatrix1D)b).elements();
        float[] xd = new float[(int)x.size()];
        int n = this.F.rows();
        System.arraycopy(xd, 0, this.xx, 0, n);
        for (i = 0; i < n; ++i) {
            sigma = 0.0f;
            for (j = rowptr[i]; j < this.diagind[i]; ++j) {
                sigma += data[j] * this.xx[colind[j]];
            }
            for (j = this.diagind[i] + 1; j < rowptr[i + 1]; ++j) {
                sigma += data[j] * xd[colind[j]];
            }
            sigma = (bd[i] - sigma) / data[this.diagind[i]];
            this.xx[i] = xd[i] + this.omegaF * (sigma - xd[i]);
        }
        if (!this.reverse) {
            System.arraycopy(this.xx, 0, xd, 0, n);
            x.assign(xd);
            return x;
        }
        for (i = n - 1; i >= 0; --i) {
            sigma = 0.0f;
            for (j = rowptr[i]; j < this.diagind[i]; ++j) {
                sigma += data[j] * this.xx[colind[j]];
            }
            for (j = this.diagind[i] + 1; j < rowptr[i + 1]; ++j) {
                sigma += data[j] * xd[colind[j]];
            }
            sigma = (bd[i] - sigma) / data[this.diagind[i]];
            xd[i] = this.xx[i] + this.omegaR * (sigma - this.xx[i]);
        }
        x.assign(xd);
        return x;
    }

    @Override
    public FloatMatrix1D transApply(FloatMatrix1D b, FloatMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        return this.apply(b, x);
    }
}

