/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver.preconditioner;

import cern.colt.matrix.Norm;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.DenseFloatAlgebra;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatPreconditioner;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseRCMFloatMatrix2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FloatILUT
implements FloatPreconditioner {
    private SparseRCMFloatMatrix2D LU;
    private final FloatMatrix1D y;
    private final float tau;
    private final List<IntFloatEntry> lower;
    private final List<IntFloatEntry> upper;
    private final int p;
    private final int n;

    public FloatILUT(int n, float tau, int p) {
        this.n = n;
        this.tau = tau;
        this.p = p;
        this.lower = new ArrayList<IntFloatEntry>(n);
        this.upper = new ArrayList<IntFloatEntry>(n);
        this.y = new DenseFloatMatrix1D(n);
    }

    public FloatILUT(int n) {
        this(n, 1.0E-6f, 25);
    }

    @Override
    public FloatMatrix1D apply(FloatMatrix1D b, FloatMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        this.unitLowerSolve(b, this.y);
        return this.upperSolve(this.y, x);
    }

    @Override
    public FloatMatrix1D transApply(FloatMatrix1D b, FloatMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        this.upperTransSolve(b, this.y);
        return this.unitLowerTransSolve(this.y, x);
    }

    @Override
    public void setMatrix(FloatMatrix2D A) {
        FloatProperty.DEFAULT.isSquare(A);
        if (A.rows() != this.n) {
            throw new IllegalArgumentException("A.rows() != n");
        }
        this.LU = new SparseRCMFloatMatrix2D(this.n, this.n);
        this.LU.assign(A);
        this.LU.trimToSize();
        this.factor();
    }

    private void factor() {
        int n = this.LU.rows();
        for (int i = 1; i < n; ++i) {
            SparseFloatMatrix1D rowi = this.LU.viewRow(i);
            float taui = DenseFloatAlgebra.DEFAULT.norm(rowi, Norm.Two) * this.tau;
            for (int k = 0; k < i; ++k) {
                SparseFloatMatrix1D rowk = this.LU.viewRow(k);
                if (rowk.getQuick(k) == 0.0f) {
                    throw new RuntimeException("Zero diagonal entry on row " + (k + 1) + " during ILU process");
                }
                float LUik = rowi.getQuick(k) / rowk.getQuick(k);
                if (Math.abs(LUik) <= taui) continue;
                int rowUsed = (int)rowk.size();
                for (int j = k + 1; j < rowUsed; ++j) {
                    rowi.setQuick(j, rowi.getQuick(j) - LUik * rowk.getQuick(j));
                }
                rowi.setQuick(k, LUik);
            }
            this.gather(rowi, taui, i);
        }
    }

    private void gather(SparseFloatMatrix1D v, float taui, int d) {
        IntFloatEntry e;
        int i;
        int nl = 0;
        int nu = 0;
        long[] indexes = v.elements().keys().elements();
        for (int i2 = 0; i2 < indexes.length; ++i2) {
            if (indexes[i2] < (long)d) {
                ++nl;
                continue;
            }
            if (indexes[i2] <= (long)d) continue;
            ++nu;
        }
        float[] z = v.toArray();
        v.assign(0.0f);
        this.lower.clear();
        for (i = 0; i < d; ++i) {
            if (!(Math.abs(z[i]) > taui)) continue;
            this.lower.add(new IntFloatEntry(i, z[i]));
        }
        this.upper.clear();
        for (i = d + 1; i < z.length; ++i) {
            if (!(Math.abs(z[i]) > taui)) continue;
            this.upper.add(new IntFloatEntry(i, z[i]));
        }
        Collections.sort(this.lower);
        Collections.sort(this.upper);
        v.setQuick(d, z[d]);
        for (i = 0; i < Math.min(nl + this.p, this.lower.size()); ++i) {
            e = this.lower.get(i);
            v.setQuick(e.index, e.value);
        }
        for (i = 0; i < Math.min(nu + this.p, this.upper.size()); ++i) {
            e = this.upper.get(i);
            v.setQuick(e.index, e.value);
        }
    }

    private FloatMatrix1D unitLowerSolve(FloatMatrix1D b, FloatMatrix1D x) {
        float[] bd = ((DenseFloatMatrix1D)b).elements();
        float[] xd = ((DenseFloatMatrix1D)x).elements();
        int rows = this.LU.rows();
        for (int i = 0; i < rows; ++i) {
            SparseFloatMatrix1D row = this.LU.viewRow(i);
            float sum = 0.0f;
            for (int j = 0; j < i; ++j) {
                sum += row.getQuick(j) * xd[j];
            }
            xd[i] = bd[i] - sum;
        }
        return x;
    }

    private FloatMatrix1D unitLowerTransSolve(FloatMatrix1D b, FloatMatrix1D x) {
        x.assign(b);
        float[] xd = ((DenseFloatMatrix1D)x).elements();
        int rows = this.LU.rows();
        for (int i = rows - 1; i >= 0; --i) {
            SparseFloatMatrix1D row = this.LU.viewRow(i);
            for (int j = 0; j < i; ++j) {
                int n = j;
                xd[n] = xd[n] - row.getQuick(j) * xd[i];
            }
        }
        return x;
    }

    private FloatMatrix1D upperSolve(FloatMatrix1D b, FloatMatrix1D x) {
        float[] bd = ((DenseFloatMatrix1D)b).elements();
        float[] xd = ((DenseFloatMatrix1D)x).elements();
        int rows = this.LU.rows();
        for (int i = rows - 1; i >= 0; --i) {
            SparseFloatMatrix1D row = this.LU.viewRow(i);
            int used = (int)row.size();
            float sum = 0.0f;
            for (int j = i + 1; j < used; ++j) {
                sum += row.getQuick(j) * xd[j];
            }
            xd[i] = (bd[i] - sum) / row.getQuick(i);
        }
        return x;
    }

    private FloatMatrix1D upperTransSolve(FloatMatrix1D b, FloatMatrix1D x) {
        x.assign(b);
        float[] xd = ((DenseFloatMatrix1D)x).elements();
        int rows = this.LU.rows();
        for (int i = 0; i < rows; ++i) {
            SparseFloatMatrix1D row = this.LU.viewRow(i);
            int used = (int)row.size();
            int n = i;
            xd[n] = xd[n] / row.getQuick(i);
            for (int j = i + 1; j < used; ++j) {
                int n2 = j;
                xd[n2] = xd[n2] - row.getQuick(j) * xd[i];
            }
        }
        return x;
    }

    private static class IntFloatEntry
    implements Comparable<IntFloatEntry> {
        public int index;
        public float value;

        public IntFloatEntry(int index, float value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public int compareTo(IntFloatEntry o) {
            if (Math.abs(this.value) < Math.abs(o.value)) {
                return 1;
            }
            if (Math.abs(this.value) == Math.abs(o.value)) {
                return 0;
            }
            return -1;
        }

        public String toString() {
            return "(" + this.index + "=" + this.value + ")";
        }
    }
}

