/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatCG
extends AbstractFloatIterativeSolver {
    private FloatMatrix1D p;
    private FloatMatrix1D z;
    private FloatMatrix1D q;
    private FloatMatrix1D r;

    public FloatCG(FloatMatrix1D template) {
        this.p = template.copy();
        this.z = template.copy();
        this.q = template.copy();
        this.r = template.copy();
    }

    @Override
    public FloatMatrix1D solve(FloatMatrix2D A, FloatMatrix1D b, FloatMatrix1D x) throws IterativeSolverFloatNotConvergedException {
        this.checkSizes(A, b, x);
        float alpha = 0.0f;
        float beta = 0.0f;
        float rho = 0.0f;
        float rho_1 = 0.0f;
        A.zMult(x, this.r.assign(b), -1.0f, 1.0f, false);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x)) {
            this.M.apply(this.r, this.z);
            rho = this.r.zDotProduct(this.z);
            if (this.iter.isFirst()) {
                this.p.assign(this.z);
            } else {
                beta = rho / rho_1;
                this.p.assign(this.z, FloatFunctions.plusMultFirst(beta));
            }
            A.zMult(this.p, this.q);
            alpha = rho / this.p.zDotProduct(this.q);
            x.assign(this.p, FloatFunctions.plusMultSecond(alpha));
            this.r.assign(this.q, FloatFunctions.plusMultSecond(-alpha));
            rho_1 = rho;
            this.iter.next();
        }
        return x;
    }
}

