/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.algo.decomposition.SparseFloatCholeskyDecomposition;
import cern.colt.matrix.tfloat.algo.decomposition.SparseFloatLUDecomposition;
import cern.colt.matrix.tfloat.algo.decomposition.SparseFloatQRDecomposition;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseCCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;
import edu.emory.mathcs.csparsej.tfloat.Scs_common;
import edu.emory.mathcs.csparsej.tfloat.Scs_norm;

public class SparseFloatAlgebra {
    public static final SparseFloatAlgebra DEFAULT = new SparseFloatAlgebra();
    public static final SparseFloatAlgebra ZERO;
    protected FloatProperty property;

    private static float normInfinityRC(SparseRCFloatMatrix2D A) {
        float norm = 0.0f;
        int n = A.rows();
        int[] Ap = A.getRowPointers();
        float[] Ax = A.getValues();
        for (int j = 0; j < n; ++j) {
            float s = 0.0f;
            for (int p = Ap[j]; p < Ap[j + 1]; ++p) {
                s += Math.abs(Ax[p]);
            }
            norm = Math.max(norm, s);
        }
        return norm;
    }

    public SparseFloatAlgebra() {
        this(FloatProperty.DEFAULT.tolerance());
    }

    public SparseFloatAlgebra(float tolerance) {
        this.setProperty(new FloatProperty(tolerance));
    }

    public SparseFloatCholeskyDecomposition chol(FloatMatrix2D matrix, int order) {
        return new SparseFloatCholeskyDecomposition(matrix, order);
    }

    public Object clone() {
        return new SparseFloatAlgebra(this.property.tolerance());
    }

    public float det(FloatMatrix2D A) {
        return this.lu(A, 0).det();
    }

    public SparseFloatLUDecomposition lu(FloatMatrix2D matrix, int order) {
        return new SparseFloatLUDecomposition(matrix, order, true);
    }

    public float norm1(FloatMatrix2D A) {
        FloatProperty.DEFAULT.checkSparse(A);
        float norm = A instanceof SparseCCFloatMatrix2D ? Scs_norm.cs_norm((Scs_common.Scs)((Scs_common.Scs)A.elements())) : Scs_norm.cs_norm((Scs_common.Scs)((SparseRCFloatMatrix2D)A).getColumnCompressed().elements());
        return norm;
    }

    public float normInfinity(FloatMatrix2D A) {
        FloatProperty.DEFAULT.checkSparse(A);
        float norm = A instanceof SparseRCFloatMatrix2D ? SparseFloatAlgebra.normInfinityRC((SparseRCFloatMatrix2D)A) : SparseFloatAlgebra.normInfinityRC(((SparseCCFloatMatrix2D)A).getRowCompressed());
        return norm;
    }

    public FloatProperty property() {
        return this.property;
    }

    public SparseFloatQRDecomposition qr(FloatMatrix2D matrix, int order) {
        return new SparseFloatQRDecomposition(matrix, order);
    }

    public void setProperty(FloatProperty property) {
        if (this == DEFAULT && property != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        if (this == ZERO && property != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.property = property;
    }

    public FloatMatrix1D solve(FloatMatrix2D A, FloatMatrix1D b) {
        DenseFloatMatrix1D x = new DenseFloatMatrix1D(Math.max(A.rows(), A.columns()));
        x.viewPart(0, (int)b.size()).assign(b);
        if (A.rows() == A.columns()) {
            this.lu(A, 0).solve(x);
            return x;
        }
        this.qr(A, 0).solve(x);
        return x.viewPart(0, A.columns()).copy();
    }

    static {
        SparseFloatAlgebra.DEFAULT.property = FloatProperty.DEFAULT;
        ZERO = new SparseFloatAlgebra();
        SparseFloatAlgebra.ZERO.property = FloatProperty.ZERO;
    }
}

