/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.SelectedSparseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import edu.emory.utils.ConcurrencyUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

public class SparseFComplexMatrix1D
extends FComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    protected ConcurrentHashMap<Long, float[]> elements;

    public SparseFComplexMatrix1D(float[] values) {
        this(values.length);
        this.assign(values);
    }

    public SparseFComplexMatrix1D(int size) {
        this.setUp(size);
        this.elements = new ConcurrentHashMap(size / 1000);
    }

    protected SparseFComplexMatrix1D(int size, ConcurrentHashMap<Long, float[]> elements, int offset, int stride) {
        this.setUp(size, offset, stride);
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public FComplexMatrix1D assign(float[] value) {
        if (this.isNoView && value[0] == 0.0f && value[1] == 0.0f) {
            this.elements.clear();
        } else {
            super.assign(value);
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public synchronized float[] getQuick(int index) {
        float[] elem = this.elements.get((long)this.zero + (long)index * (long)this.stride);
        if (elem != null) {
            return new float[]{elem[0], elem[1]};
        }
        return new float[2];
    }

    @Override
    public ConcurrentHashMap<Long, float[]> elements() {
        return this.elements;
    }

    @Override
    protected boolean haveSharedCellsRaw(FComplexMatrix1D other) {
        if (other instanceof SelectedSparseFComplexMatrix1D) {
            SelectedSparseFComplexMatrix1D otherMatrix = (SelectedSparseFComplexMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseFComplexMatrix1D) {
            SparseFComplexMatrix1D otherMatrix = (SparseFComplexMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int rank) {
        return (long)this.zero + (long)rank * (long)this.stride;
    }

    @Override
    public FComplexMatrix1D like(int size) {
        return new SparseFComplexMatrix1D(size);
    }

    @Override
    public FComplexMatrix2D like2D(int rows, int columns) {
        return new SparseFComplexMatrix2D(rows, columns);
    }

    @Override
    public FComplexMatrix2D reshape(final int rows, int columns) {
        if (rows * columns != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        final SparseFComplexMatrix2D M = new SparseFComplexMatrix2D(rows, columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            int idx = c * rows;
                            for (int r = 0; r < rows; ++r) {
                                float[] elem;
                                if ((elem = SparseFComplexMatrix1D.this.getQuick(idx++))[0] == 0.0f && elem[1] == 0.0f) continue;
                                M.setQuick(r, c, elem);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            for (int c = 0; c < columns; ++c) {
                for (int r = 0; r < rows; ++r) {
                    float[] elem;
                    if ((elem = this.getQuick(idx++))[0] == 0.0f && elem[1] == 0.0f) continue;
                    ((FComplexMatrix2D)M).setQuick(r, c, elem);
                }
            }
        }
        return M;
    }

    @Override
    public FComplexMatrix3D reshape(int slices, final int rows, final int columns) {
        if (slices * rows * columns != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        final SparseFComplexMatrix3D M = new SparseFComplexMatrix3D(slices, rows, columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int c = 0; c < columns; ++c) {
                                int idx = s * rows * columns + c * rows;
                                for (int r = 0; r < rows; ++r) {
                                    float[] elem;
                                    if ((elem = SparseFComplexMatrix1D.this.getQuick(idx++))[0] == 0.0f && elem[1] == 0.0f) continue;
                                    M.setQuick(s, r, c, elem);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            for (int s = 0; s < slices; ++s) {
                for (int c = 0; c < columns; ++c) {
                    for (int r = 0; r < rows; ++r) {
                        float[] elem;
                        if ((elem = this.getQuick(idx++))[0] == 0.0f && elem[1] == 0.0f) continue;
                        ((FComplexMatrix3D)M).setQuick(s, r, c, elem);
                    }
                }
            }
        }
        return M;
    }

    @Override
    public synchronized void setQuick(int index, float[] value) {
        long i = (long)this.zero + (long)index * (long)this.stride;
        if (value[0] == 0.0f && value[1] == 0.0f) {
            this.elements.remove(i);
        } else {
            this.elements.put(i, value);
        }
    }

    @Override
    public synchronized void setQuick(int index, float re, float im) {
        long i = (long)this.zero + (long)index * (long)this.stride;
        if (re == 0.0f && im == 0.0f) {
            this.elements.remove(i);
        } else {
            this.elements.put(i, new float[]{re, im});
        }
    }

    @Override
    protected FComplexMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedSparseFComplexMatrix1D(this.elements, offsets);
    }

    @Override
    public FloatMatrix1D getImaginaryPart() {
        final SparseFloatMatrix1D Im = new SparseFloatMatrix1D(this.size);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            Im.setQuick(i, SparseFComplexMatrix1D.this.getQuick(i)[1]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                ((FloatMatrix1D)Im).setQuick(i, this.getQuick(i)[1]);
            }
        }
        return Im;
    }

    @Override
    public FloatMatrix1D getRealPart() {
        final SparseFloatMatrix1D Re = new SparseFloatMatrix1D(this.size);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            Re.setQuick(i, SparseFComplexMatrix1D.this.getQuick(i)[0]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                ((FloatMatrix1D)Re).setQuick(i, this.getQuick(i)[0]);
            }
        }
        return Re;
    }
}

