/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver.preconditioner;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoublePreconditioner;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;

public class DoubleDiagonal
implements DoublePreconditioner {
    private double[] invdiag;

    public DoubleDiagonal(int n) {
        this.invdiag = new double[n];
    }

    @Override
    public DoubleMatrix1D apply(DoubleMatrix1D b, DoubleMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        if (!(x instanceof DenseDoubleMatrix1D) || !(b instanceof DenseDoubleMatrix1D)) {
            throw new IllegalArgumentException("a nad b must be dense vectors");
        }
        double[] xd = ((DenseDoubleMatrix1D)x).elements();
        double[] bd = ((DenseDoubleMatrix1D)b).elements();
        for (int i = 0; i < this.invdiag.length; ++i) {
            xd[i] = bd[i] * this.invdiag[i];
        }
        return x;
    }

    @Override
    public DoubleMatrix1D transApply(DoubleMatrix1D b, DoubleMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        return this.apply(b, x);
    }

    @Override
    public void setMatrix(DoubleMatrix2D A) {
        if (A.rows() != this.invdiag.length) {
            throw new IllegalArgumentException("Matrix size differs from preconditioner size");
        }
        for (int i = 0; i < this.invdiag.length; ++i) {
            this.invdiag[i] = A.getQuick(i, i);
            if (this.invdiag[i] == 0.0) {
                throw new RuntimeException("Zero diagonal on row " + (i + 1));
            }
            this.invdiag[i] = 1.0 / this.invdiag[i];
        }
    }
}

