/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble;

import cern.colt.function.tdouble.Double9Function;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix1DProcedure;
import cern.colt.matrix.tdouble.algo.DoubleFormatter;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.DoubleSorting;
import cern.jet.math.tdouble.DoubleFunctions;
import edu.emory.utils.ConcurrencyUtils;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class DoubleMatrix2D
extends AbstractMatrix2D {
    private static final long serialVersionUID = 1L;

    protected DoubleMatrix2D() {
    }

    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DoubleMatrix2D.this.getQuick(firstRow, 0));
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < DoubleMatrix2D.this.columns; ++c) {
                                a = aggr.apply(a, f.apply(DoubleMatrix2D.this.getQuick(r, c)));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0));
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    a = aggr.apply(a, f.apply(this.getQuick(r, c)));
                }
                d = 0;
            }
        }
        return a;
    }

    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f, final DoubleProcedure cond) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double elem = DoubleMatrix2D.this.getQuick(firstRow, 0);
                        double a = 0.0;
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < DoubleMatrix2D.this.columns; ++c) {
                                elem = DoubleMatrix2D.this.getQuick(r, c);
                                if (!cond.apply(elem)) continue;
                                a = aggr.apply(a, f.apply(elem));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            double elem = this.getQuick(0, 0);
            if (cond.apply(elem)) {
                a = aggr.apply(a, f.apply(elem));
            }
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    elem = this.getQuick(r, c);
                    if (!cond.apply(elem)) continue;
                    a = aggr.apply(a, f.apply(elem));
                }
                d = 0;
            }
        }
        return a;
    }

    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DoubleMatrix2D.this.getQuick(rowElements[firstIdx], columnElements[firstIdx]));
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            double elem = DoubleMatrix2D.this.getQuick(rowElements[i], columnElements[i]);
                            a = aggr.apply(a, f.apply(elem));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(rowElements[0], columnElements[0]));
            for (int i = 1; i < size; ++i) {
                double elem = this.getQuick(rowElements[i], columnElements[i]);
                a = aggr.apply(a, f.apply(elem));
            }
        }
        return a;
    }

    public double aggregate(final DoubleMatrix2D other, final DoubleDoubleFunction aggr, final DoubleDoubleFunction f) {
        this.checkShape(other);
        if (this.size() == 0L) {
            return Double.NaN;
        }
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DoubleMatrix2D.this.getQuick(firstRow, 0), other.getQuick(firstRow, 0));
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < DoubleMatrix2D.this.columns; ++c) {
                                a = aggr.apply(a, f.apply(DoubleMatrix2D.this.getQuick(r, c), other.getQuick(r, c)));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0), other.getQuick(0, 0));
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    a = aggr.apply(a, f.apply(this.getQuick(r, c), other.getQuick(r, c)));
                }
                d = 0;
            }
        }
        return a;
    }

    public DoubleMatrix2D assign(final DoubleFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleMatrix2D.this.columns; ++c) {
                                DoubleMatrix2D.this.setQuick(r, c, f.apply(DoubleMatrix2D.this.getQuick(r, c)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, f.apply(this.getQuick(r, c)));
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final DoubleProcedure cond, final DoubleFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleMatrix2D.this.columns; ++c) {
                                double elem = DoubleMatrix2D.this.getQuick(r, c);
                                if (!cond.apply(elem)) continue;
                                DoubleMatrix2D.this.setQuick(r, c, f.apply(elem));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    double elem = this.getQuick(r, c);
                    if (!cond.apply(elem)) continue;
                    this.setQuick(r, c, f.apply(elem));
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final DoubleProcedure cond, final double value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleMatrix2D.this.columns; ++c) {
                                double elem = DoubleMatrix2D.this.getQuick(r, c);
                                if (!cond.apply(elem)) continue;
                                DoubleMatrix2D.this.setQuick(r, c, value);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    double elem = this.getQuick(r, c);
                    if (!cond.apply(elem)) continue;
                    this.setQuick(r, c, value);
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final double value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleMatrix2D.this.columns; ++c) {
                                DoubleMatrix2D.this.setQuick(r, c, value);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, value);
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final double[] values) {
        if (values.length != this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "rows()*columns()=" + this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = firstRow * DoubleMatrix2D.this.columns;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleMatrix2D.this.columns; ++c) {
                                DoubleMatrix2D.this.setQuick(r, c, values[idx++]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, values[idx++]);
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final double[][] values) {
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            double[] currentRow = values[r];
                            if (currentRow.length != DoubleMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DoubleMatrix2D.this.columns());
                            }
                            for (int c = 0; c < DoubleMatrix2D.this.columns; ++c) {
                                DoubleMatrix2D.this.setQuick(r, c, currentRow[c]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                double[] currentRow = values[r];
                if (currentRow.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                }
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, currentRow[c]);
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D other) {
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        final DoubleMatrix2D source = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleMatrix2D.this.columns; ++c) {
                                DoubleMatrix2D.this.setQuick(r, c, source.getQuick(r, c));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, source.getQuick(r, c));
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final DoubleMatrix2D y, final DoubleDoubleFunction function) {
        this.checkShape(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleMatrix2D.this.columns; ++c) {
                                DoubleMatrix2D.this.setQuick(r, c, function.apply(DoubleMatrix2D.this.getQuick(r, c), y.getQuick(r, c)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, function.apply(this.getQuick(r, c), y.getQuick(r, c)));
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final DoubleMatrix2D y, final DoubleDoubleFunction function, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            DoubleMatrix2D.this.setQuick(rowElements[i], columnElements[i], function.apply(DoubleMatrix2D.this.getQuick(rowElements[i], columnElements[i]), y.getQuick(rowElements[i], columnElements[i])));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                this.setQuick(rowElements[i], columnElements[i], function.apply(this.getQuick(rowElements[i], columnElements[i]), y.getQuick(rowElements[i], columnElements[i])));
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final float[] values) {
        if (values.length != this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "rows()*columns()=" + this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = firstRow * DoubleMatrix2D.this.columns;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleMatrix2D.this.columns; ++c) {
                                DoubleMatrix2D.this.setQuick(r, c, values[idx++]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, values[idx++]);
                }
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleMatrix2D.this.columns; ++c) {
                                if (DoubleMatrix2D.this.getQuick(r, c) == 0.0) continue;
                                ++cardinality;
                            }
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    if (this.getQuick(r, c) == 0.0) continue;
                    ++cardinality;
                }
            }
        }
        return cardinality;
    }

    public DoubleMatrix2D copy() {
        return this.like().assign(this);
    }

    public abstract Object elements();

    public boolean equals(double value) {
        return DoubleProperty.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DoubleMatrix2D)) {
            return false;
        }
        return DoubleProperty.DEFAULT.equals(this, (DoubleMatrix2D)obj);
    }

    public DoubleMatrix2D forEachNonZero(final IntIntDoubleFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleMatrix2D.this.columns; ++c) {
                                double a;
                                double value = DoubleMatrix2D.this.getQuick(r, c);
                                if (value == 0.0 || (a = function.apply(r, c, value)) == value) continue;
                                DoubleMatrix2D.this.setQuick(r, c, a);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    double a;
                    double value = this.getQuick(r, c);
                    if (value == 0.0 || (a = function.apply(r, c, value)) == value) continue;
                    this.setQuick(r, c, a);
                }
            }
        }
        return this;
    }

    public double get(int row, int column) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        return this.getQuick(row, column);
    }

    public double[] getMaxLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        double maxValue = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = this.rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int rowLocation = firstRow;
                        int columnLocation = 0;
                        double maxValue = DoubleMatrix2D.this.getQuick(rowLocation, 0);
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < DoubleMatrix2D.this.columns; ++c) {
                                double elem = DoubleMatrix2D.this.getQuick(r, c);
                                if (!(maxValue < elem)) continue;
                                maxValue = elem;
                                rowLocation = r;
                                columnLocation = c;
                            }
                            d = 0;
                        }
                        return new double[]{maxValue, rowLocation, columnLocation};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (double[])futures[j].get();
                }
                maxValue = results[0][0];
                rowLocation = (int)results[0][1];
                columnLocation = (int)results[0][2];
                for (j = 1; j < nthreads; ++j) {
                    if (!(maxValue < results[j][0])) continue;
                    maxValue = results[j][0];
                    rowLocation = (int)results[j][1];
                    columnLocation = (int)results[j][2];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.getQuick(0, 0);
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    double elem = this.getQuick(r, c);
                    if (!(maxValue < elem)) continue;
                    maxValue = elem;
                    rowLocation = r;
                    columnLocation = c;
                }
                d = 0;
            }
        }
        return new double[]{maxValue, rowLocation, columnLocation};
    }

    public double[] getMinLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        double minValue = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = this.rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int rowLocation = firstRow;
                        int columnLocation = 0;
                        double minValue = DoubleMatrix2D.this.getQuick(rowLocation, 0);
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < DoubleMatrix2D.this.columns; ++c) {
                                double elem = DoubleMatrix2D.this.getQuick(r, c);
                                if (!(minValue > elem)) continue;
                                minValue = elem;
                                rowLocation = r;
                                columnLocation = c;
                            }
                            d = 0;
                        }
                        return new double[]{minValue, rowLocation, columnLocation};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (double[])futures[j].get();
                }
                minValue = results[0][0];
                rowLocation = (int)results[0][1];
                columnLocation = (int)results[0][2];
                for (j = 1; j < nthreads; ++j) {
                    if (!(minValue > results[j][0])) continue;
                    minValue = results[j][0];
                    rowLocation = (int)results[j][1];
                    columnLocation = (int)results[j][2];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.getQuick(0, 0);
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    double elem = this.getQuick(r, c);
                    if (!(minValue > elem)) continue;
                    minValue = elem;
                    rowLocation = r;
                    columnLocation = c;
                }
                d = 0;
            }
        }
        return new double[]{minValue, rowLocation, columnLocation};
    }

    public void getNegativeValues(IntArrayList rowList, IntArrayList columnList, DoubleArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                double value = this.getQuick(r, c);
                if (!(value < 0.0)) continue;
                rowList.add(r);
                columnList.add(c);
                valueList.add(value);
            }
        }
    }

    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, DoubleArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                double value = this.getQuick(r, c);
                if (value == 0.0) continue;
                rowList.add(r);
                columnList.add(c);
                valueList.add(value);
            }
        }
    }

    public void getPositiveValues(IntArrayList rowList, IntArrayList columnList, DoubleArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                double value = this.getQuick(r, c);
                if (!(value > 0.0)) continue;
                rowList.add(r);
                columnList.add(c);
                valueList.add(value);
            }
        }
    }

    public abstract double getQuick(int var1, int var2);

    public DoubleMatrix2D like() {
        return this.like(this.rows, this.columns);
    }

    public abstract DoubleMatrix2D like(int var1, int var2);

    public abstract DoubleMatrix1D like1D(int var1);

    public void normalize() {
        double min = this.getMinLocation()[0];
        if (min < 0.0) {
            this.assign(DoubleFunctions.minus(min));
        }
        if (this.getMaxLocation()[0] == 0.0) {
            this.assign(1.0 / (double)this.size());
        } else {
            double sumScaleFactor = this.zSum();
            sumScaleFactor = 1.0 / sumScaleFactor;
            this.assign(DoubleFunctions.mult(sumScaleFactor));
        }
    }

    public void set(int row, int column, double value) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        this.setQuick(row, column, value);
    }

    public abstract void setQuick(int var1, int var2, double var3);

    public double[][] toArray() {
        final double[][] values = new double[this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            double[] currentRow = values[r];
                            for (int c = 0; c < DoubleMatrix2D.this.columns; ++c) {
                                currentRow[c] = DoubleMatrix2D.this.getQuick(r, c);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                double[] currentRow = values[r];
                for (int c = 0; c < this.columns; ++c) {
                    currentRow[c] = this.getQuick(r, c);
                }
            }
        }
        return values;
    }

    public String toString() {
        return new DoubleFormatter().toString(this);
    }

    public abstract DoubleMatrix1D vectorize();

    public DoubleMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        int viewSize = this.rows;
        int viewZero = (int)this.index(0, column);
        int viewStride = this.rowStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public DoubleMatrix2D viewColumnFlip() {
        return (DoubleMatrix2D)this.view().vColumnFlip();
    }

    public DoubleMatrix2D viewDice() {
        return (DoubleMatrix2D)this.view().vDice();
    }

    public DoubleMatrix2D viewPart(int row, int column, int height, int width) {
        return (DoubleMatrix2D)this.view().vPart(row, column, height, width);
    }

    public DoubleMatrix1D viewRow(int row) {
        this.checkRow(row);
        int viewSize = this.columns;
        int viewZero = (int)this.index(row, 0);
        int viewStride = this.columnStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public DoubleMatrix2D viewRowFlip() {
        return (DoubleMatrix2D)this.view().vRowFlip();
    }

    public DoubleMatrix2D viewSelection(DoubleMatrix1DProcedure condition) {
        IntArrayList matches = new IntArrayList();
        for (int i = 0; i < this.rows; ++i) {
            if (!condition.apply(this.viewRow(i))) continue;
            matches.add(i);
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements(), null);
    }

    public DoubleMatrix2D viewSelection(int[] rowIndexes, int[] columnIndexes) {
        int i;
        int i2;
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            for (i2 = 0; i2 < this.rows; ++i2) {
                rowIndexes[i2] = i2;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            for (i2 = 0; i2 < this.columns; ++i2) {
                columnIndexes[i2] = i2;
            }
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        for (i = 0; i < rowIndexes.length; ++i) {
            rowOffsets[i] = this._rowOffset(this._rowRank(rowIndexes[i]));
        }
        for (i = 0; i < columnIndexes.length; ++i) {
            columnOffsets[i] = this._columnOffset(this._columnRank(columnIndexes[i]));
        }
        return this.viewSelectionLike(rowOffsets, columnOffsets);
    }

    public DoubleMatrix2D viewSelection(Set<int[]> indexes) {
        int i;
        int n = indexes.size();
        int[] rowIndexes = new int[n];
        int[] columnIndexes = new int[n];
        int idx = 0;
        for (int[] is : indexes) {
            rowIndexes[idx] = is[0];
            columnIndexes[idx] = is[1];
            ++idx;
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        for (i = 0; i < rowIndexes.length; ++i) {
            rowOffsets[i] = this._rowOffset(this._rowRank(rowIndexes[i]));
        }
        for (i = 0; i < columnIndexes.length; ++i) {
            columnOffsets[i] = this._columnOffset(this._columnRank(columnIndexes[i]));
        }
        return this.viewSelectionLike(rowOffsets, columnOffsets);
    }

    public DoubleMatrix2D viewSorted(int column) {
        return DoubleSorting.mergeSort.sort(this, column);
    }

    public DoubleMatrix2D viewStrides(int rowStride, int columnStride) {
        return (DoubleMatrix2D)this.view().vStrides(rowStride, columnStride);
    }

    public void zAssign8Neighbors(DoubleMatrix2D B, Double9Function function) {
        if (function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(B);
        if (this.rows < 3 || this.columns < 3) {
            return;
        }
        int r = this.rows - 1;
        int c = this.columns - 1;
        for (int i = 1; i < r; ++i) {
            double a00 = this.getQuick(i - 1, 0);
            double a01 = this.getQuick(i - 1, 1);
            double a10 = this.getQuick(i, 0);
            double a11 = this.getQuick(i, 1);
            double a20 = this.getQuick(i + 1, 0);
            double a21 = this.getQuick(i + 1, 1);
            for (int j = 1; j < c; ++j) {
                double a02 = this.getQuick(i - 1, j + 1);
                double a12 = this.getQuick(i, j + 1);
                double a22 = this.getQuick(i + 1, j + 1);
                B.setQuick(i, j, function.apply(a00, a01, a02, a10, a11, a12, a20, a21, a22));
                a00 = a01;
                a10 = a11;
                a20 = a21;
                a01 = a02;
                a11 = a12;
                a21 = a22;
            }
        }
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D y, DoubleMatrix1D z) {
        return this.zMult(y, z, 1.0, 0.0, false);
    }

    public DoubleMatrix1D zMult(final DoubleMatrix1D y, DoubleMatrix1D z, final double alpha, final double beta, boolean transposeA) {
        if (transposeA) {
            return this.viewDice().zMult(y, z, alpha, beta, false);
        }
        final DoubleMatrix1D zz = z == null ? y.like(this.rows) : z;
        if ((long)this.columns != y.size() || (long)this.rows > zz.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + y.toStringShort() + ", " + zz.toStringShort());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            double s = 0.0;
                            for (int c = 0; c < DoubleMatrix2D.this.columns; ++c) {
                                s += DoubleMatrix2D.this.getQuick(r, c) * y.getQuick(c);
                            }
                            zz.setQuick(r, alpha * s + beta * zz.getQuick(r));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                double s = 0.0;
                for (int c = 0; c < this.columns; ++c) {
                    s += this.getQuick(r, c) * y.getQuick(c);
                }
                zz.setQuick(r, alpha * s + beta * zz.getQuick(r));
            }
        }
        return zz;
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D B, DoubleMatrix2D C) {
        return this.zMult(B, C, 1.0, 0.0, false, false);
    }

    public DoubleMatrix2D zMult(final DoubleMatrix2D B, DoubleMatrix2D C, final double alpha, final double beta, boolean transposeA, boolean transposeB) {
        if (transposeA) {
            return this.viewDice().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (transposeB) {
            return this.zMult(B.viewDice(), C, alpha, beta, transposeA, false);
        }
        final int m = this.rows;
        final int n = this.columns;
        int p = B.columns;
        final DoubleMatrix2D CC = C == null ? this.like(m, p) : C;
        if (B.rows != n) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (CC.rows != m || CC.columns != p) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + CC.toStringShort());
        }
        if (this == CC || B == CC) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, p);
            Future[] futures = new Future[nthreads];
            int k = p / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? p : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int a = firstIdx; a < lastIdx; ++a) {
                            for (int b = 0; b < m; ++b) {
                                double s = 0.0;
                                for (int c = 0; c < n; ++c) {
                                    s += DoubleMatrix2D.this.getQuick(b, c) * B.getQuick(c, a);
                                }
                                CC.setQuick(b, a, alpha * s + beta * CC.getQuick(b, a));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int a = 0; a < p; ++a) {
                for (int b = 0; b < m; ++b) {
                    double s = 0.0;
                    for (int c = 0; c < n; ++c) {
                        s += this.getQuick(b, c) * B.getQuick(c, a);
                    }
                    CC.setQuick(b, a, alpha * s + beta * CC.getQuick(b, a));
                }
            }
        }
        return CC;
    }

    public double zSum() {
        if (this.size() == 0L) {
            return 0.0;
        }
        return this.aggregate(DoubleFunctions.plus, DoubleFunctions.identity);
    }

    protected DoubleMatrix2D getContent() {
        return this;
    }

    protected boolean haveSharedCells(DoubleMatrix2D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix2D other) {
        return false;
    }

    protected abstract DoubleMatrix1D like1D(int var1, int var2, int var3);

    protected DoubleMatrix2D view() {
        return (DoubleMatrix2D)this.clone();
    }

    protected abstract DoubleMatrix2D viewSelectionLike(int[] var1, int[] var2);
}

