/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.WrapperDComplexMatrix2D;

public class SparseRCMDComplexMatrix2D
extends WrapperDComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseDComplexMatrix1D[] elements;

    public SparseRCMDComplexMatrix2D(int rows, int columns) {
        block3: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        this.elements = new SparseDComplexMatrix1D[rows];
        for (int i = 0; i < rows; ++i) {
            this.elements[i] = new SparseDComplexMatrix1D(columns);
        }
    }

    public SparseDComplexMatrix1D[] elements() {
        return this.elements;
    }

    @Override
    public double[] getQuick(int row, int column) {
        return this.elements[row].getQuick(column);
    }

    @Override
    public void setQuick(int row, int column, double[] value) {
        this.elements[row].setQuick(column, value);
    }

    @Override
    public void setQuick(int row, int column, double re, double im) {
        this.elements[row].setQuick(column, re, im);
    }

    @Override
    public void trimToSize() {
        for (int r = 0; r < this.rows; ++r) {
            this.elements[r].trimToSize();
        }
    }

    @Override
    public SparseDComplexMatrix1D viewRow(int row) {
        return this.elements[row];
    }

    @Override
    protected DComplexMatrix2D getContent() {
        return this;
    }

    @Override
    public DComplexMatrix2D like(int rows, int columns) {
        return new SparseRCMDComplexMatrix2D(rows, columns);
    }
}

