/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.WrapperDComplexMatrix2D;

public class SparseCCMDComplexMatrix2D
extends WrapperDComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseDComplexMatrix1D[] elements;

    public SparseCCMDComplexMatrix2D(int rows, int columns) {
        block3: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        this.elements = new SparseDComplexMatrix1D[columns];
        for (int i = 0; i < columns; ++i) {
            this.elements[i] = new SparseDComplexMatrix1D(rows);
        }
    }

    public SparseDComplexMatrix1D[] elements() {
        return this.elements;
    }

    @Override
    public double[] getQuick(int row, int column) {
        return this.elements[column].getQuick(row);
    }

    @Override
    public void setQuick(int row, int column, double[] value) {
        this.elements[column].setQuick(row, value);
    }

    @Override
    public void setQuick(int row, int column, double re, double im) {
        this.elements[column].setQuick(row, re, im);
    }

    @Override
    public void trimToSize() {
        for (int c = 0; c < this.columns; ++c) {
            this.elements[c].trimToSize();
        }
    }

    @Override
    public SparseDComplexMatrix1D viewColumn(int column) {
        return this.elements[column];
    }

    @Override
    protected DComplexMatrix2D getContent() {
        return this;
    }

    @Override
    public DComplexMatrix2D like(int rows, int columns) {
        return new SparseCCMDComplexMatrix2D(rows, columns);
    }
}

