/*
 * Decompiled with CFR 0.152.
 */
package cern.colt;

public final class Version {
    private Version() {
    }

    public static String asString() {
        if (Version.getPackage() == null) {
            return "piotr.wendykier@gmail.com";
        }
        String vendor = Version.getPackage().getImplementationVendor();
        if (vendor == null) {
            vendor = "piotr.wendykier@gmail.com";
        }
        return "Version " + Version.getMajorVersion() + "." + Version.getMinorVersion() + "." + Version.getMicroVersion() + "." + Version.getBuildVersion() + " (" + Version.getBuildTime() + ")" + "\nPlease report problems to " + vendor;
    }

    public static String getBuildTime() {
        if (Version.getPackage() == null) {
            return "unknown";
        }
        String s = Version.getPackage().getImplementationVersion();
        if (s == null) {
            return "unknown";
        }
        int k = s.indexOf(40);
        return s.substring(k + 1, s.length() - 1);
    }

    public static int getBuildVersion() {
        return Version.numbers()[3];
    }

    public static int getMajorVersion() {
        return Version.numbers()[0];
    }

    public static int getMicroVersion() {
        return Version.numbers()[2];
    }

    public static int getMinorVersion() {
        return Version.numbers()[1];
    }

    private static Package getPackage() {
        return Package.getPackage("cern.colt");
    }

    public static void main(String[] args) {
        System.out.println(Version.asString());
    }

    private static int[] numbers() {
        int w = 4;
        int[] numbers = new int[]{0, 6, 0, 0};
        return numbers;
    }
}

