/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key.passwd.swing;

import de.schlichtherle.awt.EventDispatchTimeoutException;
import de.schlichtherle.awt.EventQueue;
import de.schlichtherle.key.KeyPromptingInterruptedException;
import de.schlichtherle.key.KeyPromptingTimeoutException;
import de.schlichtherle.key.PromptingKeyProvider;
import de.schlichtherle.key.passwd.swing.CreateKeyPanel;
import de.schlichtherle.key.passwd.swing.Feedback;
import de.schlichtherle.key.passwd.swing.OpenKeyPanel;
import de.schlichtherle.key.passwd.swing.PromptingKeyManager;
import java.awt.Window;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class PromptingKeyProviderUI
implements de.schlichtherle.key.PromptingKeyProviderUI {
    private static final String PACKAGE_NAME;
    private static final String CLASS_NAME;
    private static final ResourceBundle resources;
    private static final Logger logger;
    private static final long START_PROMPTING_TIMEOUT = 1000L;
    public static final int KEY_FILE_LEN = 512;
    private static final Map openKeyPanels;
    static String lastResourceID;
    private CreateKeyPanel createKeyPanel;
    private OpenKeyPanel openKeyPanel;
    private Feedback unknownCreateKeyFeedback;
    private Feedback invalidCreateKeyFeedback;
    private Feedback unknownOpenKeyFeedback;
    private Feedback invalidOpenKeyFeedback;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readKeyFile(String pathname) throws IOException {
        byte[] buf = new byte[512];
        RandomAccessFile raf = new RandomAccessFile(pathname, "r");
        try {
            raf.readFully(buf);
        }
        finally {
            raf.close();
        }
        return buf;
    }

    protected CreateKeyPanel getCreateKeyPanel() {
        if (this.createKeyPanel == null) {
            this.createKeyPanel = this.createCreateKeyPanel();
        }
        return this.createKeyPanel;
    }

    protected CreateKeyPanel createCreateKeyPanel() {
        return new CreateKeyPanel();
    }

    protected OpenKeyPanel getOpenKeyPanel() {
        if (this.openKeyPanel == null) {
            this.openKeyPanel = this.createOpenKeyPanel();
        }
        return this.openKeyPanel;
    }

    protected OpenKeyPanel createOpenKeyPanel() {
        return new OpenKeyPanel();
    }

    protected Feedback getUnknownCreateKeyFeedback() {
        if (this.unknownCreateKeyFeedback == null) {
            this.unknownCreateKeyFeedback = PromptingKeyProviderUI.createFeedback("UnknownCreateKeyFeedback");
        }
        return this.unknownCreateKeyFeedback;
    }

    protected void setUnkownCreateKeyFeedback(Feedback uckf) {
        this.unknownCreateKeyFeedback = uckf;
    }

    protected Feedback getInvalidCreateKeyFeedback() {
        if (this.invalidCreateKeyFeedback == null) {
            this.invalidCreateKeyFeedback = PromptingKeyProviderUI.createFeedback("InvalidCreateKeyFeedback");
        }
        return this.invalidCreateKeyFeedback;
    }

    protected void setInvalidCreateKeyFeedback(Feedback ickf) {
        this.invalidCreateKeyFeedback = ickf;
    }

    protected Feedback getUnknownOpenKeyFeedback() {
        if (this.unknownOpenKeyFeedback == null) {
            this.unknownOpenKeyFeedback = PromptingKeyProviderUI.createFeedback("UnknownOpenKeyFeedback");
        }
        return this.unknownOpenKeyFeedback;
    }

    protected void setUnknownOpenKeyFeedback(Feedback uokf) {
        this.unknownOpenKeyFeedback = uokf;
    }

    protected Feedback getInvalidOpenKeyFeedback() {
        if (this.invalidOpenKeyFeedback == null) {
            this.invalidOpenKeyFeedback = PromptingKeyProviderUI.createFeedback("InvalidOpenKeyFeedback");
        }
        return this.invalidOpenKeyFeedback;
    }

    protected void setInvalidOpenKeyFeedback(Feedback iokf) {
        this.invalidOpenKeyFeedback = iokf;
    }

    private static Feedback createFeedback(String type) {
        try {
            String n = System.getProperty(PACKAGE_NAME + "." + type, PACKAGE_NAME + ".Basic" + type);
            Thread t = Thread.currentThread();
            ClassLoader l = t.getContextClassLoader();
            Class<?> c = l.loadClass(n);
            Feedback f = (Feedback)c.newInstance();
            return f;
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.WARNING, "", ex);
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.WARNING, "", ex);
        }
        catch (InstantiationException ex) {
            logger.log(Level.WARNING, "", ex);
        }
        return null;
    }

    public final void promptCreateKey(final PromptingKeyProvider provider) {
        Runnable task = new Runnable(){

            public void run() {
                PromptingKeyProviderUI.this.promptCreateKey(provider, null);
            }
        };
        PromptingKeyProviderUI.multiplexOnEDT(task);
    }

    public final boolean promptUnknownOpenKey(final PromptingKeyProvider provider) {
        BooleanRunnable task = new BooleanRunnable(){

            public void run() {
                this.result = PromptingKeyProviderUI.this.promptOpenKey(provider, false, null);
            }
        };
        PromptingKeyProviderUI.multiplexOnEDT(task);
        return task.result;
    }

    public final boolean promptInvalidOpenKey(final PromptingKeyProvider provider) {
        BooleanRunnable task = new BooleanRunnable(){

            public void run() {
                this.result = PromptingKeyProviderUI.this.promptOpenKey(provider, true, null);
            }
        };
        PromptingKeyProviderUI.multiplexOnEDT(task);
        return task.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void promptCreateKey(PromptingKeyProvider provider, JComponent extraDataUI) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        CreateKeyPanel createKeyPanel = this.createCreateKeyPanel();
        createKeyPanel.setExtraDataUI(extraDataUI);
        Window parent = PromptingKeyManager.getParentWindow();
        try {
            while (!Thread.interrupted()) {
                int result;
                createKeyPanel.setResourceID(provider.getResourceID());
                createKeyPanel.setFeedback(createKeyPanel.getError() != null ? this.getInvalidCreateKeyFeedback() : this.getUnknownCreateKeyFeedback());
                try {
                    result = JOptionPane.showConfirmDialog(parent, createKeyPanel, resources.getString("newPasswdDialog.title"), 2, 3);
                }
                catch (StackOverflowError failure) {
                    boolean interrupted = Thread.interrupted();
                    if (!$assertionsDisabled && !interrupted) {
                        throw new AssertionError();
                    }
                    break;
                }
                if (Thread.interrupted()) {
                    break;
                }
                if (result != 0) {
                    break;
                }
                Object createKey = createKeyPanel.getCreateKey();
                if (createKey != null) {
                    provider.setKey(createKey);
                    break;
                }
                if (!$assertionsDisabled && createKeyPanel.getError() == null) {
                    throw new AssertionError();
                }
            }
        }
        finally {
            PromptingKeyProviderUI.eventuallyDispose(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean promptOpenKey(PromptingKeyProvider provider, boolean invalid, JComponent extraDataUI) {
        OpenKeyPanel openKeyPanel;
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (invalid) {
            OpenKeyPanel panel = (OpenKeyPanel)openKeyPanels.get(provider);
            openKeyPanel = panel != null ? panel : this.createOpenKeyPanel();
            openKeyPanel.setError(resources.getString("invalidKey"));
        } else {
            openKeyPanel = this.createOpenKeyPanel();
            openKeyPanel.setExtraDataUI(extraDataUI);
        }
        openKeyPanels.put(provider, openKeyPanel);
        Window parent = PromptingKeyManager.getParentWindow();
        try {
            while (!Thread.interrupted()) {
                int result;
                openKeyPanel.setResourceID(provider.getResourceID());
                openKeyPanel.setFeedback(openKeyPanel.getError() != null ? this.getInvalidOpenKeyFeedback() : this.getUnknownOpenKeyFeedback());
                try {
                    result = JOptionPane.showConfirmDialog(parent, openKeyPanel, resources.getString("passwdDialog.title"), 2, 3);
                }
                catch (StackOverflowError failure) {
                    boolean interrupted = Thread.interrupted();
                    if (!$assertionsDisabled && !interrupted) {
                        throw new AssertionError();
                    }
                    break;
                }
                if (Thread.interrupted()) {
                    break;
                }
                if (result != 0) {
                    provider.setKey(null);
                    break;
                }
                Object openKey = openKeyPanel.getOpenKey();
                if (openKey != null) {
                    provider.setKey(openKey);
                    break;
                }
                if (!$assertionsDisabled && openKeyPanel.getError() == null) {
                    throw new AssertionError();
                }
            }
        }
        finally {
            PromptingKeyProviderUI.eventuallyDispose(parent);
        }
        return openKeyPanel.isKeyChangeRequested();
    }

    private static void eventuallyDispose(Window window) {
        if (!window.isShowing()) {
            window.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void multiplexOnEDT(Runnable task) {
        if (Thread.interrupted()) {
            throw new UndeclaredThrowableException(new KeyPromptingInterruptedException());
        }
        if (EventQueue.isDispatchThread()) {
            task.run();
        } else {
            Class clazz = PromptingKeyProviderUI.class;
            synchronized (clazz) {
                try {
                    EventQueue.invokeAndWaitUninterruptibly(task, 1000L);
                }
                catch (EventDispatchTimeoutException failure) {
                    throw new UndeclaredThrowableException(new KeyPromptingTimeoutException(failure));
                }
                catch (InvocationTargetException failure) {
                    throw new UndeclaredThrowableException(failure);
                }
                finally {
                    Thread.interrupted();
                }
            }
        }
    }

    static {
        $assertionsDisabled = !PromptingKeyProviderUI.class.desiredAssertionStatus();
        PACKAGE_NAME = "de/schlichtherle/key/passwd/swing".replace('/', '.');
        CLASS_NAME = PACKAGE_NAME + "/PromptingKeyProviderUI".replace('/', '.');
        resources = ResourceBundle.getBundle(CLASS_NAME);
        logger = Logger.getLogger(CLASS_NAME);
        openKeyPanels = new WeakHashMap();
        lastResourceID = "";
    }

    private static abstract class BooleanRunnable
    implements Runnable {
        public boolean result;

        private BooleanRunnable() {
        }
    }
}

