/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.patterns.cluster;

import ca.pfv.spmf.patterns.cluster.DoubleArray;
import java.util.ArrayList;
import java.util.List;

public class Cluster {
    private List<DoubleArray> vectors = new ArrayList<DoubleArray>();
    private DoubleArray mean;
    private DoubleArray sum;

    public Cluster(int vectorsSize) {
        this.sum = new DoubleArray(new double[vectorsSize]);
    }

    public void setMean(DoubleArray mean) {
        this.mean = mean;
    }

    public void addVector(DoubleArray vector) {
        this.vectors.add(vector);
        for (int i = 0; i < vector.data.length; ++i) {
            int n = i;
            this.sum.data[n] = this.sum.data[n] + vector.data[i];
        }
    }

    public DoubleArray getmean() {
        return this.mean;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.vectors.size() >= 1) {
            for (DoubleArray vector : this.vectors) {
                buffer.append("[");
                buffer.append(vector.toString());
                buffer.append("]");
            }
        }
        return buffer.toString();
    }

    public void recomputeClusterMean() {
        for (int i = 0; i < this.sum.data.length; ++i) {
            this.mean.data[i] = this.sum.data[i] / (double)this.vectors.size();
        }
    }

    public List<DoubleArray> getVectors() {
        return this.vectors;
    }

    public void remove(DoubleArray vector) {
        this.vectors.remove(vector);
        for (int i = 0; i < vector.data.length; ++i) {
            int n = i;
            this.sum.data[n] = this.sum.data[n] - vector.data[i];
        }
    }

    public void removeVector(DoubleArray vector) {
        this.vectors.add(vector);
    }

    public boolean contains(DoubleArray vector) {
        return this.vectors.contains(vector);
    }
}

