/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP;

import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.EquivalenceClass;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.abstractions.ItemAbstractionPair;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.creators.AbstractionCreator_Qualitative;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.creators.ItemAbstractionPairCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.patterns.Pattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.patterns.PatternCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.idLists.IDList;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.savers.Saver;
import java.util.ArrayList;
import java.util.List;

public class FrequentPatternEnumeration_SPAM {
    private double minSupportAbsolute;
    private int frequentPatterns = 0;
    private final PatternCreator patternCreator;
    private Saver saver;

    public FrequentPatternEnumeration_SPAM(double minSupportAbsolute, Saver saver) {
        this.minSupportAbsolute = minSupportAbsolute;
        this.patternCreator = PatternCreator.getInstance();
        this.saver = saver;
    }

    public void execute(EquivalenceClass equivalenceClass, boolean keepPatterns, boolean verbose) {
        int numberOfMembersInEC = equivalenceClass.getClassMembers().size();
        for (int i = 0; i < numberOfMembersInEC; ++i) {
            EquivalenceClass ec = equivalenceClass.getIthMember(i);
            this.dfs_pruning(ec, equivalenceClass.getClassMembers(), equivalenceClass.getClassMembers(), i + 1, keepPatterns);
        }
    }

    private void dfs_pruning(EquivalenceClass currentClass, List<EquivalenceClass> sequenceExtensions, List<EquivalenceClass> itemsetsExtensions, int beginning, boolean keepPatterns) {
        ++this.frequentPatterns;
        Pattern classIdentifier = currentClass.getClassIdentifier();
        ArrayList<EquivalenceClass> new_sequenceExtension = new ArrayList<EquivalenceClass>();
        ArrayList<EquivalenceClass> new_itemsetExtension = new ArrayList<EquivalenceClass>();
        ArrayList<EquivalenceClass> new_classes = new ArrayList<EquivalenceClass>();
        Pattern clone = classIdentifier.clonePattern();
        for (EquivalenceClass eq : sequenceExtensions) {
            Pattern extension = this.patternCreator.createPattern(new ArrayList<ItemAbstractionPair>(clone.getElements()));
            ItemAbstractionPair newPair = eq.getClassIdentifier().getLastElement();
            extension.add(newPair);
            IDList newIdList = currentClass.getIdList().join(eq.getIdList(), false, (int)this.minSupportAbsolute);
            if (!((double)newIdList.getSupport() >= this.minSupportAbsolute)) continue;
            newIdList.setAppearingSequences(extension);
            if (keepPatterns) {
                this.saver.savePattern(extension);
            }
            EquivalenceClass newClass = new EquivalenceClass(extension);
            newClass.setIdList(newIdList);
            new_classes.add(newClass);
            EquivalenceClass newEq = new EquivalenceClass(eq.getClassIdentifier(), newIdList);
            new_sequenceExtension.add(newEq);
        }
        int sequenceExtensionSize = new_sequenceExtension.size();
        for (int i = 0; i < sequenceExtensionSize; ++i) {
            EquivalenceClass newClass = (EquivalenceClass)new_classes.get(i);
            this.dfs_pruning(newClass, new_sequenceExtension, new_sequenceExtension, i + 1, keepPatterns);
            newClass.clear();
        }
        new_classes.clear();
        for (int k = beginning; k < itemsetsExtensions.size(); ++k) {
            EquivalenceClass eq = itemsetsExtensions.get(k);
            Pattern extension = this.patternCreator.createPattern(new ArrayList<ItemAbstractionPair>(clone.getElements()));
            ItemAbstractionPair newPair = ItemAbstractionPairCreator.getInstance().getItemAbstractionPair(eq.getClassIdentifier().getLastElement().getItem(), AbstractionCreator_Qualitative.getInstance().createAbstraction(true));
            extension.add(newPair);
            IDList newIdList = currentClass.getIdList().join(eq.getIdList(), true, (int)this.minSupportAbsolute);
            if (!((double)newIdList.getSupport() >= this.minSupportAbsolute)) continue;
            newIdList.setAppearingSequences(extension);
            if (keepPatterns) {
                this.saver.savePattern(extension);
            }
            EquivalenceClass newClass = new EquivalenceClass(extension);
            newClass.setIdList(newIdList);
            new_classes.add(newClass);
            EquivalenceClass newEq = new EquivalenceClass(eq.getClassIdentifier(), newIdList);
            new_itemsetExtension.add(newEq);
        }
        int itemsetExtensionSize = new_itemsetExtension.size();
        for (int i = 0; i < itemsetExtensionSize; ++i) {
            EquivalenceClass newClass = (EquivalenceClass)new_classes.get(i);
            this.dfs_pruning(newClass, new_sequenceExtension, new_itemsetExtension, i + 1, keepPatterns);
            newClass.clear();
        }
    }

    public int getFrequentPatterns() {
        return this.frequentPatterns;
    }

    public void setFrequentPatterns(int frequentPatterns) {
        this.frequentPatterns = frequentPatterns;
    }
}

