/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP;

import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.RecursionPrefixSpan_AGP;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.Item;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.PseudoSequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.PseudoSequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.Sequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.creators.AbstractionCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.savers.Saver;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.savers.SaverIntoFile;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.savers.SaverIntoMemory;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.IOException;
import java.util.BitSet;
import java.util.Map;

public class AlgoPrefixSpan_AGP {
    protected double minSupRelative;
    protected double minSupAbsolute;
    protected SequenceDatabase originalDataset;
    Saver saver = null;
    protected long start;
    protected long end;
    private AbstractionCreator abstractionCreator;
    private int numberOfFrequentPatterns = 0;

    public AlgoPrefixSpan_AGP(double minsupRelative, AbstractionCreator creator) {
        this.minSupRelative = minsupRelative;
        this.abstractionCreator = creator;
    }

    public void runAlgorithm(SequenceDatabase database, boolean keepPatterns, boolean verbose, String outputFilePath) throws IOException {
        this.minSupAbsolute = (int)Math.ceil(this.minSupRelative * (double)database.size());
        if (this.minSupAbsolute == 0.0) {
            this.minSupAbsolute = 1.0;
        }
        MemoryLogger.getInstance().reset();
        this.start = System.currentTimeMillis();
        this.prefixSpan(database, keepPatterns, verbose, outputFilePath);
        this.end = System.currentTimeMillis();
        this.saver.finish();
    }

    protected void prefixSpan(SequenceDatabase database, boolean keepPatterns, boolean verbose, String outputFilePath) throws IOException {
        this.saver = outputFilePath == null ? new SaverIntoMemory() : new SaverIntoFile(outputFilePath);
        Map<Item, BitSet> mapSequenceID = database.getFrequentItems();
        PseudoSequenceDatabase pseudoDatabase = this.projectInitialDatabase(database, mapSequenceID, (int)this.minSupAbsolute);
        RecursionPrefixSpan_AGP algorithm = new RecursionPrefixSpan_AGP(this.abstractionCreator, this.saver, (int)this.minSupAbsolute, pseudoDatabase, mapSequenceID);
        algorithm.execute(keepPatterns, verbose);
        this.numberOfFrequentPatterns = algorithm.numberOfFrequentPatterns();
        MemoryLogger.getInstance().checkMemory();
    }

    public String printStatistics() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("=============  Algorithm - STATISTICS =============\n Total time ~ ");
        sb.append(this.getRunningTime());
        sb.append(" ms\n");
        sb.append(" Frequent sequences count : ");
        sb.append(this.numberOfFrequentPatterns);
        sb.append('\n');
        sb.append(" Max memory (mb):");
        sb.append(MemoryLogger.getInstance().getMaxMemory());
        sb.append('\n');
        sb.append(this.saver.print());
        sb.append('\n');
        sb.append("===================================================\n");
        return sb.toString();
    }

    public int getNumberOfFrequentPatterns() {
        return this.numberOfFrequentPatterns;
    }

    public long getRunningTime() {
        return this.end - this.start;
    }

    public double getAbsoluteMinSupport() {
        return this.minSupAbsolute;
    }

    private PseudoSequenceDatabase projectInitialDatabase(SequenceDatabase database, Map<Item, BitSet> mapSequenceID, long minSupportAbsolute) {
        PseudoSequenceDatabase initialContext = new PseudoSequenceDatabase();
        for (Sequence sequence : database.getSequences()) {
            Sequence optimizedSequence = sequence.cloneSequenceMinusItems(mapSequenceID, minSupportAbsolute);
            if (optimizedSequence.size() == 0) continue;
            PseudoSequence pseudoSequence = new PseudoSequence(0L, optimizedSequence, 0, 0);
            initialContext.addSequence(pseudoSequence);
        }
        return initialContext;
    }

    public void clear() {
        if (this.originalDataset != null) {
            this.originalDataset.clear();
            this.originalDataset = null;
        }
        if (this.saver != null) {
            this.saver.clear();
            this.saver = null;
        }
        this.abstractionCreator = null;
    }
}

