/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalsequentialpatterns;

import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalsequentialpatterns.MDSequence;
import java.util.ArrayList;
import java.util.List;

public class MDSequences {
    private final List<List<MDSequence>> levels = new ArrayList<List<MDSequence>>();
    private int sequencesCount = 0;
    private final String name;

    public MDSequences(String name) {
        this.name = name;
        this.levels.add(new ArrayList());
    }

    public void printPatterns(int sequenceCount) {
        System.out.println(" ------- " + this.name + " -------");
        int levelCount = 0;
        for (List<MDSequence> level : this.levels) {
            System.out.println("  L" + levelCount + " ");
            for (MDSequence sequence : level) {
                System.out.print("  pattern " + sequence.getId() + ":  ");
                sequence.print();
                System.out.print("support :  " + sequence.getFormattedRelativeSupport(sequenceCount));
                System.out.print(" (" + sequence.getAbsoluteSupport() + "/" + sequenceCount + ") ");
                System.out.println("");
            }
            ++levelCount;
        }
        System.out.println(" --------------------------------");
    }

    public String toString(int sequenceCount) {
        StringBuffer out = new StringBuffer(" ------- " + this.name + " -------");
        int levelCount = 0;
        for (List<MDSequence> level : this.levels) {
            out.append("  L" + levelCount + "\n");
            for (MDSequence sequence : level) {
                out.append("  pattern " + sequence.getId() + ":  \n");
                out.append(sequence.toString());
                out.append("support :  " + sequence.getFormattedRelativeSupport(sequenceCount));
                out.append(" (" + sequence.getAbsoluteSupport() + "/" + sequenceCount + ") \n");
            }
            ++levelCount;
        }
        out.append(" --------------------------------");
        return out.toString();
    }

    public void addSequence(MDSequence sequence, int k) {
        while (this.levels.size() <= k) {
            this.levels.add(new ArrayList());
        }
        this.levels.get(k).add(sequence);
        ++this.sequencesCount;
    }

    public List<MDSequence> getLevel(int k) {
        return this.levels.get(k);
    }

    public int size() {
        return this.sequencesCount;
    }

    public List<List<MDSequence>> getLevels() {
        return this.levels;
    }

    public void recalculateSize() {
        this.sequencesCount = 0;
        for (List<MDSequence> level : this.levels) {
            this.sequencesCount += level.size();
        }
    }
}

