/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalsequentialpatterns;

import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Sequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns.MDPattern;
import java.text.DecimalFormat;

public class MDSequence {
    private final Sequence sequence;
    private final MDPattern mdpattern;
    private final int id;
    private int support = 0;

    public MDSequence(int id, MDPattern mdpattern, Sequence sequence) {
        this.id = id;
        this.sequence = sequence;
        this.mdpattern = mdpattern;
        sequence.setID(id);
        mdpattern.setID(id);
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public MDPattern getMdpattern() {
        return this.mdpattern;
    }

    public int getId() {
        return this.id;
    }

    public double getRelativeSupport(int databaseSize) {
        return (double)this.support / (double)databaseSize;
    }

    public int getAbsoluteSupport() {
        return this.support;
    }

    public String getFormattedRelativeSupport(int databaseSize) {
        double supportAsDouble = (double)this.support / (double)databaseSize;
        DecimalFormat format = new DecimalFormat();
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(5);
        return format.format(supportAsDouble);
    }

    public void print() {
        System.out.print("MDSequence " + this.id + ": ");
        this.mdpattern.print();
        this.sequence.print();
    }

    public String toString() {
        String out = "MDSequence " + this.id + ": ";
        out = out + this.mdpattern.toString();
        out = out + this.sequence.toString();
        return out;
    }

    public void setSupport(int transactioncount) {
        this.support = transactioncount;
    }

    boolean strictlyContains(MDSequence sequence2) {
        int patternContains = this.getMdpattern().strictlyContains(sequence2.getMdpattern());
        int sequenceContains = this.getSequence().strictlyContains(sequence2.getSequence());
        if (patternContains == 2 && sequenceContains == 2) {
            return false;
        }
        return patternContains != 0 && sequenceContains != 0;
    }

    boolean contains(MDSequence sequence2) {
        int patternContains = this.getMdpattern().strictlyContains(sequence2.getMdpattern());
        int sequenceContains = this.getSequence().strictlyContains(sequence2.getSequence());
        return patternContains != 0 && sequenceContains != 0;
    }
}

