/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim;

import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.AbstractAlgoPrefixSpan;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.ItemSimple;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.ItemValued;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Pair;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.PseudoSequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.PseudoSequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Sequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Sequences;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.kmeans_for_fournier08.AlgoKMeansWithSupport;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.kmeans_for_fournier08.Cluster;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoFournierViger08
extends AbstractAlgoPrefixSpan {
    private Sequences patterns = null;
    int patternCount = 0;
    private long startTime;
    private long endTime;
    private final double minInterval;
    private final double maxInterval;
    private final double minWholeInterval;
    private final double maxWholeInterval;
    private final double minsupp;
    private final boolean findClosedPatterns;
    private int minsuppRelative;
    private boolean enableBackscanPruning;
    private final AlgoKMeansWithSupport algoClustering;
    private PseudoSequenceDatabase initialDatabase = null;
    BufferedWriter writer = null;

    public AlgoFournierViger08(double minsupp, double minInterval, double maxInterval, double minWholeInterval, double maxWholeInterval, AlgoKMeansWithSupport algoClustering, boolean findClosedPatterns, boolean enableBackscanPruning) {
        if (minInterval > maxInterval || minWholeInterval > maxWholeInterval || minInterval > maxWholeInterval || maxInterval > maxWholeInterval) {
            throw new RuntimeException("Parameters are not valid!!!");
        }
        this.minInterval = minInterval;
        this.maxInterval = maxInterval;
        this.minWholeInterval = minWholeInterval;
        this.maxWholeInterval = maxWholeInterval;
        this.algoClustering = algoClustering;
        this.minsupp = minsupp;
        this.findClosedPatterns = findClosedPatterns;
        this.enableBackscanPruning = enableBackscanPruning;
    }

    public void runAlgorithm(SequenceDatabase database, String outputFilePath) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(outputFilePath));
        this.patterns = null;
        this.runAlgorithm(database);
        this.writer.close();
        this.writer = null;
    }

    @Override
    public Sequences runAlgorithm(SequenceDatabase database) throws IOException {
        if (this.writer == null) {
            this.patterns = new Sequences("FREQUENT SEQUENCES WITH TIME + CLUSTERING");
        }
        this.patternCount = 0;
        this.minsuppRelative = (int)Math.ceil(this.minsupp * (double)database.size());
        if (this.minsuppRelative == 0) {
            this.minsuppRelative = 1;
        }
        this.startTime = System.currentTimeMillis();
        this.isdb(database);
        this.endTime = System.currentTimeMillis();
        return this.patterns;
    }

    private void isdb(SequenceDatabase originalDatabase) throws IOException {
        Map<ItemSimple, Set<Integer>> mapSequenceID = this.findSequencesContainingItems(originalDatabase);
        this.initialDatabase = new PseudoSequenceDatabase();
        for (Sequence sequence : originalDatabase.getSequences()) {
            Sequence optimizedSequence = sequence.cloneSequenceMinusItems(mapSequenceID, this.minsuppRelative);
            if (optimizedSequence.size() == 0) continue;
            this.initialDatabase.addSequence(new PseudoSequence(0L, optimizedSequence, 0, 0));
        }
        for (Map.Entry entry : mapSequenceID.entrySet()) {
            if (((Set)entry.getValue()).size() < this.minsuppRelative) continue;
            ItemSimple item = (ItemSimple)entry.getKey();
            PseudoSequenceDatabase[] projectedContexts = null;
            projectedContexts = item instanceof ItemValued ? this.buildProjectedContextItemValued((ItemValued)item, this.initialDatabase, false, -1L) : this.buildProjectedDatabase(item, this.initialDatabase, false, -1L);
            for (PseudoSequenceDatabase projectedDatabase : projectedContexts) {
                boolean noBackwardExtension;
                Sequence prefix = new Sequence(0);
                if (projectedDatabase.getCluster() == null) {
                    prefix.addItemset(new Itemset(item, 0L));
                    prefix.setSequencesID((Set)entry.getValue());
                } else {
                    ItemValued item2 = new ItemValued(((ItemSimple)entry.getKey()).getId(), projectedDatabase.getCluster().getaverage(), projectedDatabase.getCluster().getLower(), projectedDatabase.getCluster().getHigher());
                    prefix.addItemset(new Itemset(item2, 0L));
                    prefix.setSequencesID(projectedDatabase.getCluster().getSequenceIDs());
                }
                int maxSuccessorSupport = 0;
                if (!this.findClosedPatterns || !this.checkBackScanPruning(prefix)) {
                    maxSuccessorSupport = this.projection(prefix, 2, projectedDatabase);
                }
                if (!this.isMinWholeIntervalRespected(prefix)) continue;
                boolean noForwardSIExtension = !this.findClosedPatterns || prefix.getAbsoluteSupport() != maxSuccessorSupport;
                boolean bl = noBackwardExtension = !this.findClosedPatterns || !this.checkBackwardExtension(prefix);
                if (!noForwardSIExtension || !noBackwardExtension) continue;
                this.savePattern(prefix);
            }
        }
    }

    private void savePattern(Sequence prefix) throws IOException {
        ++this.patternCount;
        if (this.writer != null) {
            StringBuffer r = new StringBuffer("");
            for (Itemset itemset : prefix.getItemsets()) {
                r.append('<');
                r.append(itemset.getTimestamp());
                r.append("> ");
                for (ItemSimple item : itemset.getItems()) {
                    String string = item.toString();
                    r.append(string);
                    r.append(' ');
                }
                r.append("-1 ");
            }
            r.append(" #SUP: ");
            r.append(prefix.getSequencesID().size());
            this.writer.write(r.toString());
            this.writer.newLine();
        } else {
            this.patterns.addSequence(prefix, prefix.size());
        }
    }

    private boolean checkBackwardExtension(Sequence prefix) {
        for (int i = 0; i < prefix.getItemOccurencesTotalCount(); ++i) {
            ArrayList<PseudoSequence> maximumPeriods = new ArrayList<PseudoSequence>();
            for (PseudoSequence sequence : this.initialDatabase.getPseudoSequences()) {
                if (!prefix.getSequencesID().contains(sequence.getId())) continue;
                List<PseudoSequence> periods = sequence.getAllIthMaxPeriodOfAPrefix(prefix, i, true);
                for (PseudoSequence period : periods) {
                    if (period == null) continue;
                    maximumPeriods.add(period);
                }
            }
            for (Pair pair : this.findAllFrequentPairsSatisfyingC1andC2ForBackwardExtensionCheck(prefix, maximumPeriods, i)) {
                if (pair.getCount() != prefix.getAbsoluteSupport()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkBackScanPruning(Sequence prefix) {
        if (!this.enableBackscanPruning) {
            return false;
        }
        for (int i = 0; i < prefix.getItemOccurencesTotalCount(); ++i) {
            ArrayList<PseudoSequence> semimaximumPeriods = new ArrayList<PseudoSequence>();
            for (PseudoSequence sequence : this.initialDatabase.getPseudoSequences()) {
                PseudoSequence period;
                if (!prefix.getSequencesID().contains(sequence.getId()) || (period = sequence.getIthSemiMaximumPeriodOfAPrefix(prefix, i, true)) == null) continue;
                semimaximumPeriods.add(period);
            }
            Set<Pair> paires = this.findAllFrequentPairsSatisfyingC1andC2ForBackwardExtensionCheck(prefix, semimaximumPeriods, i);
            for (Pair pair : paires) {
                if (pair.getCount() != prefix.getAbsoluteSupport()) continue;
                return true;
            }
        }
        return false;
    }

    protected Set<Pair> findAllFrequentPairsSatisfyingC1andC2ForBackwardExtensionCheck(Sequence prefix, List<PseudoSequence> maximumPeriods, int iPeriod) {
        HashMap<Pair, Pair> mapPaires = new HashMap<Pair, Pair>();
        HashSet<Pair> alreadyCountedForSequenceID = new HashSet<Pair>();
        PseudoSequence lastPeriod = null;
        for (PseudoSequence period : maximumPeriods) {
            if (period != lastPeriod) {
                alreadyCountedForSequenceID.clear();
                lastPeriod = period;
            }
            for (int i = 0; i < period.size(); ++i) {
                for (int j = 0; j < period.getSizeOfItemsetAt(i); ++j) {
                    boolean checkWholeInterval;
                    ItemSimple item = period.getItemAtInItemsetAt(j, i);
                    long successorInterval = period.getTimeSucessor() - period.getAbsoluteTimeStamp(i);
                    long totalTime = prefix.getTimeLength() + successorInterval;
                    long predecessorInterval = period.getAbsoluteTimeStamp(i) - period.getTimePredecessor();
                    boolean checkGapSucessor = (double)successorInterval >= this.minInterval && (double)successorInterval <= this.maxInterval || successorInterval == 0L;
                    boolean checkGapPredecesseur = (double)predecessorInterval >= this.minInterval && (double)predecessorInterval <= this.maxInterval || iPeriod == 0 || predecessorInterval == 0L;
                    boolean bl = checkWholeInterval = (double)totalTime <= this.maxWholeInterval && (double)totalTime >= this.minWholeInterval || iPeriod != 0;
                    if (!checkGapSucessor || !checkGapPredecesseur || !checkWholeInterval) continue;
                    Pair pair = new Pair(successorInterval, period.isCutAtRight(i), period.isCutAtLeft(i), item);
                    Pair oldpair = (Pair)mapPaires.get(pair);
                    if (alreadyCountedForSequenceID.contains(pair)) continue;
                    if (oldpair == null) {
                        mapPaires.put(pair, pair);
                    } else {
                        pair = oldpair;
                    }
                    alreadyCountedForSequenceID.add(pair);
                    pair.getSequencesID().add(period.getId());
                }
            }
        }
        return mapPaires.keySet();
    }

    private Map<ItemSimple, Set<Integer>> findSequencesContainingItems(SequenceDatabase contexte) {
        HashSet<Integer> alreadyCounted = new HashSet<Integer>();
        Sequence lastSequence = null;
        HashMap<ItemSimple, Set<Integer>> mapSequenceID = new HashMap<ItemSimple, Set<Integer>>();
        for (Sequence sequence : contexte.getSequences()) {
            if (lastSequence == null || lastSequence.getId() != sequence.getId()) {
                alreadyCounted.clear();
                lastSequence = sequence;
            }
            for (Itemset itemset : sequence.getItemsets()) {
                for (ItemSimple item : itemset.getItems()) {
                    if (alreadyCounted.contains(item.getId())) continue;
                    HashSet<Integer> sequenceIDs = (HashSet<Integer>)mapSequenceID.get(item);
                    if (sequenceIDs == null) {
                        sequenceIDs = new HashSet<Integer>();
                        mapSequenceID.put(item, sequenceIDs);
                    }
                    sequenceIDs.add(sequence.getId());
                    alreadyCounted.add(item.getId());
                }
            }
        }
        return mapSequenceID;
    }

    private int projection(Sequence prefix, int k, PseudoSequenceDatabase database) throws IOException {
        int maxSupport = 0;
        for (Pair pair : this.findAllFrequentPairsSatisfyingC1andC2(prefix, database.getPseudoSequences())) {
            int successorSupport;
            Sequence newPrefix;
            if (pair.getCount() < this.minsuppRelative || !this.isMaxWholeIntervalRespected(newPrefix = pair.isPostfix() ? this.appendItemToPrefixOfSequence(prefix, pair.getItem()) : this.appendItemToSequence(prefix, pair.getItem(), pair.getTimestamp())) || (successorSupport = this.projectionPair(newPrefix, pair, prefix, database, k)) <= maxSupport) continue;
            maxSupport = successorSupport;
        }
        return maxSupport;
    }

    private boolean isTheMinAndMaxIntervalRespected(long timeInterval) {
        return (double)timeInterval >= this.minInterval && (double)timeInterval <= this.maxInterval;
    }

    private boolean isMaxWholeIntervalRespected(Sequence sequence) {
        return (double)sequence.get(sequence.size() - 1).getTimestamp() <= this.maxWholeInterval;
    }

    private boolean isMinWholeIntervalRespected(Sequence sequence) {
        return (double)sequence.get(sequence.size() - 1).getTimestamp() >= this.minWholeInterval;
    }

    private int projectionPair(Sequence newPrefix, Pair paire, Sequence oldPrefix, PseudoSequenceDatabase database, int k) throws IOException {
        int maxSupport = 0;
        PseudoSequenceDatabase[] projectedContexts = null;
        projectedContexts = paire.getItem() instanceof ItemValued ? this.buildProjectedContextItemValued((ItemValued)paire.getItem(), database, paire.isPostfix(), paire.getTimestamp()) : this.buildProjectedDatabase(paire.getItem(), database, paire.isPostfix(), paire.getTimestamp());
        for (PseudoSequenceDatabase projectedContext : projectedContexts) {
            boolean noBackwardExtension;
            Sequence prefix;
            if (projectedContext.getCluster() == null) {
                prefix = newPrefix.cloneSequence();
                prefix.setSequencesID(paire.getSequencesID());
            } else {
                ItemValued item2 = new ItemValued(projectedContext.getCluster().getItemId(), projectedContext.getCluster().getaverage(), projectedContext.getCluster().getLower(), projectedContext.getCluster().getHigher());
                Set<Integer> sequenceIDs = projectedContext.getCluster().getSequenceIDs();
                prefix = paire.isPostfix() ? this.appendItemToPrefixOfSequence(oldPrefix, item2) : this.appendItemToSequence(oldPrefix, item2, paire.getTimestamp());
                prefix.setSequencesID(sequenceIDs);
            }
            int maxSuccessor = 0;
            if (!this.findClosedPatterns || !this.checkBackScanPruning(prefix)) {
                maxSuccessor = this.projection(prefix, k + 1, projectedContext);
            }
            if (!this.isMinWholeIntervalRespected(prefix)) continue;
            boolean noForwardSIExtension = !this.findClosedPatterns || prefix.getAbsoluteSupport() != maxSuccessor;
            boolean bl = noBackwardExtension = !this.findClosedPatterns || !this.checkBackwardExtension(prefix);
            if (noForwardSIExtension && noBackwardExtension) {
                this.savePattern(prefix);
            }
            if (prefix.getAbsoluteSupport() <= maxSupport) continue;
            maxSupport = prefix.getAbsoluteSupport();
        }
        return maxSupport;
    }

    protected Set<Pair> findAllFrequentPairsSatisfyingC1andC2(Sequence prefixe, List<PseudoSequence> database) {
        HashMap<Pair, Pair> mapPaires = new HashMap<Pair, Pair>();
        PseudoSequence lastSequence = null;
        HashSet<Pair> alreadyCountedForSequenceID = new HashSet<Pair>();
        for (PseudoSequence sequence : database) {
            if (lastSequence == null || sequence.getId() != lastSequence.getId()) {
                alreadyCountedForSequenceID.clear();
                lastSequence = sequence;
            }
            for (int i = 0; i < sequence.size(); ++i) {
                for (int j = 0; j < sequence.getSizeOfItemsetAt(i); ++j) {
                    Pair paire;
                    ItemSimple item = sequence.getItemAtInItemsetAt(j, i);
                    if (!this.isTheMinAndMaxIntervalRespected(sequence.getTimeStamp(i)) && !sequence.isCutAtLeft(i) || alreadyCountedForSequenceID.contains(paire = new Pair(sequence.getTimeStamp(i), sequence.isCutAtRight(i), sequence.isCutAtLeft(i), item))) continue;
                    Pair oldPaire = (Pair)mapPaires.get(paire);
                    if (oldPaire == null) {
                        mapPaires.put(paire, paire);
                    } else {
                        paire = oldPaire;
                    }
                    alreadyCountedForSequenceID.add(paire);
                    paire.getSequencesID().add(sequence.getId());
                }
            }
        }
        return mapPaires.keySet();
    }

    private PseudoSequenceDatabase[] buildProjectedDatabase(ItemSimple item, PseudoSequenceDatabase contexte, boolean inSuffix, long timestamp) {
        PseudoSequenceDatabase sequenceDatabase = new PseudoSequenceDatabase();
        for (PseudoSequence sequence : contexte.getPseudoSequences()) {
            for (int i = 0; i < sequence.size(); ++i) {
                PseudoSequence newSequence;
                int index;
                if (timestamp != -1L && timestamp != sequence.getTimeStamp(i) || (index = sequence.indexOf(i, item.getId())) == -1 || sequence.isCutAtLeft(i) != inSuffix) continue;
                if (index != sequence.getSizeOfItemsetAt(i) - 1) {
                    newSequence = new PseudoSequence(sequence.getAbsoluteTimeStamp(i), sequence, i, index + 1);
                    if (newSequence.size() <= 0) continue;
                    sequenceDatabase.addSequence(newSequence);
                    continue;
                }
                if (i == sequence.size() - 1 || (newSequence = new PseudoSequence(sequence.getAbsoluteTimeStamp(i), sequence, i + 1, 0)).size() <= 0) continue;
                sequenceDatabase.addSequence(newSequence);
            }
        }
        return new PseudoSequenceDatabase[]{sequenceDatabase};
    }

    private PseudoSequenceDatabase[] buildProjectedContextItemValued(ItemValued item, PseudoSequenceDatabase database, boolean inSuffix, long timestamp) {
        PseudoSequenceDatabase sequenceDatabase = new PseudoSequenceDatabase();
        ArrayList<ItemValued> removedItems = new ArrayList<ItemValued>();
        ArrayList<ItemValued> removedItemsDestroyed = new ArrayList<ItemValued>();
        for (PseudoSequence sequence : database.getPseudoSequences()) {
            for (int i = 0; i < sequence.size(); ++i) {
                PseudoSequence newSequence;
                int index;
                if (timestamp != -1L && timestamp != sequence.getTimeStamp(i) || (index = sequence.indexOf(i, item.getId())) == -1 || sequence.isCutAtLeft(i) != inSuffix) continue;
                if (index != sequence.getSizeOfItemsetAt(i) - 1) {
                    newSequence = new PseudoSequence(sequence.getAbsoluteTimeStamp(i), sequence, i, index + 1);
                    if (newSequence.size() > 0) {
                        sequenceDatabase.addSequence(newSequence);
                    }
                    removedItems.add((ItemValued)sequence.getItemAtInItemsetAt(index, i));
                    continue;
                }
                if (i == sequence.size() - 1) {
                    removedItemsDestroyed.add((ItemValued)sequence.getItemAtInItemsetAt(index, i));
                    continue;
                }
                newSequence = new PseudoSequence(sequence.getAbsoluteTimeStamp(i), sequence, i + 1, 0);
                if (newSequence.size() > 0) {
                    sequenceDatabase.addSequence(newSequence);
                }
                removedItems.add((ItemValued)sequence.getItemAtInItemsetAt(index, i));
            }
        }
        return this.breakInClusters(item, database, sequenceDatabase, removedItems, removedItemsDestroyed);
    }

    private PseudoSequenceDatabase[] breakInClusters(ItemValued item, PseudoSequenceDatabase database, PseudoSequenceDatabase sequenceDatabase, List<ItemValued> removedItems, List<ItemValued> removedItemsDestroyed) {
        PseudoSequenceDatabase[] sequenceDatabases;
        if (removedItems.size() == 0 && removedItemsDestroyed.size() == 0) {
            return new PseudoSequenceDatabase[]{sequenceDatabase};
        }
        if (sequenceDatabase.getSequenceIDs().size() >= this.minsuppRelative * 2) {
            sequenceDatabases = this.createSequenceDatabasesByClusters(sequenceDatabase, removedItems);
        } else {
            sequenceDatabases = new PseudoSequenceDatabase[]{sequenceDatabase};
            Cluster cluster = new Cluster(removedItems, removedItemsDestroyed);
            cluster.addItems(removedItemsDestroyed);
            cluster.computeHigherAndLower();
            sequenceDatabase.setCluster(cluster);
        }
        this.findSequencesContainingClusters(database, sequenceDatabases, item);
        return sequenceDatabases;
    }

    private void findSequencesContainingClusters(PseudoSequenceDatabase database, PseudoSequenceDatabase[] sequenceDatabases, ItemValued item) {
        Cluster[] clusters = new Cluster[sequenceDatabases.length];
        for (int i = 0; i < sequenceDatabases.length; ++i) {
            clusters[i] = sequenceDatabases[i].getCluster();
            clusters[i].setSequenceIDs(new HashSet<Integer>());
        }
        HashSet<Cluster> alreadyCounted = new HashSet<Cluster>();
        PseudoSequence lastSequence = null;
        for (PseudoSequence sequence : database.getPseudoSequences()) {
            if (lastSequence == null || lastSequence.getId() != sequence.getId()) {
                alreadyCounted.clear();
                lastSequence = sequence;
            }
            for (int i = 0; i < sequence.size(); ++i) {
                for (int j = 0; j < sequence.getSizeOfItemsetAt(i); ++j) {
                    Cluster cluster;
                    ItemSimple item2 = sequence.getItemAtInItemsetAt(j, i);
                    if (item2.getId() != item.getId() || (cluster = this.findClusterContainingItem(clusters, (ItemValued)item2)) == null || alreadyCounted.contains(cluster)) continue;
                    cluster.getSequenceIDs().add(sequence.getId());
                    alreadyCounted.add(cluster);
                }
            }
        }
    }

    private Cluster findClusterContainingItem(Cluster[] clusters, ItemValued item) {
        for (Cluster cluster : clusters) {
            if (!cluster.containsItem(item)) continue;
            return cluster;
        }
        return null;
    }

    private PseudoSequenceDatabase[] createSequenceDatabasesByClusters(PseudoSequenceDatabase database, List<ItemValued> items) {
        for (int i = 0; i < items.size(); ++i) {
            items.get(i).setSequenceID(database.getPseudoSequences().get(i).getId());
        }
        List<Cluster> clusters = this.algoClustering.runAlgorithm(items);
        PseudoSequenceDatabase[] sequenceDatabases = new PseudoSequenceDatabase[clusters.size()];
        for (int i = 0; i < database.size(); ++i) {
            ItemValued item = items.get(i);
            int clusterIndex = clusters.indexOf(item.getCluster());
            if (clusterIndex == -1) continue;
            if (sequenceDatabases[clusterIndex] == null) {
                sequenceDatabases[clusterIndex] = new PseudoSequenceDatabase();
                sequenceDatabases[clusterIndex].setCluster(clusters.get(clusterIndex));
            }
            sequenceDatabases[clusterIndex].addSequence(database.getPseudoSequences().get(i));
        }
        return sequenceDatabases;
    }

    private Sequence appendItemToSequence(Sequence prefix, ItemSimple item, long timestamp) {
        Sequence newPrefix = prefix.cloneSequence();
        long decalage = newPrefix.get(newPrefix.size() - 1).getTimestamp();
        newPrefix.addItemset(new Itemset(item, timestamp + decalage));
        return newPrefix;
    }

    private Sequence appendItemToPrefixOfSequence(Sequence prefix, ItemSimple item) {
        Sequence newPrefix = prefix.cloneSequence();
        Itemset itemset = newPrefix.get(newPrefix.size() - 1);
        itemset.addItem(item);
        return newPrefix;
    }

    public void printStatistics() {
        StringBuffer r = new StringBuffer(200);
        r.append("=============  Algorithm - STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" Frequent sequences count : ");
        r.append(this.patternCount);
        r.append('\n');
        r.append("===================================================\n");
        System.out.println(r.toString());
    }

    public void printResult(int databaseSize) {
        StringBuffer r = new StringBuffer(200);
        r.append("=============  Algorithm - STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" Frequent sequences count : ");
        r.append(this.patternCount);
        r.append('\n');
        r.append(this.patterns.toString(databaseSize));
        r.append("===================================================\n");
        System.out.println(r.toString());
    }

    @Override
    public double getMinSupp() {
        return this.minsupp;
    }

    public int getMinsuppRelative() {
        return this.minsuppRelative;
    }
}

